/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.autopilot.v1.assistant.QueryCreator;
import com.twilio.rest.autopilot.v1.assistant.QueryDeleter;
import com.twilio.rest.autopilot.v1.assistant.QueryFetcher;
import com.twilio.rest.autopilot.v1.assistant.QueryReader;
import com.twilio.rest.autopilot.v1.assistant.QueryUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Query
extends Resource {
    private static final long serialVersionUID = 54679602157752L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Map<String, Object> results;
    private final String language;
    private final String modelBuildSid;
    private final String query;
    private final String sampleSid;
    private final String assistantSid;
    private final String sid;
    private final String status;
    private final URI url;
    private final String sourceChannel;

    public static QueryFetcher fetcher(String pathAssistantSid, String pathSid) {
        return new QueryFetcher(pathAssistantSid, pathSid);
    }

    public static QueryReader reader(String pathAssistantSid) {
        return new QueryReader(pathAssistantSid);
    }

    public static QueryCreator creator(String pathAssistantSid, String language, String query) {
        return new QueryCreator(pathAssistantSid, language, query);
    }

    public static QueryUpdater updater(String pathAssistantSid, String pathSid) {
        return new QueryUpdater(pathAssistantSid, pathSid);
    }

    public static QueryDeleter deleter(String pathAssistantSid, String pathSid) {
        return new QueryDeleter(pathAssistantSid, pathSid);
    }

    public static Query fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Query.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Query fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Query.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Query(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="results") Map<String, Object> results, @JsonProperty(value="language") String language, @JsonProperty(value="model_build_sid") String modelBuildSid, @JsonProperty(value="query") String query, @JsonProperty(value="sample_sid") String sampleSid, @JsonProperty(value="assistant_sid") String assistantSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="status") String status, @JsonProperty(value="url") URI url, @JsonProperty(value="source_channel") String sourceChannel) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.results = results;
        this.language = language;
        this.modelBuildSid = modelBuildSid;
        this.query = query;
        this.sampleSid = sampleSid;
        this.assistantSid = assistantSid;
        this.sid = sid;
        this.status = status;
        this.url = url;
        this.sourceChannel = sourceChannel;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Map<String, Object> getResults() {
        return this.results;
    }

    public final String getLanguage() {
        return this.language;
    }

    public final String getModelBuildSid() {
        return this.modelBuildSid;
    }

    public final String getQuery() {
        return this.query;
    }

    public final String getSampleSid() {
        return this.sampleSid;
    }

    public final String getAssistantSid() {
        return this.assistantSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getStatus() {
        return this.status;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getSourceChannel() {
        return this.sourceChannel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query other = (Query)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.results, other.results) && Objects.equals(this.language, other.language) && Objects.equals(this.modelBuildSid, other.modelBuildSid) && Objects.equals(this.query, other.query) && Objects.equals(this.sampleSid, other.sampleSid) && Objects.equals(this.assistantSid, other.assistantSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.status, other.status) && Objects.equals(this.url, other.url) && Objects.equals(this.sourceChannel, other.sourceChannel);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.results, this.language, this.modelBuildSid, this.query, this.sampleSid, this.assistantSid, this.sid, this.status, this.url, this.sourceChannel);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("results", this.results).add("language", this.language).add("modelBuildSid", this.modelBuildSid).add("query", this.query).add("sampleSid", this.sampleSid).add("assistantSid", this.assistantSid).add("sid", this.sid).add("status", this.status).add("url", this.url).add("sourceChannel", this.sourceChannel).toString();
    }
}

