/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.authy.v1.service.entity.factor;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.authy.v1.service.entity.factor.Challenge;
import org.joda.time.DateTime;

public class ChallengeCreator
extends Creator<Challenge> {
    private final String pathServiceSid;
    private final String pathIdentity;
    private final String pathFactorSid;
    private DateTime expirationDate;
    private String details;
    private String hiddenDetails;

    public ChallengeCreator(String pathServiceSid, String pathIdentity, String pathFactorSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.pathFactorSid = pathFactorSid;
    }

    public ChallengeCreator setExpirationDate(DateTime expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    public ChallengeCreator setDetails(String details) {
        this.details = details;
        return this;
    }

    public ChallengeCreator setHiddenDetails(String hiddenDetails) {
        this.hiddenDetails = hiddenDetails;
        return this;
    }

    @Override
    public Challenge create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.AUTHY.toString(), "/v1/Services/" + this.pathServiceSid + "/Entities/" + this.pathIdentity + "/Factors/" + this.pathFactorSid + "/Challenges", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Challenge creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Challenge.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.expirationDate != null) {
            request.addPostParam("ExpirationDate", this.expirationDate.toString());
        }
        if (this.details != null) {
            request.addPostParam("Details", this.details);
        }
        if (this.hiddenDetails != null) {
            request.addPostParam("HiddenDetails", this.hiddenDetails);
        }
    }
}

