/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.authy.v1.service.entity;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.authy.v1.service.entity.Factor;

public class FactorUpdater
extends Updater<Factor> {
    private final String pathServiceSid;
    private final String pathIdentity;
    private final String pathSid;
    private String authPayload;

    public FactorUpdater(String pathServiceSid, String pathIdentity, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.pathSid = pathSid;
    }

    public FactorUpdater setAuthPayload(String authPayload) {
        this.authPayload = authPayload;
        return this;
    }

    @Override
    public Factor update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.AUTHY.toString(), "/v1/Services/" + this.pathServiceSid + "/Entities/" + this.pathIdentity + "/Factors/" + this.pathSid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Factor update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Factor.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.authPayload != null) {
            request.addPostParam("AuthPayload", this.authPayload);
        }
    }
}

