/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import java.io.Serializable;
import java.util.Date;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.ui.PagedDataSource;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.jobs.StageTableRowData;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ma!B\u0001\u0003\u0001\u0011a!aD*uC\u001e,G)\u0019;b'>,(oY3\u000b\u0005\r!\u0011\u0001\u00026pENT!!\u0002\u0004\u0002\u0005UL'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0005\u0001i\u0001c\u0001\b\u0010#5\tA!\u0003\u0002\u0011\t\ty\u0001+Y4fI\u0012\u000bG/Y*pkJ\u001cW\r\u0005\u0002\u0013'5\t!!\u0003\u0002\u0015\u0005\t\t2\u000b^1hKR\u000b'\r\\3S_^$\u0015\r^1\t\u0011Y\u0001!\u0011!Q\u0001\na\tQa\u001d;pe\u0016\u001c\u0001\u0001\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\r\u000511\u000f^1ukNL!!\b\u000e\u0003\u001d\u0005\u0003\bo\u0015;biV\u001c8\u000b^8sK\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0004ti\u0006<Wm\u001d\t\u0004C-rcB\u0001\u0012)\u001d\t\u0019c%D\u0001%\u0015\t)s#\u0001\u0004=e>|GOP\u0005\u0002O\u0005)1oY1mC&\u0011\u0011FK\u0001\ba\u0006\u001c7.Y4f\u0015\u00059\u0013B\u0001\u0017.\u0005\r\u0019V-\u001d\u0006\u0003S)\u0002\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u0005Y\f$BA\u001a\u001b\u0003\r\t\u0007/[\u0005\u0003kA\u0012\u0011b\u0015;bO\u0016$\u0015\r^1\t\u0011]\u0002!\u0011!Q\u0001\na\n1bY;se\u0016tG\u000fV5nKB\u0011\u0011HO\u0007\u0002U%\u00111H\u000b\u0002\u0005\u0019>tw\rC\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0003\u0006A\u0001/Y4f'&TX\r\u0005\u0002:\u007f%\u0011\u0001I\u000b\u0002\u0004\u0013:$\u0018BA\u001f\u0010\u0011!\u0019\u0005A!A!\u0002\u0013!\u0015AC:peR\u001cu\u000e\\;n]B\u0011Q)\u0013\b\u0003\r\u001e\u0003\"a\t\u0016\n\u0005!S\u0013A\u0002)sK\u0012,g-\u0003\u0002K\u0017\n11\u000b\u001e:j]\u001eT!\u0001\u0013\u0016\t\u00115\u0003!\u0011!Q\u0001\n9\u000bA\u0001Z3tGB\u0011\u0011hT\u0005\u0003!*\u0012qAQ8pY\u0016\fg\u000eC\u0003S\u0001\u0011\u00051+\u0001\u0004=S:LGO\u0010\u000b\b)V3v\u000bW-[!\t\u0011\u0002\u0001C\u0003\u0017#\u0002\u0007\u0001\u0004C\u0003 #\u0002\u0007\u0001\u0005C\u00038#\u0002\u0007\u0001\bC\u0003>#\u0002\u0007a\bC\u0003D#\u0002\u0007A\tC\u0003N#\u0002\u0007a\nC\u0004]\u0001\t\u0007I\u0011B/\u0002\t\u0011\fG/Y\u000b\u0002=B\u0019qLY\t\u000e\u0003\u0001T!!\u0019\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002-A\"1A\r\u0001Q\u0001\ny\u000bQ\u0001Z1uC\u0002B\u0011B\u001a\u0001A\u0002\u0003\u0007I\u0011B4\u0002\u001f}\u001bH.[2fIN#\u0018mZ3JIN,\u0012\u0001\u001b\t\u0004\u000b&t\u0014B\u00016L\u0005\r\u0019V\r\u001e\u0005\nY\u0002\u0001\r\u00111A\u0005\n5\f1cX:mS\u000e,Gm\u0015;bO\u0016LEm]0%KF$\"A\\9\u0011\u0005ez\u0017B\u00019+\u0005\u0011)f.\u001b;\t\u000fI\\\u0017\u0011!a\u0001Q\u0006\u0019\u0001\u0010J\u0019\t\u0013Q\u0004\u0001\u0019!A!B\u0013A\u0017\u0001E0tY&\u001cW\rZ*uC\u001e,\u0017\nZ:!\u0011\u00151\b\u0001\"\u0011x\u0003!!\u0017\r^1TSj,W#\u0001 \t\u000be\u0004A\u0011\t>\u0002\u0013Md\u0017nY3ECR\fGcA>}}B\u0019\u0011eK\t\t\u000buD\b\u0019\u0001 \u0002\t\u0019\u0014x.\u001c\u0005\u0006\u007fb\u0004\rAP\u0001\u0003i>Dq!a\u0001\u0001\t\u0013\t)!\u0001\u0005ti\u0006<WMU8x)\r\t\u0012q\u0001\u0005\b\u0003\u0013\t\t\u00011\u0001/\u0003%\u0019H/Y4f\t\u0006$\u0018\rC\u0004\u0002\u000e\u0001!I!a\u0004\u0002\u0011=\u0014H-\u001a:j]\u001e$b!!\u0005\u0002\u0018\u0005e\u0001\u0003B\u0011\u0002\u0014EI1!!\u0006.\u0005!y%\u000fZ3sS:<\u0007BB\"\u0002\f\u0001\u0007A\t\u0003\u0004N\u0003\u0017\u0001\rA\u0014")
public class StageDataSource
extends PagedDataSource<StageTableRowData> {
    private final long currentTime;
    private final Seq<StageTableRowData> data;
    private Set<Object> _slicedStageIds;

    private Seq<StageTableRowData> data() {
        return this.data;
    }

    private Set<Object> _slicedStageIds() {
        return this._slicedStageIds;
    }

    private void _slicedStageIds_$eq(Set<Object> x$1) {
        this._slicedStageIds = x$1;
    }

    @Override
    public int dataSize() {
        return this.data().size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<StageTableRowData> sliceData(int from, int to) {
        void var3_3;
        Seq r = (Seq)this.data().slice(from, to);
        this._slicedStageIds_$eq((Set<Object>)((TraversableOnce)r.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.stageId()), Seq$.MODULE$.canBuildFrom())).toSet());
        return var3_3;
    }

    private StageTableRowData stageRow(StageData stageData) {
        String string;
        String description = (String)stageData.description().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Option<Date> option = stageData.submissionTime();
        if (option instanceof Some) {
            Some some = (Some)option;
            Date t = (Date)some.value();
            string = UIUtils$.MODULE$.formatDate(t);
        } else if (None$.MODULE$.equals(option)) {
            string = "Unknown";
        } else {
            throw new MatchError(option);
        }
        String formattedSubmissionTime = string;
        long finishTime = BoxesRunTime.unboxToLong((Object)stageData.completionTime().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.currentTime));
        Option duration = stageData.firstTaskLaunchedTime().map((Function1 & Serializable & scala.Serializable)date -> BoxesRunTime.boxToLong((long)StageDataSource.$anonfun$stageRow$4(this, finishTime, date)));
        String formattedDuration = (String)duration.map((Function1 & Serializable & scala.Serializable)d -> UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)d))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "Unknown");
        long inputRead = stageData.inputBytes();
        String inputReadWithUnit = inputRead > 0L ? Utils$.MODULE$.bytesToString(inputRead) : "";
        long outputWrite = stageData.outputBytes();
        String outputWriteWithUnit = outputWrite > 0L ? Utils$.MODULE$.bytesToString(outputWrite) : "";
        long shuffleRead = stageData.shuffleReadBytes();
        String shuffleReadWithUnit = shuffleRead > 0L ? Utils$.MODULE$.bytesToString(shuffleRead) : "";
        long shuffleWrite = stageData.shuffleWriteBytes();
        String shuffleWriteWithUnit = shuffleWrite > 0L ? Utils$.MODULE$.bytesToString(shuffleWrite) : "";
        return new StageTableRowData(stageData, (Option<StageData>)new Some((Object)stageData), stageData.stageId(), stageData.attemptId(), stageData.schedulingPool(), stageData.description(), (Date)stageData.submissionTime().getOrElse((Function0 & Serializable & scala.Serializable)() -> new Date(0L)), formattedSubmissionTime, BoxesRunTime.unboxToLong((Object)duration.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)), formattedDuration, inputRead, inputReadWithUnit, outputWrite, outputWriteWithUnit, shuffleRead, shuffleReadWithUnit, shuffleWrite, shuffleWriteWithUnit);
    }

    private Ordering<StageTableRowData> ordering(String sortColumn, boolean desc) {
        Ordering ordering;
        String string = sortColumn;
        if ("Stage Id".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.stageId()), (Ordering)Ordering.Int$.MODULE$);
        } else if ("Pool Name".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$12 -> x$12.schedulingPool(), (Ordering)Ordering.String$.MODULE$);
        } else if ("Description".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x.descriptionOption(), (Object)x.stage().name()), Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.Option((Ordering)Ordering.String$.MODULE$), (Ordering)Ordering.String$.MODULE$));
        } else if ("Submitted".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$13 -> x$13.submissionTime(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        } else if ("Duration".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.duration()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Input".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.inputRead()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Output".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.outputWrite()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Shuffle Read".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.shuffleRead()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Shuffle Write".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)x$18.shuffleWrite()), (Ordering)Ordering.Long$.MODULE$);
        } else {
            if ("Tasks: Succeeded/Total".equals(string)) {
                throw new IllegalArgumentException(new StringBuilder(19).append("Unsortable column: ").append(sortColumn).toString());
            }
            throw new IllegalArgumentException(new StringBuilder(16).append("Unknown column: ").append(string).toString());
        }
        Ordering ordering2 = ordering;
        return desc ? ordering2.reverse() : ordering2;
    }

    public static final /* synthetic */ long $anonfun$stageRow$4(StageDataSource $this, long finishTime$1, Date date) {
        long time = date.getTime();
        return finishTime$1 > time ? finishTime$1 - time : $this.currentTime - time;
    }

    public StageDataSource(AppStatusStore store, Seq<StageData> stages, long currentTime, int pageSize, String sortColumn, boolean desc) {
        this.currentTime = currentTime;
        super(pageSize);
        this.data = (Seq)((SeqLike)stages.map((Function1 & Serializable & scala.Serializable)stageData -> this.stageRow((StageData)stageData), Seq$.MODULE$.canBuildFrom())).sorted(this.ordering(sortColumn, desc));
    }
}

