/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.scheduler.SchedulingMode$;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.AppSummary;
import org.apache.spark.status.api.v1.ApplicationAttemptInfo;
import org.apache.spark.status.api.v1.ApplicationInfo;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.ui.ToolTips$;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.ui.jobs.ApiHelper$;
import org.apache.spark.ui.jobs.JobPagedTable;
import org.apache.spark.ui.jobs.JobsTab;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;
import scala.xml.Utility$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!B\u0001\u0003\u0001\u0011a!aC!mY*{'m\u001d)bO\u0016T!a\u0001\u0003\u0002\t)|'m\u001d\u0006\u0003\u000b\u0019\t!!^5\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\"\u0001A\u0007\u0011\u00059yQ\"\u0001\u0003\n\u0005A!!!C,fEVK\u0005+Y4f\u0011!\u0011\u0002A!A!\u0002\u0013!\u0012A\u00029be\u0016tGo\u0001\u0001\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!a\u0002&pEN$\u0016M\u0019\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005)1\u000f^8sKB\u00111DH\u0007\u00029)\u0011QDB\u0001\u0007gR\fG/^:\n\u0005}a\"AD!qaN#\u0018\r^;t'R|'/\u001a\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r\"S\u0005\u0005\u0002\u0016\u0001!)!\u0003\ta\u0001)!)\u0011\u0004\ta\u00015!9q\u0005\u0001b\u0001\n\u0013A\u0013a\u0003&P\u0005N{F*R$F\u001d\u0012+\u0012!\u000b\t\u0003UMr!aK\u0019\u0011\u00051zS\"A\u0017\u000b\u00059\u001a\u0012A\u0002\u001fs_>$hHC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011t&\u0001\u0004Qe\u0016$WMZ\u0005\u0003iU\u0012aa\u0015;sS:<'B\u0001\u001a0\u0011\u00199\u0004\u0001)A\u0005S\u0005a!j\u0014\"T?2+u)\u0012(EA!9\u0011\b\u0001b\u0001\n\u0013A\u0013\u0001E#Y\u000b\u000e+Fk\u0014*T?2+u)\u0012(E\u0011\u0019Y\u0004\u0001)A\u0005S\u0005\tR\tW#D+R{%kU0M\u000b\u001e+e\n\u0012\u0011\t\u000bu\u0002A\u0011\u0002 \u0002\u00195\f7.\u001a&pE\u00163XM\u001c;\u0015\u0005}B\u0005c\u0001!FS9\u0011\u0011i\u0011\b\u0003Y\tK\u0011\u0001M\u0005\u0003\t>\nq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\n\u00191+Z9\u000b\u0005\u0011{\u0003\"B\u0002=\u0001\u0004I\u0005c\u0001!F\u0015B\u00111\nU\u0007\u0002\u0019*\u0011QJT\u0001\u0003mFR!a\u0014\u000f\u0002\u0007\u0005\u0004\u0018.\u0003\u0002R\u0019\n9!j\u001c2ECR\f\u0007\"B*\u0001\t\u0013!\u0016!E7bW\u0016,\u00050Z2vi>\u0014XI^3oiR\u0011q(\u0016\u0005\u0006-J\u0003\raV\u0001\nKb,7-\u001e;peN\u00042\u0001Q#Y!\tY\u0015,\u0003\u0002[\u0019\nyQ\t_3dkR|'oU;n[\u0006\u0014\u0018\u0010C\u0003]\u0001\u0011%Q,\u0001\u0007nC.,G+[7fY&tW\r\u0006\u0003_K\u001a<\u0007c\u0001!F?B\u0011\u0001mY\u0007\u0002C*\u0011!mL\u0001\u0004q6d\u0017B\u00013b\u0005\u0011qu\u000eZ3\t\u000b\rY\u0006\u0019A%\t\u000bY[\u0006\u0019A,\t\u000b!\\\u0006\u0019A5\u0002\u0013M$\u0018M\u001d;US6,\u0007C\u00016l\u001b\u0005y\u0013B\u000170\u0005\u0011auN\\4\t\u000b9\u0004A\u0011B8\u0002\u0013)|'m\u001d+bE2,G\u0003\u00030qyz\f\t!a\u0001\t\u000bEl\u0007\u0019\u0001:\u0002\u000fI,\u0017/^3tiB\u00111O_\u0007\u0002i*\u0011QO^\u0001\u0005QR$\bO\u0003\u0002xq\u000691/\u001a:wY\u0016$(\"A=\u0002\u000b)\fg/\u0019=\n\u0005m$(A\u0005%uiB\u001cVM\u001d<mKR\u0014V-];fgRDQ!`7A\u0002%\nQ\u0002^1cY\u0016DU-\u00193fe&#\u0007\"B@n\u0001\u0004I\u0013A\u00026pER\u000bw\rC\u0003\u0004[\u0002\u0007\u0011\nC\u0004\u0002\u00065\u0004\r!a\u0002\u0002\u0017-LG\u000e\\#oC\ndW\r\u001a\t\u0004U\u0006%\u0011bAA\u0006_\t9!i\\8mK\u0006t\u0007bBA\b\u0001\u0011\u0005\u0011\u0011C\u0001\u0007e\u0016tG-\u001a:\u0015\u0007y\u000b\u0019\u0002\u0003\u0004r\u0003\u001b\u0001\rA\u001d")
public class AllJobsPage
extends WebUIPage {
    private final JobsTab parent;
    private final AppStatusStore store;
    private final String JOBS_LEGEND;
    private final String EXECUTORS_LEGEND;

    private String JOBS_LEGEND() {
        return this.JOBS_LEGEND;
    }

    private String EXECUTORS_LEGEND() {
        return this.EXECUTORS_LEGEND;
    }

    private Seq<String> makeJobEvent(Seq<JobData> jobs) {
        return (Seq)((TraversableLike)jobs.filter((Function1 & Serializable & scala.Serializable)job -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$makeJobEvent$1(job)))).map((Function1 & Serializable & scala.Serializable)job -> {
            String string;
            String lastStageDescription;
            int jobId = job.jobId();
            JobExecutionStatus status = job.status();
            Tuple2<String, String> tuple2 = ApiHelper$.MODULE$.lastStageNameAndDescription($this.store, (JobData)job);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String string2 = lastStageDescription = (String)tuple2._2();
            String lastStageDescription2 = string2;
            String jobDescription = UIUtils$.MODULE$.makeDescription(lastStageDescription2, "", true).text();
            long submissionTime = ((Date)job.submissionTime().get()).getTime();
            long completionTime = BoxesRunTime.unboxToLong((Object)job.completionTime().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.currentTimeMillis()));
            JobExecutionStatus jobExecutionStatus = status;
            if (((Object)((Object)JobExecutionStatus.SUCCEEDED)).equals((Object)jobExecutionStatus)) {
                string = "succeeded";
            } else if (((Object)((Object)JobExecutionStatus.FAILED)).equals((Object)jobExecutionStatus)) {
                string = "failed";
            } else if (((Object)((Object)JobExecutionStatus.RUNNING)).equals((Object)jobExecutionStatus)) {
                string = "running";
            } else if (((Object)((Object)JobExecutionStatus.UNKNOWN)).equals((Object)jobExecutionStatus)) {
                string = "unknown";
            } else {
                throw new MatchError((Object)jobExecutionStatus);
            }
            String classNameByStatus = string;
            String escapedDesc = Utility$.MODULE$.escape(jobDescription);
            String jsEscapedDesc = StringEscapeUtils.escapeEcmaScript((String)escapedDesc);
            JobExecutionStatus jobExecutionStatus2 = status;
            JobExecutionStatus jobExecutionStatus3 = JobExecutionStatus.RUNNING;
            String jobEventJsonAsStr = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(520).append("\n           |{\n           |  'className': 'job application-timeline-object ").append(classNameByStatus).append("',\n           |  'group': 'jobs',\n           |  'start': new Date(").append(submissionTime).append("),\n           |  'end': new Date(").append(completionTime).append("),\n           |  'content': '<div class=\"application-timeline-content\"' +\n           |     'data-html=\"true\" data-placement=\"top\" data-toggle=\"tooltip\"' +\n           |     'data-title=\"").append(jsEscapedDesc).append(" (Job ").append(jobId).append(")<br>' +\n           |     'Status: ").append((Object)status).append("<br>' +\n           |     'Submitted: ").append(UIUtils$.MODULE$.formatDate(new Date(submissionTime))).append("' +\n           |     '").append((Object)((jobExecutionStatus2 == null ? jobExecutionStatus3 != null : !((Object)((Object)jobExecutionStatus2)).equals((Object)jobExecutionStatus3)) ? new StringBuilder(15).append("<br>Completed: ").append(UIUtils$.MODULE$.formatDate(new Date(completionTime))).toString() : "")).append("\">' +\n           |    '").append(jsEscapedDesc).append(" (Job ").append(jobId).append(")</div>'\n           |}\n         ").toString())).stripMargin();
            return jobEventJsonAsStr;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<String> makeExecutorEvent(Seq<ExecutorSummary> executors) {
        ListBuffer events = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        executors.foreach((Function1 & Serializable & scala.Serializable)e -> {
            AllJobsPage.$anonfun$makeExecutorEvent$1(events, e);
            return BoxedUnit.UNIT;
        });
        return events.toSeq();
    }

    private Seq<Node> makeTimeline(Seq<JobData> jobs, Seq<ExecutorSummary> executors, long startTime) {
        Seq<String> jobEventJsonAsStrSeq = this.makeJobEvent(jobs);
        Seq<String> executorEventJsonAsStrSeq = this.makeExecutorEvent(executors);
        String groupJsonArrayAsStr = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(254).append("\n          |[\n          |  {\n          |    'id': 'executors',\n          |    'content': '<div>Executors</div>").append(this.EXECUTORS_LEGEND()).append("',\n          |  },\n          |  {\n          |    'id': 'jobs',\n          |    'content': '<div>Jobs</div>").append(this.JOBS_LEGEND()).append("',\n          |  }\n          |]\n        ").toString())).stripMargin();
        String eventArrayAsStr = ((TraversableOnce)jobEventJsonAsStrSeq.$plus$plus(executorEventJsonAsStrSeq, Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-application-timeline"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("expand-application-timeline-arrow arrow-closed"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("data-placement", (Seq)new Text("right"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("title", ToolTips$.MODULE$.JOB_TIMELINE(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md3);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        Event Timeline\n      "));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("collapsed"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("id", (Seq)new Text("application-timeline"), (MetaData)$md4);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("control-panel"), (MetaData)$md5);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("id", (Seq)new Text("application-timeline-zoom-lock"), (MetaData)$md6);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md7);
        $buf5.$amp$plus((Object)new Elem(null, "input", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Enable zooming"));
        $buf5.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n    "));
        TraversableLike traversableLike = (TraversableLike)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3), NodeSeq$.MODULE$.canBuildFrom());
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md8);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n      "));
        $buf7.$amp$plus((Object)Unparsed$.MODULE$.apply(new StringBuilder(25).append("drawApplicationTimeline(").append(groupJsonArrayAsStr).append(",").append(new StringBuilder(6).append(eventArrayAsStr).append(", ").append(startTime).append(", ").append(UIUtils$.MODULE$.getTimeZoneOffset()).append(");").toString()).toString()));
        $buf7.$amp$plus((Object)new Text("\n    "));
        return (Seq)traversableLike.$plus$plus((GenTraversableOnce)new Elem(null, "script", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7), NodeSeq$.MODULE$.canBuildFrom());
    }

    private Seq<Node> jobsTable(HttpServletRequest request, String tableHeaderId, String jobTag, Seq<JobData> jobs, boolean killEnabled) {
        Elem elem;
        Map allParameters = (Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getParameterMap()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String[] v = (String[])tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UIUtils$.MODULE$.stripXSS(k)), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])v)).map((Function1 & Serializable & scala.Serializable)requestParameter -> UIUtils$.MODULE$.stripXSS((String)requestParameter), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq());
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable parameterOtherTable = (scala.collection.immutable.Iterable)allParameters.filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$jobsTable$3(jobTag, x$4))).map((Function1 & Serializable & scala.Serializable)para -> new StringBuilder(1).append((String)para._1()).append("=").append(((SeqLike)para._2()).apply(0)).toString(), Iterable$.MODULE$.canBuildFrom());
        boolean someJobHasJobGroup = jobs.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$jobsTable$5(x$5)));
        String jobIdTitle = someJobHasJobGroup ? "Job Id (Job Group)" : "Job Id";
        String parameterJobPage = UIUtils$.MODULE$.stripXSS(request.getParameter(new StringBuilder(5).append(jobTag).append(".page").toString()));
        String parameterJobSortColumn = UIUtils$.MODULE$.stripXSS(request.getParameter(new StringBuilder(5).append(jobTag).append(".sort").toString()));
        String parameterJobSortDesc = UIUtils$.MODULE$.stripXSS(request.getParameter(new StringBuilder(5).append(jobTag).append(".desc").toString()));
        String parameterJobPageSize = UIUtils$.MODULE$.stripXSS(request.getParameter(new StringBuilder(9).append(jobTag).append(".pageSize").toString()));
        String parameterJobPrevPageSize = UIUtils$.MODULE$.stripXSS(request.getParameter(new StringBuilder(13).append(jobTag).append(".prevPageSize").toString()));
        int jobPage = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)parameterJobPage).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)AllJobsPage.$anonfun$jobsTable$6(x$6))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
        String jobSortColumn = (String)Option$.MODULE$.apply((Object)parameterJobSortColumn).map((Function1 & Serializable & scala.Serializable)sortColumn -> UIUtils$.MODULE$.decodeURLParameter((String)sortColumn)).getOrElse((Function0 & Serializable & scala.Serializable)() -> jobIdTitle);
        boolean jobSortDesc = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)parameterJobSortDesc).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$jobsTable$10(x$7))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = jobSortColumn;
            String string2 = jobIdTitle;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
        int jobPageSize = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)parameterJobPageSize).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)AllJobsPage.$anonfun$jobsTable$12(x$8))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 100));
        int jobPrevPageSize = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)parameterJobPrevPageSize).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)AllJobsPage.$anonfun$jobsTable$14(x$9))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> jobPageSize));
        int page = jobPageSize <= jobPrevPageSize ? jobPage : 1;
        long currentTime = System.currentTimeMillis();
        try {
            elem = new JobPagedTable(this.store, jobs, tableHeaderId, jobTag, UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), "jobs", (Iterable<String>)parameterOtherTable, killEnabled, currentTime, jobIdTitle, jobPageSize, jobSortColumn, jobSortDesc).table(page);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException;
            if (!bl) {
                throw throwable;
            }
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("alert alert-error"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("Error while rendering job table:"));
            $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)Utils$.MODULE$.exceptionString(throwable2));
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
            $buf.$amp$plus((Object)new Text("\n        "));
            Elem elem2 = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            elem = elem2;
        }
        return elem;
    }

    @Override
    public Seq<Node> render(HttpServletRequest request) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        ApplicationInfo appInfo = this.store.applicationInfo();
        long startTime = ((ApplicationAttemptInfo)appInfo.attempts().head()).startTime().getTime();
        long endTime = ((ApplicationAttemptInfo)appInfo.attempts().head()).endTime().getTime();
        ListBuffer activeJobs = new ListBuffer();
        ListBuffer completedJobs = new ListBuffer();
        ListBuffer failedJobs = new ListBuffer();
        this.store.jobsList(null).foreach((Function1 & Serializable & scala.Serializable)job -> {
            JobExecutionStatus jobExecutionStatus = job.status();
            ListBuffer listBuffer = ((Object)((Object)JobExecutionStatus.SUCCEEDED)).equals((Object)jobExecutionStatus) ? completedJobs.$plus$eq(job) : (((Object)((Object)JobExecutionStatus.FAILED)).equals((Object)jobExecutionStatus) ? failedJobs.$plus$eq(job) : activeJobs.$plus$eq(job));
            return listBuffer;
        });
        Seq<Node> activeJobsTable = this.jobsTable(request, "active", "activeJob", (Seq<JobData>)activeJobs, this.parent.killEnabled());
        Seq<Node> completedJobsTable = this.jobsTable(request, "completed", "completedJob", (Seq<JobData>)completedJobs, false);
        Seq<Node> failedJobsTable = this.jobsTable(request, "failed", "failedJob", (Seq<JobData>)failedJobs, false);
        boolean shouldShowActiveJobs = activeJobs.nonEmpty();
        boolean shouldShowCompletedJobs = completedJobs.nonEmpty();
        boolean shouldShowFailedJobs = failedJobs.nonEmpty();
        AppSummary appSummary = this.store.appSummary();
        String completedJobNumStr = completedJobs.size() == appSummary.numCompletedJobs() ? String.valueOf(BoxesRunTime.boxToInteger((int)completedJobs.size())) : new StringBuilder(15).append(appSummary.numCompletedJobs()).append(", only showing ").append(completedJobs.size()).toString();
        String schedulingMode = (String)this.store.environmentInfo().sparkProperties().toMap(Predef$.MODULE$.$conforms()).get((Object)"spark.scheduler.mode").map((Function1 & Serializable & scala.Serializable)mode -> SchedulingMode$.MODULE$.withName((String)mode).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "Unknown");
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("unstyled"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("User:"));
        $buf3.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n            "));
        $buf3.$amp$plus((Object)this.parent.getSparkUser());
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Total Uptime:"));
        $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)(endTime < 0L && this.parent.sc().isDefined() ? UIUtils$.MODULE$.formatDuration(System.currentTimeMillis() - startTime) : (endTime > 0L ? UIUtils$.MODULE$.formatDuration(endTime - startTime) : BoxedUnit.UNIT)));
        $buf5.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Scheduling Mode: "));
        $buf7.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf7.$amp$plus((Object)schedulingMode);
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf2.$amp$plus((Object)new Text("\n          "));
        if (shouldShowActiveJobs) {
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new Text("\n                "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("href", (Seq)new Text("#active"), (MetaData)$md2);
            NodeBuffer $buf10 = new NodeBuffer();
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("Active Jobs:"));
            $buf10.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
            $buf9.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
            $buf9.$amp$plus((Object)new Text("\n                "));
            $buf9.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeJobs.size()));
            $buf9.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9);
            boxedUnit3 = elem;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        $buf2.$amp$plus((Object)boxedUnit3);
        $buf2.$amp$plus((Object)new Text("\n          "));
        if (shouldShowCompletedJobs) {
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("id", (Seq)new Text("completed-summary"), (MetaData)$md3);
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)new Text("\n                "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("href", (Seq)new Text("#completed"), (MetaData)$md4);
            NodeBuffer $buf13 = new NodeBuffer();
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)new Text("Completed Jobs:"));
            $buf13.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
            $buf12.$amp$plus((Object)new Elem(null, "a", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
            $buf12.$amp$plus((Object)new Text("\n                "));
            $buf12.$amp$plus((Object)completedJobNumStr);
            $buf12.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "li", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12);
            boxedUnit2 = elem;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        $buf2.$amp$plus((Object)boxedUnit2);
        $buf2.$amp$plus((Object)new Text("\n          "));
        if (shouldShowFailedJobs) {
            NodeBuffer $buf15 = new NodeBuffer();
            $buf15.$amp$plus((Object)new Text("\n                "));
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("href", (Seq)new Text("#failed"), (MetaData)$md5);
            NodeBuffer $buf16 = new NodeBuffer();
            NodeBuffer $buf17 = new NodeBuffer();
            $buf17.$amp$plus((Object)new Text("Failed Jobs:"));
            $buf16.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf17));
            $buf15.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16));
            $buf15.$amp$plus((Object)new Text("\n                "));
            $buf15.$amp$plus((Object)BoxesRunTime.boxToInteger((int)failedJobs.size()));
            $buf15.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15);
            boxedUnit = elem;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $buf2.$amp$plus((Object)boxedUnit);
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem summary = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        ObjectRef content = ObjectRef.create((Object)summary);
        content.elem = (NodeSeq)((NodeSeq)content.elem).$plus$plus(this.makeTimeline((Seq<JobData>)activeJobs.$plus$plus((GenTraversableOnce)completedJobs).$plus$plus((GenTraversableOnce)failedJobs), this.store.executorList(false), startTime), NodeSeq$.MODULE$.canBuildFrom());
        if (shouldShowActiveJobs) {
            NodeSeq nodeSeq = (NodeSeq)content.elem;
            Null$ $md6 = Null$.MODULE$;
            $md6 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-activeJobs','aggregated-activeJobs')"), (MetaData)$md6);
            $md6 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-activeJobs collapse-table"), (MetaData)$md6);
            $md6 = new UnprefixedAttribute("id", (Seq)new Text("active"), (MetaData)$md6);
            NodeBuffer $buf18 = new NodeBuffer();
            $buf18.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf19 = new NodeBuffer();
            $buf19.$amp$plus((Object)new Text("\n            "));
            Null$ $md7 = Null$.MODULE$;
            $md7 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md7);
            $buf19.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf19.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf20 = new NodeBuffer();
            $buf20.$amp$plus((Object)new Text("Active Jobs ("));
            $buf20.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeJobs.size()));
            $buf20.$amp$plus((Object)new Text(")"));
            $buf19.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf20));
            $buf19.$amp$plus((Object)new Text("\n          "));
            $buf18.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf19));
            $buf18.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "span", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf18);
            Null$ $md8 = Null$.MODULE$;
            $md8 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-activeJobs collapsible-table"), (MetaData)$md8);
            NodeBuffer $buf21 = new NodeBuffer();
            $buf21.$amp$plus((Object)new Text("\n          "));
            $buf21.$amp$plus(activeJobsTable);
            $buf21.$amp$plus((Object)new Text("\n        "));
            content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf21), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
        }
        if (shouldShowCompletedJobs) {
            NodeSeq nodeSeq = (NodeSeq)content.elem;
            Null$ $md9 = Null$.MODULE$;
            $md9 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-completedJobs','aggregated-completedJobs')"), (MetaData)$md9);
            $md9 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-completedJobs collapse-table"), (MetaData)$md9);
            $md9 = new UnprefixedAttribute("id", (Seq)new Text("completed"), (MetaData)$md9);
            NodeBuffer $buf22 = new NodeBuffer();
            $buf22.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf23 = new NodeBuffer();
            $buf23.$amp$plus((Object)new Text("\n            "));
            Null$ $md10 = Null$.MODULE$;
            $md10 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md10);
            $buf23.$amp$plus((Object)new Elem(null, "span", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf23.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf24 = new NodeBuffer();
            $buf24.$amp$plus((Object)new Text("Completed Jobs ("));
            $buf24.$amp$plus((Object)completedJobNumStr);
            $buf24.$amp$plus((Object)new Text(")"));
            $buf23.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf24));
            $buf23.$amp$plus((Object)new Text("\n          "));
            $buf22.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf23));
            $buf22.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "span", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf22);
            Null$ $md11 = Null$.MODULE$;
            $md11 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-completedJobs collapsible-table"), (MetaData)$md11);
            NodeBuffer $buf25 = new NodeBuffer();
            $buf25.$amp$plus((Object)new Text("\n          "));
            $buf25.$amp$plus(completedJobsTable);
            $buf25.$amp$plus((Object)new Text("\n        "));
            content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf25), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
        }
        if (shouldShowFailedJobs) {
            NodeSeq nodeSeq = (NodeSeq)content.elem;
            Null$ $md12 = Null$.MODULE$;
            $md12 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-failedJobs','aggregated-failedJobs')"), (MetaData)$md12);
            $md12 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-failedJobs collapse-table"), (MetaData)$md12);
            $md12 = new UnprefixedAttribute("id", (Seq)new Text("failed"), (MetaData)$md12);
            NodeBuffer $buf26 = new NodeBuffer();
            $buf26.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf27 = new NodeBuffer();
            $buf27.$amp$plus((Object)new Text("\n            "));
            Null$ $md13 = Null$.MODULE$;
            $md13 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md13);
            $buf27.$amp$plus((Object)new Elem(null, "span", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf27.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf28 = new NodeBuffer();
            $buf28.$amp$plus((Object)new Text("Failed Jobs ("));
            $buf28.$amp$plus((Object)BoxesRunTime.boxToInteger((int)failedJobs.size()));
            $buf28.$amp$plus((Object)new Text(")"));
            $buf27.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf28));
            $buf27.$amp$plus((Object)new Text("\n          "));
            $buf26.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf27));
            $buf26.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "span", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf26);
            Null$ $md14 = Null$.MODULE$;
            $md14 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-failedJobs collapsible-table"), (MetaData)$md14);
            NodeBuffer $buf29 = new NodeBuffer();
            $buf29.$amp$plus((Object)new Text("\n        "));
            $buf29.$amp$plus(failedJobsTable);
            $buf29.$amp$plus((Object)new Text("\n      "));
            content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf29), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
        }
        String helpText = "A job is triggered by an action, like count() or saveAsTextFile(). Click on a job to see information about the stages of tasks inside it.";
        HttpServletRequest x$19 = request;
        String x$20 = "Spark Jobs";
        Function0 & Serializable & scala.Serializable x$21 = (Function0 & Serializable & scala.Serializable)() -> (NodeSeq)content$1.elem;
        JobsTab x$22 = this.parent;
        Some x$23 = new Some((Object)helpText);
        Option<Object> x$24 = UIUtils$.MODULE$.headerSparkPage$default$5();
        boolean x$25 = UIUtils$.MODULE$.headerSparkPage$default$7();
        boolean x$26 = UIUtils$.MODULE$.headerSparkPage$default$8();
        return UIUtils$.MODULE$.headerSparkPage(x$19, x$20, (Function0<Seq<Node>>)x$21, x$22, x$24, (Option<String>)x$23, x$25, x$26);
    }

    public static final /* synthetic */ boolean $anonfun$JOBS_LEGEND$1(char x$1) {
        return x$1 != '\n';
    }

    public static final /* synthetic */ boolean $anonfun$EXECUTORS_LEGEND$1(char x$2) {
        return x$2 != '\n';
    }

    public static final /* synthetic */ boolean $anonfun$makeJobEvent$1(JobData job) {
        JobExecutionStatus jobExecutionStatus = job.status();
        JobExecutionStatus jobExecutionStatus2 = JobExecutionStatus.UNKNOWN;
        return (jobExecutionStatus == null ? jobExecutionStatus2 != null : !((Object)((Object)jobExecutionStatus)).equals((Object)jobExecutionStatus2)) && job.submissionTime().isDefined();
    }

    public static final /* synthetic */ void $anonfun$makeExecutorEvent$1(ListBuffer events$1, ExecutorSummary e) {
        String addedEvent = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(419).append("\n           |{\n           |  'className': 'executor added',\n           |  'group': 'executors',\n           |  'start': new Date(").append(e.addTime().getTime()).append("),\n           |  'content': '<div class=\"executor-event-content\"' +\n           |    'data-toggle=\"tooltip\" data-placement=\"bottom\"' +\n           |    'data-title=\"Executor ").append(e.id()).append("<br>' +\n           |    'Added at ").append(UIUtils$.MODULE$.formatDate(e.addTime())).append("\"' +\n           |    'data-html=\"true\">Executor ").append(e.id()).append(" added</div>'\n           |}\n         ").toString())).stripMargin();
        events$1.$plus$eq((Object)addedEvent);
        e.removeTime().foreach((Function1 & Serializable & scala.Serializable)removeTime -> {
            String removedEvent = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(470).append("\n             |{\n             |  'className': 'executor removed',\n             |  'group': 'executors',\n             |  'start': new Date(").append(removeTime.getTime()).append("),\n             |  'content': '<div class=\"executor-event-content\"' +\n             |    'data-toggle=\"tooltip\" data-placement=\"bottom\"' +\n             |    'data-title=\"Executor ").append(e.id()).append("<br>' +\n             |    'Removed at ").append(UIUtils$.MODULE$.formatDate((Date)removeTime)).append("' +\n             |    '").append(e.removeReason().map((Function1 & Serializable & scala.Serializable)reason -> new StringBuilder(12).append("<br>Reason: ").append(reason.replace("\n", " ")).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\"' +\n             |    'data-html=\"true\">Executor ").append(e.id()).append(" removed</div>'\n             |}\n           ").toString())).stripMargin();
            return events$1.$plus$eq((Object)removedEvent);
        });
    }

    public static final /* synthetic */ boolean $anonfun$jobsTable$3(String jobTag$1, Tuple2 x$4) {
        return ((String)x$4._1()).startsWith(jobTag$1);
    }

    public static final /* synthetic */ boolean $anonfun$jobsTable$5(JobData x$5) {
        return x$5.jobGroup().isDefined();
    }

    public static final /* synthetic */ int $anonfun$jobsTable$6(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$jobsTable$10(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toBoolean();
    }

    public static final /* synthetic */ int $anonfun$jobsTable$12(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toInt();
    }

    public static final /* synthetic */ int $anonfun$jobsTable$14(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public AllJobsPage(JobsTab parent, AppStatusStore store) {
        this.parent = parent;
        this.store = store;
        super("");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("height", (Seq)new Text("85px"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("width", (Seq)new Text("150px"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("y", (Seq)new Text("5px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("succeeded-job-legend"), (MetaData)$md3);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("y", (Seq)new Text("17px"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md4);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Succeeded"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("y", (Seq)new Text("30px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("failed-job-legend"), (MetaData)$md5);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("y", (Seq)new Text("42px"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md6);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Failed"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("y", (Seq)new Text("55px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("running-job-legend"), (MetaData)$md7);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("y", (Seq)new Text("67px"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md8);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Running"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "svg", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        this.JOBS_LEGEND = (String)new StringOps(Predef$.MODULE$.augmentString(new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf).toString())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$JOBS_LEGEND$1(BoxesRunTime.unboxToChar((Object)x$1))));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md9);
        NodeBuffer $buf6 = new NodeBuffer();
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("height", (Seq)new Text("55px"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("width", (Seq)new Text("150px"), (MetaData)$md10);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("y", (Seq)new Text("5px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("executor-added-legend"), (MetaData)$md11);
        $buf7.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("y", (Seq)new Text("17px"), (MetaData)$md12);
        $md12 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md12);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Added"));
        $buf7.$amp$plus((Object)new Elem(null, "text", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("y", (Seq)new Text("30px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("class", (Seq)new Text("executor-removed-legend"), (MetaData)$md13);
        $buf7.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("y", (Seq)new Text("42px"), (MetaData)$md14);
        $md14 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md14);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Removed"));
        $buf7.$amp$plus((Object)new Elem(null, "text", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf7.$amp$plus((Object)new Text("\n    "));
        $buf6.$amp$plus((Object)new Elem(null, "svg", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        this.EXECUTORS_LEGEND = (String)new StringOps(Predef$.MODULE$.augmentString(new Elem(null, "div", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6).toString())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$EXECUTORS_LEGEND$1(BoxesRunTime.unboxToChar((Object)x$2))));
    }
}

