/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.NioBufferedFileInputStream;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc!B\u0001\u0003\u0001\u0011Q!!G%oI\u0016D8\u000b[;gM2,'\t\\8dWJ+7o\u001c7wKJT!a\u0001\u0003\u0002\u000fMDWO\u001a4mK*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0005\u0003\u0001\u0017E)\u0002C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\r\u0005\u0002\u0013'5\t!!\u0003\u0002\u0015\u0005\t!2\u000b[;gM2,'\t\\8dWJ+7o\u001c7wKJ\u0004\"AF\r\u000e\u0003]Q!\u0001\u0007\u0003\u0002\u0011%tG/\u001a:oC2L!AG\f\u0003\u000f1{wmZ5oO\"AA\u0004\u0001B\u0001B\u0003%a$\u0001\u0003d_:47\u0001\u0001\t\u0003?\u0001j\u0011\u0001B\u0005\u0003C\u0011\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\nQb\u00182m_\u000e\\W*\u00198bO\u0016\u0014\bCA\u0013)\u001b\u00051#BA\u0014\u0005\u0003\u001d\u0019Ho\u001c:bO\u0016L!!\u000b\u0014\u0003\u0019\tcwnY6NC:\fw-\u001a:\t\u000b-\u0002A\u0011\u0001\u0017\u0002\rqJg.\u001b;?)\ricf\f\t\u0003%\u0001AQ\u0001\b\u0016A\u0002yAqa\t\u0016\u0011\u0002\u0003\u0007A\u0005\u0003\u00052\u0001!\u0015\r\u0011\"\u00033\u00031\u0011Gn\\2l\u001b\u0006t\u0017mZ3s+\u0005!\u0003b\u0002\u001b\u0001\u0005\u0004%I!N\u0001\u000eiJ\fgn\u001d9peR\u001cuN\u001c4\u0016\u0003Y\u0002\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0003w\u0011\tqA\\3uo>\u00148.\u0003\u0002>q\tiAK]1ogB|'\u000f^\"p]\u001aDaa\u0010\u0001!\u0002\u00131\u0014A\u0004;sC:\u001c\bo\u001c:u\u0007>tg\r\t\u0005\u0006\u0003\u0002!\tAQ\u0001\fO\u0016$H)\u0019;b\r&dW\rF\u0002D\u0017B\u0003\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\u0005%|'\"\u0001%\u0002\t)\fg/Y\u0005\u0003\u0015\u0016\u0013AAR5mK\")A\n\u0011a\u0001\u001b\u0006I1\u000f[;gM2,\u0017\n\u001a\t\u0003\u00199K!aT\u0007\u0003\u0007%sG\u000fC\u0003R\u0001\u0002\u0007Q*A\u0003nCBLE\rC\u0003T\u0001\u0011%A+\u0001\u0007hKRLe\u000eZ3y\r&dW\rF\u0002D+ZCQ\u0001\u0014*A\u00025CQ!\u0015*A\u00025CQ\u0001\u0017\u0001\u0005\u0002e\u000bqB]3n_Z,G)\u0019;b\u0005fl\u0015\r\u001d\u000b\u00045vs\u0006C\u0001\u0007\\\u0013\taVB\u0001\u0003V]&$\b\"\u0002'X\u0001\u0004i\u0005\"B)X\u0001\u0004i\u0005\"\u00021\u0001\t\u0013\t\u0017!F2iK\u000e\\\u0017J\u001c3fq\u0006sG\rR1uC\u001aKG.\u001a\u000b\u0005E\"TG\u000eE\u0002\rG\u0016L!\u0001Z\u0007\u0003\u000b\u0005\u0013(/Y=\u0011\u000511\u0017BA4\u000e\u0005\u0011auN\\4\t\u000b%|\u0006\u0019A\"\u0002\u000b%tG-\u001a=\t\u000b-|\u0006\u0019A\"\u0002\t\u0011\fG/\u0019\u0005\u0006[~\u0003\r!T\u0001\u0007E2|7m[:\t\u000b=\u0004A\u0011\u00019\u0002/]\u0014\u0018\u000e^3J]\u0012,\u0007PR5mK\u0006sGmQ8n[&$H#\u0002.reN,\b\"\u0002'o\u0001\u0004i\u0005\"B)o\u0001\u0004i\u0005\"\u0002;o\u0001\u0004\u0011\u0017a\u00027f]\u001e$\bn\u001d\u0005\u0006m:\u0004\raQ\u0001\bI\u0006$\u0018\rV7q\u0011\u0015A\b\u0001\"\u0011z\u000319W\r\u001e\"m_\u000e\\G)\u0019;b)\rQ\u0018\u0011\u0001\t\u0003wzl\u0011\u0001 \u0006\u0003{j\naAY;gM\u0016\u0014\u0018BA@}\u00055i\u0015M\\1hK\u0012\u0014UO\u001a4fe\"9\u00111A<A\u0002\u0005\u0015\u0011a\u00022m_\u000e\\\u0017\n\u001a\t\u0004K\u0005\u001d\u0011bAA\u0005M\tq1\u000b[;gM2,'\t\\8dW&#\u0007bBA\u0007\u0001\u0011\u0005\u0013qB\u0001\u0005gR|\u0007\u000fF\u0001[\u000f!\t\u0019B\u0001E\u0001\t\u0005U\u0011!G%oI\u0016D8\u000b[;gM2,'\t\\8dWJ+7o\u001c7wKJ\u00042AEA\f\r\u001d\t!\u0001#\u0001\u0005\u00033\u00192!a\u0006\f\u0011\u001dY\u0013q\u0003C\u0001\u0003;!\"!!\u0006\t\u0015\u0005\u0005\u0012q\u0003b\u0001\n\u0003\t\u0019#\u0001\bO\u001f>\u0003vLU#E+\u000e+u,\u0013#\u0016\u00035C\u0001\"a\n\u0002\u0018\u0001\u0006I!T\u0001\u0010\u001d>{\u0005k\u0018*F\tV\u001bUiX%EA!Q\u00111FA\f#\u0003%\t!!\f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tyCK\u0002%\u0003cY#!a\r\u0011\t\u0005U\u0012qH\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003{i\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011IA\u001c\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class IndexShuffleBlockResolver
implements ShuffleBlockResolver,
Logging {
    private BlockManager blockManager;
    private final BlockManager _blockManager;
    private final TransportConf transportConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static BlockManager $lessinit$greater$default$2() {
        return IndexShuffleBlockResolver$.MODULE$.$lessinit$greater$default$2();
    }

    public static int NOOP_REDUCE_ID() {
        return IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private BlockManager blockManager$lzycompute() {
        IndexShuffleBlockResolver indexShuffleBlockResolver = this;
        synchronized (indexShuffleBlockResolver) {
            if (!this.bitmap$0) {
                this.blockManager = (BlockManager)Option$.MODULE$.apply((Object)this._blockManager).getOrElse((Function0 & Serializable & scala.Serializable)() -> SparkEnv$.MODULE$.get().blockManager());
                this.bitmap$0 = true;
            }
        }
        this._blockManager = null;
        return this.blockManager;
    }

    private BlockManager blockManager() {
        return !this.bitmap$0 ? this.blockManager$lzycompute() : this.blockManager;
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    public File getDataFile(int shuffleId, int mapId) {
        return this.blockManager().diskBlockManager().getFile(new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()));
    }

    private File getIndexFile(int shuffleId, int mapId) {
        return this.blockManager().diskBlockManager().getFile(new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()));
    }

    public void removeDataByMap(int shuffleId, int mapId) {
        block1: {
            ObjectRef file = ObjectRef.create((Object)this.getDataFile(shuffleId, mapId));
            if (((File)file.elem).exists() && !((File)file.elem).delete()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Error deleting data ").append(((File)file$1.elem).getPath()).toString());
            }
            file.elem = this.getIndexFile(shuffleId, mapId);
            if (!((File)file.elem).exists() || ((File)file.elem).delete()) break block1;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Error deleting index ").append(((File)file$1.elem).getPath()).toString());
        }
    }

    private long[] checkIndexAndDataFile(File index, File data, int blocks) {
        long[] lengths;
        block11: {
            long[] lArray;
            block10: {
                DataInputStream dataInputStream;
                if (index.length() != (long)(blocks + 1) * 8L) {
                    return null;
                }
                lengths = new long[blocks];
                try {
                    dataInputStream = new DataInputStream(new NioBufferedFileInputStream(index));
                }
                catch (IOException e) {
                    return null;
                }
                try (DataInputStream in = dataInputStream;){
                    try {
                        long offset = in.readLong();
                        if (offset != 0L) {
                            lArray = null;
                            break block10;
                        }
                        for (int i = 0; i < blocks; ++i) {
                            long off = in.readLong();
                            lengths[i] = off - offset;
                            offset = off;
                        }
                        break block11;
                    }
                    catch (IOException e) {
                        lArray = null;
                    }
                }
            }
            return lArray;
        }
        return (long[])(data.length() == BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) ? lengths : null);
    }

    public void writeIndexFileAndCommit(int shuffleId, int mapId, long[] lengths, File dataTmp) {
        File indexFile = this.getIndexFile(shuffleId, mapId);
        File indexTmp = Utils$.MODULE$.tempFileWith(indexFile);
        try {
            File dataFile = this.getDataFile(shuffleId, mapId);
            IndexShuffleBlockResolver indexShuffleBlockResolver = this;
            synchronized (indexShuffleBlockResolver) {
                Object object;
                long[] existingLengths = this.checkIndexAndDataFile(indexFile, dataFile, lengths.length);
                if (existingLengths != null) {
                    System.arraycopy(existingLengths, 0, lengths, 0, lengths.length);
                    object = dataTmp != null && dataTmp.exists() ? BoxesRunTime.boxToBoolean((boolean)dataTmp.delete()) : BoxedUnit.UNIT;
                } else {
                    DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexTmp)));
                    Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        LongRef offset = LongRef.create((long)0L);
                        out.writeLong(offset.elem);
                        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)length -> {
                            offset$1.elem += length;
                            out.writeLong(offset$1.elem);
                        });
                    }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.close());
                    Object object2 = indexFile.exists() ? BoxesRunTime.boxToBoolean((boolean)indexFile.delete()) : BoxedUnit.UNIT;
                    Object object3 = dataFile.exists() ? BoxesRunTime.boxToBoolean((boolean)dataFile.delete()) : BoxedUnit.UNIT;
                    if (!indexTmp.renameTo(indexFile)) {
                        throw new IOException(new StringBuilder(24).append("fail to rename file ").append(indexTmp).append(" to ").append(indexFile).toString());
                    }
                    if (dataTmp != null && dataTmp.exists() && !dataTmp.renameTo(dataFile)) {
                        throw new IOException(new StringBuilder(24).append("fail to rename file ").append(dataTmp).append(" to ").append(dataFile).toString());
                    }
                    object = BoxedUnit.UNIT;
                }
            }
        }
        finally {
            if (indexTmp.exists() && !indexTmp.delete()) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to delete temporary index file at ").append(indexTmp.getAbsolutePath()).toString());
            }
        }
    }

    @Override
    public ManagedBuffer getBlockData(ShuffleBlockId blockId) {
        FileSegmentManagedBuffer fileSegmentManagedBuffer;
        File indexFile = this.getIndexFile(blockId.shuffleId(), blockId.mapId());
        SeekableByteChannel channel = Files.newByteChannel(indexFile.toPath(), new OpenOption[0]);
        channel.position((long)blockId.reduceId() * 8L);
        try (DataInputStream in = new DataInputStream(Channels.newInputStream(channel));){
            long offset = in.readLong();
            long nextOffset = in.readLong();
            long actualPosition = channel.position();
            long expectedPosition = (long)blockId.reduceId() * 8L + 16L;
            if (actualPosition != expectedPosition) {
                throw new Exception(new StringBuilder(64).append("SPARK-22982: Incorrect channel position after index file reads: ").append(new StringBuilder(35).append("expected ").append(expectedPosition).append(" but actual position was ").append(actualPosition).append(".").toString()).toString());
            }
            fileSegmentManagedBuffer = new FileSegmentManagedBuffer(this.transportConf(), this.getDataFile(blockId.shuffleId(), blockId.mapId()), offset, nextOffset - offset);
        }
        return fileSegmentManagedBuffer;
    }

    @Override
    public void stop() {
    }

    public IndexShuffleBlockResolver(SparkConf conf, BlockManager _blockManager) {
        this._blockManager = _blockManager;
        Logging.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", SparkTransportConf$.MODULE$.fromSparkConf$default$3());
    }
}

