/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.ApplicationDescription;
import org.apache.spark.deploy.ApplicationDescription$;
import org.apache.spark.deploy.Command;
import org.apache.spark.deploy.client.StandaloneAppClient;
import org.apache.spark.deploy.client.StandaloneAppClientListener;
import org.apache.spark.launcher.LauncherBackend;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\t5a!B\u0001\u0003\u0001\u0019a!AG*uC:$\u0017\r\\8oKN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$'BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT!!\u0002\u0004\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\t\u0001i\u0011#\u0007\t\u0003\u001d=i\u0011AA\u0005\u0003!\t\u0011QdQ8beN,wI]1j]\u0016$7k\u00195fIVdWM\u001d\"bG.,g\u000e\u001a\t\u0003%]i\u0011a\u0005\u0006\u0003)U\taa\u00197jK:$(B\u0001\f\u0007\u0003\u0019!W\r\u001d7ps&\u0011\u0001d\u0005\u0002\u001c'R\fg\u000eZ1m_:,\u0017\t\u001d9DY&,g\u000e\u001e'jgR,g.\u001a:\u0011\u0005iiR\"A\u000e\u000b\u0005q1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005yY\"a\u0002'pO\u001eLgn\u001a\u0005\t\u000b\u0001\u0011\t\u0011)A\u0005C\r\u0001\u0001C\u0001\u0012$\u001b\u0005!\u0011B\u0001\u0013\u0005\u0005E!\u0016m]6TG\",G-\u001e7fe&k\u0007\u000f\u001c\u0005\tM\u0001\u0011\t\u0011)A\u0005O\u0005\u00111o\u0019\t\u0003Q%j\u0011AB\u0005\u0003U\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\b[\u0006\u001cH/\u001a:t!\rq\u0013gM\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t)\u0011I\u001d:bsB\u0011Ag\u000f\b\u0003ke\u0002\"AN\u0018\u000e\u0003]R!\u0001\u000f\u0011\u0002\rq\u0012xn\u001c;?\u0013\tQt&\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e0\u0011\u0015y\u0004\u0001\"\u0001A\u0003\u0019a\u0014N\\5u}Q!\u0011IQ\"E!\tq\u0001\u0001C\u0003\u0006}\u0001\u0007\u0011\u0005C\u0003'}\u0001\u0007q\u0005C\u0003-}\u0001\u0007Q\u0006C\u0004\u0015\u0001\u0001\u0007I\u0011\u0002$\u0016\u0003\u001d\u0003\"A\u0005%\n\u0005%\u001b\"aE*uC:$\u0017\r\\8oK\u0006\u0003\bo\u00117jK:$\bbB&\u0001\u0001\u0004%I\u0001T\u0001\u000bG2LWM\u001c;`I\u0015\fHCA'Q!\tqc*\u0003\u0002P_\t!QK\\5u\u0011\u001d\t&*!AA\u0002\u001d\u000b1\u0001\u001f\u00132\u0011\u0019\u0019\u0006\u0001)Q\u0005\u000f\u000691\r\\5f]R\u0004\u0003bB+\u0001\u0005\u0004%IAV\u0001\tgR|\u0007\u000f]5oOV\tq\u000b\u0005\u0002YC6\t\u0011L\u0003\u0002[7\u00061\u0011\r^8nS\u000eT!\u0001X/\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002_?\u0006!Q\u000f^5m\u0015\u0005\u0001\u0017\u0001\u00026bm\u0006L!AY-\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0011\u0019!\u0007\u0001)A\u0005/\u0006I1\u000f^8qa&tw\r\t\u0005\bM\u0002\u0011\r\u0011\"\u0003h\u0003=a\u0017-\u001e8dQ\u0016\u0014()Y2lK:$W#\u00015\u0011\u0005%dW\"\u00016\u000b\u0005-4\u0011\u0001\u00037bk:\u001c\u0007.\u001a:\n\u00055T'a\u0004'bk:\u001c\u0007.\u001a:CC\u000e\\WM\u001c3\t\r=\u0004\u0001\u0015!\u0003i\u0003Aa\u0017-\u001e8dQ\u0016\u0014()Y2lK:$\u0007\u0005C\u0005r\u0001\u0001\u0007\t\u0019!C\u0001e\u0006\u00012\u000f[;uI><hnQ1mY\n\f7m[\u000b\u0002gB!a\u0006^!N\u0013\t)xFA\u0005Gk:\u001cG/[8oc!Iq\u000f\u0001a\u0001\u0002\u0004%\t\u0001_\u0001\u0015g\",H\u000fZ8x]\u000e\u000bG\u000e\u001c2bG.|F%Z9\u0015\u00055K\bbB)w\u0003\u0003\u0005\ra\u001d\u0005\nw\u0002\u0001\r\u0011!Q!\nM\f\u0011c\u001d5vi\u0012|wO\\\"bY2\u0014\u0017mY6!Q\tQX\u0010\u0005\u0002/}&\u0011qp\f\u0002\tm>d\u0017\r^5mK\"Y\u00111\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0003\u0003\u0015\t\u0007\u000f]%e+\u0005\u0019\u0004bCA\u0005\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0017\t\u0011\"\u00199q\u0013\u0012|F%Z9\u0015\u00075\u000bi\u0001\u0003\u0005R\u0003\u000f\t\t\u00111\u00014\u0011)\t\t\u0002\u0001a\u0001\u0002\u0003\u0006KaM\u0001\u0007CB\u0004\u0018\n\u001a\u0011)\u0007\u0005=Q\u0010C\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0003\u0002\u001a\u0005\u0019\"/Z4jgR\u0014\u0018\r^5p]\n\u000b'O]5feV\u0011\u00111\u0004\t\u0005\u0003;\ty\"D\u0001\\\u0013\r\t\tc\u0017\u0002\n'\u0016l\u0017\r\u001d5pe\u0016D\u0001\"!\n\u0001A\u0003%\u00111D\u0001\u0015e\u0016<\u0017n\u001d;sCRLwN\u001c\"beJLWM\u001d\u0011\t\u0013\u0005%\u0002A1A\u0005\n\u0005-\u0012\u0001C7bq\u000e{'/Z:\u0016\u0005\u00055\u0002#\u0002\u0018\u00020\u0005M\u0012bAA\u0019_\t1q\n\u001d;j_:\u00042ALA\u001b\u0013\r\t9d\f\u0002\u0004\u0013:$\b\u0002CA\u001e\u0001\u0001\u0006I!!\f\u0002\u00135\f\u0007pQ8sKN\u0004\u0003\"CA \u0001\t\u0007I\u0011BA!\u0003I!x\u000e^1m\u000bb\u0004Xm\u0019;fI\u000e{'/Z:\u0016\u0005\u0005M\u0002\u0002CA#\u0001\u0001\u0006I!a\r\u0002'Q|G/\u00197FqB,7\r^3e\u0007>\u0014Xm\u001d\u0011\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L\u0005)1\u000f^1siR\tQ\nC\u0004\u0002P\u0001!\t%a\u0013\u0002\tM$x\u000e\u001d\u0005\b\u0003'\u0002A\u0011IA+\u0003%\u0019wN\u001c8fGR,G\rF\u0002N\u0003/Bq!a\u0001\u0002R\u0001\u00071\u0007C\u0004\u0002\\\u0001!\t%a\u0013\u0002\u0019\u0011L7oY8o]\u0016\u001cG/\u001a3\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b\u0005!A-Z1e)\ri\u00151\r\u0005\b\u0003K\ni\u00061\u00014\u0003\u0019\u0011X-Y:p]\"9\u0011\u0011\u000e\u0001\u0005B\u0005-\u0014!D3yK\u000e,Ho\u001c:BI\u0012,G\rF\u0006N\u0003[\n\t(!\u001e\u0002z\u0005u\u0004bBA8\u0003O\u0002\raM\u0001\u0007MVdG.\u00133\t\u000f\u0005M\u0014q\ra\u0001g\u0005Aqo\u001c:lKJLE\rC\u0004\u0002x\u0005\u001d\u0004\u0019A\u001a\u0002\u0011!|7\u000f\u001e)peRD\u0001\"a\u001f\u0002h\u0001\u0007\u00111G\u0001\u0006G>\u0014Xm\u001d\u0005\t\u0003\u007f\n9\u00071\u0001\u00024\u00051Q.Z7pefDq!a!\u0001\t\u0003\n))A\bfq\u0016\u001cW\u000f^8s%\u0016lwN^3e)%i\u0015qQAE\u0003\u001b\u000b\t\nC\u0004\u0002p\u0005\u0005\u0005\u0019A\u001a\t\u000f\u0005-\u0015\u0011\u0011a\u0001g\u00059Q.Z:tC\u001e,\u0007\u0002CAH\u0003\u0003\u0003\r!!\f\u0002\u0015\u0015D\u0018\u000e^*uCR,8\u000f\u0003\u0005\u0002\u0014\u0006\u0005\u0005\u0019AAK\u0003)9xN]6fe2{7\u000f\u001e\t\u0004]\u0005]\u0015bAAM_\t9!i\\8mK\u0006t\u0007bBAO\u0001\u0011\u0005\u0013qT\u0001\u000eo>\u00148.\u001a:SK6|g/\u001a3\u0015\u000f5\u000b\t+a)\u0002(\"9\u00111OAN\u0001\u0004\u0019\u0004bBAS\u00037\u0003\raM\u0001\u0005Q>\u001cH\u000fC\u0004\u0002\f\u0006m\u0005\u0019A\u001a\t\u000f\u0005-\u0006\u0001\"\u0011\u0002.\u0006i2/\u001e4gS\u000eLWM\u001c;SKN|WO]2fgJ+w-[:uKJ,G\r\u0006\u0002\u0002\u0016\"9\u0011\u0011\u0017\u0001\u0005B\u0005M\u0016!D1qa2L7-\u0019;j_:LE\rF\u00014\u0011\u001d\t9\f\u0001C)\u0003s\u000bq\u0003Z8SKF,Xm\u001d;U_R\fG.\u0012=fGV$xN]:\u0015\t\u0005m\u0016Q\u0019\t\u0007\u0003{\u000b\t-!&\u000e\u0005\u0005}&B\u0001/0\u0013\u0011\t\u0019-a0\u0003\r\u0019+H/\u001e:f\u0011!\t9-!.A\u0002\u0005M\u0012A\u0004:fcV,7\u000f^3e)>$\u0018\r\u001c\u0005\b\u0003\u0017\u0004A\u0011KAg\u0003=!wnS5mY\u0016CXmY;u_J\u001cH\u0003BA^\u0003\u001fD\u0001\"!5\u0002J\u0002\u0007\u00111[\u0001\fKb,7-\u001e;pe&#7\u000fE\u0003\u0002V\u0006}7G\u0004\u0003\u0002X\u0006mgb\u0001\u001c\u0002Z&\t\u0001'C\u0002\u0002^>\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002b\u0006\r(aA*fc*\u0019\u0011Q\\\u0018\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002L\u0005\u0019r/Y5u\r>\u0014(+Z4jgR\u0014\u0018\r^5p]\"9\u00111\u001e\u0001\u0005\n\u0005-\u0013!\u00048pi&4\u0017pQ8oi\u0016DH\u000fC\u0004\u0002P\u0001!I!a<\u0015\u00075\u000b\t\u0010\u0003\u0005\u0002t\u00065\b\u0019AA{\u0003)1\u0017N\\1m'R\fG/\u001a\t\u0005\u0003o\fiPD\u0002j\u0003sL1!a?k\u00039\u0019\u0006/\u0019:l\u0003B\u0004\b*\u00198eY\u0016LA!a@\u0003\u0002\t)1\u000b^1uK*\u0019\u00111 6\t\u001d\t\u0015\u0001\u0001%A\u0002\u0002\u0003%I!a-\u0003\b\u0005\u00192/\u001e9fe\u0012\n\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JI&!\u0011\u0011\u0017B\u0005\u0013\r\u0011Y\u0001\u0002\u0002\u0011'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u0004")
public class StandaloneSchedulerBackend
extends CoarseGrainedSchedulerBackend
implements StandaloneAppClientListener {
    private final TaskSchedulerImpl scheduler;
    public final SparkContext org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc;
    private final String[] masters;
    private StandaloneAppClient client;
    private final AtomicBoolean stopping;
    private final LauncherBackend launcherBackend;
    private volatile Function1<StandaloneSchedulerBackend, BoxedUnit> shutdownCallback;
    private volatile String appId;
    private final Semaphore registrationBarrier;
    private final Option<Object> maxCores;
    private final int totalExpectedCores;

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$(this);
    }

    private StandaloneAppClient client() {
        return this.client;
    }

    private void client_$eq(StandaloneAppClient x$1) {
        this.client = x$1;
    }

    private AtomicBoolean stopping() {
        return this.stopping;
    }

    private LauncherBackend launcherBackend() {
        return this.launcherBackend;
    }

    public Function1<StandaloneSchedulerBackend, BoxedUnit> shutdownCallback() {
        return this.shutdownCallback;
    }

    public void shutdownCallback_$eq(Function1<StandaloneSchedulerBackend, BoxedUnit> x$1) {
        this.shutdownCallback = x$1;
    }

    private String appId() {
        return this.appId;
    }

    private void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    private Semaphore registrationBarrier() {
        return this.registrationBarrier;
    }

    private Option<Object> maxCores() {
        return this.maxCores;
    }

    private int totalExpectedCores() {
        return this.totalExpectedCores;
    }

    @Override
    public void start() {
        super.start();
        String string = this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.deployMode();
        String string2 = "client";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.launcherBackend().connect();
        }
        String driverUrl = RpcEndpointAddress$.MODULE$.apply(this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().get("spark.driver.host"), new StringOps(Predef$.MODULE$.augmentString(this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().get("spark.driver.port"))).toInt(), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()).toString();
        Seq args = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--driver-url", driverUrl, "--executor-id", "{{EXECUTOR_ID}}", "--hostname", "{{HOSTNAME}}", "--cores", "{{CORES}}", "--app-id", "{{APP_ID}}", "--worker-url", "{{WORKER_URL}}"}));
        Seq extraJavaOpts = (Seq)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().getOption("spark.executor.extraJavaOptions").map((Function1 & Serializable & scala.Serializable)s -> Utils$.MODULE$.splitCommandString((String)s)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Seq classPathEntries = (Seq)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().getOption("spark.executor.extraClassPath").map((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.split(File.pathSeparator))).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Seq libraryPathEntries = (Seq)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().getOption("spark.executor.extraLibraryPath").map((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.split(File.pathSeparator))).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Nil$ testingClassPath = package$.MODULE$.props().contains("spark.testing") ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)package$.MODULE$.props().apply((Object)"java.class.path")).split(File.pathSeparator))).toSeq() : Nil$.MODULE$;
        Seq<String> sparkJavaOpts = Utils$.MODULE$.sparkJavaOpts(this.conf(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)SparkConf$.MODULE$.isExecutorStartupConf(name)));
        Seq javaOpts = (Seq)sparkJavaOpts.$plus$plus((GenTraversableOnce)extraJavaOpts, Seq$.MODULE$.canBuildFrom());
        Command command = new Command("org.apache.spark.executor.CoarseGrainedExecutorBackend", (Seq<String>)args, (Map<String, String>)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.executorEnvs(), (Seq<String>)((Seq)classPathEntries.$plus$plus((GenTraversableOnce)testingClassPath, Seq$.MODULE$.canBuildFrom())), (Seq<String>)libraryPathEntries, (Seq<String>)javaOpts);
        String webUrl = (String)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.ui().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.webUrl()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Option coresPerExecutor = this.conf().getOption("spark.executor.cores").map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)StandaloneSchedulerBackend.$anonfun$start$10(x$5)));
        None$ initialExecutorLimit = Utils$.MODULE$.isDynamicAllocationEnabled(this.conf()) ? new Some((Object)BoxesRunTime.boxToInteger((int)0)) : None$.MODULE$;
        ApplicationDescription appDesc = new ApplicationDescription(this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.appName(), this.maxCores(), this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.executorMemory(), command, webUrl, this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.eventLogDir(), this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.eventLogCodec(), (Option<Object>)coresPerExecutor, (Option<Object>)initialExecutorLimit, ApplicationDescription$.MODULE$.apply$default$10());
        this.client_$eq(new StandaloneAppClient(this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.env().rpcEnv(), this.masters, appDesc, this, this.conf()));
        this.client().start();
        this.launcherBackend().setState(SparkAppHandle.State.SUBMITTED);
        this.waitForRegistration();
        this.launcherBackend().setState(SparkAppHandle.State.RUNNING);
    }

    @Override
    public void stop() {
        this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$stop(SparkAppHandle.State.FINISHED);
    }

    @Override
    public void connected(String appId) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Connected to Spark cluster with app ID ").append(appId).toString());
        this.appId_$eq(appId);
        this.notifyContext();
        this.launcherBackend().setAppId(appId);
    }

    @Override
    public void disconnected() {
        block0: {
            this.notifyContext();
            if (this.stopping().get()) break block0;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Disconnected from Spark cluster! Waiting for reconnection...");
        }
    }

    @Override
    public void dead(String reason) {
        this.notifyContext();
        if (!this.stopping().get()) {
            this.launcherBackend().setState(SparkAppHandle.State.KILLED);
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Application has been killed. Reason: ").append(reason).toString());
            try {
                this.scheduler.error(reason);
            }
            finally {
                this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.stopInNewThread();
            }
        }
    }

    @Override
    public void executorAdded(String fullId, String workerId, String hostPort, int cores, int memory) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Granted executor ID %s on hostPort %s with %d core(s), %s RAM")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullId, hostPort, BoxesRunTime.boxToInteger((int)cores), Utils$.MODULE$.megabytesToString(memory)})));
    }

    @Override
    public void executorRemoved(String fullId, String message, Option<Object> exitStatus, boolean workerLost) {
        ExecutorLossReason executorLossReason;
        Option<Object> option = exitStatus;
        if (option instanceof Some) {
            Some some = (Some)option;
            int code = BoxesRunTime.unboxToInt((Object)some.value());
            executorLossReason = new ExecutorExited(code, true, message);
        } else if (None$.MODULE$.equals(option)) {
            executorLossReason = new SlaveLost(message, workerLost);
        } else {
            throw new MatchError(option);
        }
        SlaveLost reason = executorLossReason;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Executor %s removed: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullId, message})));
        this.removeExecutor(fullId.split("/")[1], reason);
    }

    @Override
    public void workerRemoved(String workerId, String host, String message) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Worker %s removed: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workerId, message})));
        this.removeWorker(workerId, host, message);
    }

    @Override
    public boolean sufficientResourcesRegistered() {
        return (double)this.totalCoreCount().get() >= (double)this.totalExpectedCores() * this.minRegisteredRatio();
    }

    @Override
    public String applicationId() {
        return (String)Option$.MODULE$.apply((Object)this.appId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Application ID is not initialized yet.");
            return this.super$applicationId();
        });
    }

    @Override
    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        Future future;
        Option option = Option$.MODULE$.apply((Object)this.client());
        if (option instanceof Some) {
            Some some = (Some)option;
            StandaloneAppClient c = (StandaloneAppClient)some.value();
            future = c.requestTotalExecutors(requestedTotal);
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to request executors before driver fully initialized.");
            future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    @Override
    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        Future future;
        Option option = Option$.MODULE$.apply((Object)this.client());
        if (option instanceof Some) {
            Some some = (Some)option;
            StandaloneAppClient c = (StandaloneAppClient)some.value();
            future = c.killExecutors(executorIds);
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to kill executors before driver fully initialized.");
            future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    private void waitForRegistration() {
        this.registrationBarrier().acquire();
    }

    private void notifyContext() {
        this.registrationBarrier().release();
    }

    public void org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$stop(SparkAppHandle.State finalState) {
        if (this.stopping().compareAndSet(false, true)) {
            try {
                super.stop();
                this.client().stop();
                Function1<StandaloneSchedulerBackend, BoxedUnit> callback = this.shutdownCallback();
                if (callback != null) {
                    callback.apply((Object)this);
                }
            }
            finally {
                this.launcherBackend().setState(finalState);
                this.launcherBackend().close();
            }
        }
    }

    public static final /* synthetic */ int $anonfun$maxCores$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ int $anonfun$start$10(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
    }

    public StandaloneSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, String[] masters) {
        this.scheduler = scheduler;
        this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc = sc;
        this.masters = masters;
        super(scheduler, sc.env().rpcEnv());
        this.client = null;
        this.stopping = new AtomicBoolean(false);
        this.launcherBackend = new LauncherBackend(this){
            private final /* synthetic */ StandaloneSchedulerBackend $outer;

            public SparkConf conf() {
                return this.$outer.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf();
            }

            public void onStopRequest() {
                this.$outer.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$stop(SparkAppHandle.State.KILLED);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.registrationBarrier = new Semaphore(0);
        this.maxCores = this.conf().getOption("spark.cores.max").map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StandaloneSchedulerBackend.$anonfun$maxCores$1(x$1)));
        this.totalExpectedCores = BoxesRunTime.unboxToInt((Object)this.maxCores().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }
}

