/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.metrics.MetricsSystem;
import org.apache.spark.scheduler.AsyncEventQueue;
import org.apache.spark.scheduler.LiveListenerBus$;
import org.apache.spark.scheduler.LiveListenerBusMetrics;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.DynamicVariable;

@ScalaSignature(bytes="\u0006\u0001\t=c!B\u0001\u0003\u0001\u0011Q!a\u0004'jm\u0016d\u0015n\u001d;f]\u0016\u0014()^:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7C\u0001\u0001\f!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fM\"A!\u0003\u0001B\u0001B\u0003%A#\u0001\u0003d_:47\u0001\u0001\t\u0003+Yi\u0011\u0001B\u0005\u0003/\u0011\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\tYR\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0003\u00131\u0001\u0007A\u0003C\u0005 \u0001\u0001\u0007\t\u0019!C\u0005A\u0005a1\u000f]1sW\u000e{g\u000e^3yiV\t\u0011\u0005\u0005\u0002\u0016E%\u00111\u0005\u0002\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\nK\u0001\u0001\r\u00111A\u0005\n\u0019\n\u0001c\u001d9be.\u001cuN\u001c;fqR|F%Z9\u0015\u0005\u001dR\u0003C\u0001\u0007)\u0013\tISB\u0001\u0003V]&$\bbB\u0016%\u0003\u0003\u0005\r!I\u0001\u0004q\u0012\n\u0004\"C\u0017\u0001\u0001\u0004\u0005\t\u0015)\u0003\"\u00035\u0019\b/\u0019:l\u0007>tG/\u001a=uA!Aq\u0006\u0001b\u0001\n\u0003!\u0001'A\u0004nKR\u0014\u0018nY:\u0016\u0003E\u0002\"\u0001\b\u001a\n\u0005M\u0012!A\u0006'jm\u0016d\u0015n\u001d;f]\u0016\u0014()^:NKR\u0014\u0018nY:\t\rU\u0002\u0001\u0015!\u00032\u0003!iW\r\u001e:jGN\u0004\u0003bB\u001c\u0001\u0005\u0004%I\u0001O\u0001\bgR\f'\u000f^3e+\u0005I\u0004C\u0001\u001eD\u001b\u0005Y$B\u0001\u001f>\u0003\u0019\tGo\\7jG*\u0011ahP\u0001\u000bG>t7-\u001e:sK:$(B\u0001!B\u0003\u0011)H/\u001b7\u000b\u0003\t\u000bAA[1wC&\u0011Ai\u000f\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\r\u0019\u0003\u0001\u0015!\u0003:\u0003!\u0019H/\u0019:uK\u0012\u0004\u0003b\u0002%\u0001\u0005\u0004%I\u0001O\u0001\bgR|\u0007\u000f]3e\u0011\u0019Q\u0005\u0001)A\u0005s\u0005A1\u000f^8qa\u0016$\u0007\u0005C\u0004M\u0001\t\u0007I\u0011B'\u0002)\u0011\u0014x\u000e\u001d9fI\u00163XM\u001c;t\u0007>,h\u000e^3s+\u0005q\u0005C\u0001\u001eP\u0013\t\u00016H\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDaA\u0015\u0001!\u0002\u0013q\u0015!\u00063s_B\u0004X\rZ#wK:$8oQ8v]R,'\u000f\t\u0005\b)\u0002\u0001\r\u0011\"\u0003V\u0003Ma\u0017m\u001d;SKB|'\u000f\u001e+j[\u0016\u001cH/Y7q+\u00051\u0006C\u0001\u0007X\u0013\tAVB\u0001\u0003M_:<\u0007b\u0002.\u0001\u0001\u0004%IaW\u0001\u0018Y\u0006\u001cHOU3q_J$H+[7fgR\fW\u000e]0%KF$\"a\n/\t\u000f-J\u0016\u0011!a\u0001-\"1a\f\u0001Q!\nY\u000bA\u0003\\1tiJ+\u0007o\u001c:u)&lWm\u001d;b[B\u0004\u0003FA/a!\ta\u0011-\u0003\u0002c\u001b\tAao\u001c7bi&dW\rC\u0004e\u0001\t\u0007I\u0011B3\u0002\rE,X-^3t+\u00051\u0007cA4iU6\tQ(\u0003\u0002j{\t!2i\u001c9z\u001f:<&/\u001b;f\u0003J\u0014\u0018-\u001f'jgR\u0004\"\u0001H6\n\u00051\u0014!aD!ts:\u001cWI^3oiF+X-^3\t\r9\u0004\u0001\u0015!\u0003g\u0003\u001d\tX/Z;fg\u0002B\u0001\u0002\u001d\u0001A\u0002\u0013\u0005!!]\u0001\rcV,W/\u001a3Fm\u0016tGo]\u000b\u0002eB\u00191\u000f\u001f>\u000e\u0003QT!!\u001e<\u0002\u000f5,H/\u00192mK*\u0011q/D\u0001\u000bG>dG.Z2uS>t\u0017BA=u\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u00039mL!\u0001 \u0002\u0003%M\u0003\u0018M]6MSN$XM\\3s\u000bZ,g\u000e\u001e\u0005\t}\u0002\u0001\r\u0011\"\u0001\u0003\u007f\u0006\u0001\u0012/^3vK\u0012,e/\u001a8ug~#S-\u001d\u000b\u0004O\u0005\u0005\u0001bB\u0016~\u0003\u0003\u0005\rA\u001d\u0005\b\u0003\u000b\u0001\u0001\u0015)\u0003s\u00035\tX/Z;fI\u00163XM\u001c;tA!\u001a\u00111\u00011\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\u0005\u0001\u0012\r\u001a3U_NC\u0017M]3e#V,W/\u001a\u000b\u0004O\u0005=\u0001\u0002CA\t\u0003\u0013\u0001\r!a\u0005\u0002\u00111L7\u000f^3oKJ\u00042\u0001HA\u000b\u0013\r\t9B\u0001\u0002\u0017'B\f'o\u001b'jgR,g.\u001a:J]R,'OZ1dK\"9\u00111\u0004\u0001\u0005\u0002\u0005u\u0011\u0001F1eIR{W*\u00198bO\u0016lWM\u001c;Rk\u0016,X\rF\u0002(\u0003?A\u0001\"!\u0005\u0002\u001a\u0001\u0007\u00111\u0003\u0005\b\u0003G\u0001A\u0011AA\u0013\u0003A\tG\r\u001a+p'R\fG/^:Rk\u0016,X\rF\u0002(\u0003OA\u0001\"!\u0005\u0002\"\u0001\u0007\u00111\u0003\u0005\b\u0003W\u0001A\u0011AA\u0017\u0003I\tG\r\u001a+p\u000bZ,g\u000e\u001e'pOF+X-^3\u0015\u0007\u001d\ny\u0003\u0003\u0005\u0002\u0012\u0005%\u0002\u0019AA\n\u0011!\t\u0019\u0004\u0001C\u0001\t\u0005U\u0012AC1eIR{\u0017+^3vKR)q%a\u000e\u0002:!A\u0011\u0011CA\u0019\u0001\u0004\t\u0019\u0002\u0003\u0005\u0002<\u0005E\u0002\u0019AA\u001f\u0003\u0015\tX/Z;f!\u0011\ty$!\u0014\u000f\t\u0005\u0005\u0013\u0011\n\t\u0004\u0003\u0007jQBAA#\u0015\r\t9eE\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-S\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\n\tF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017j\u0001bBA+\u0001\u0011\u0005\u0011qK\u0001\u000fe\u0016lwN^3MSN$XM\\3s)\r9\u0013\u0011\f\u0005\t\u0003#\t\u0019\u00061\u0001\u0002\u0014!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0013\u0001\u00029pgR$2aJA1\u0011\u001d\t\u0019'a\u0017A\u0002i\fQ!\u001a<f]RDq!a\u001a\u0001\t\u0013\tI'\u0001\u0007q_N$Hk\\)vKV,7\u000fF\u0002(\u0003WBq!a\u0019\u0002f\u0001\u0007!\u0010C\u0004\u0002p\u0001!\t!!\u001d\u0002\u000bM$\u0018M\u001d;\u0015\u000b\u001d\n\u0019(a\u001e\t\u000f\u0005U\u0014Q\u000ea\u0001C\u0005\u00111o\u0019\u0005\t\u0003s\ni\u00071\u0001\u0002|\u0005iQ.\u001a;sS\u000e\u001c8+_:uK6\u0004B!! \u0002\u00026\u0011\u0011q\u0010\u0006\u0003_\u0011IA!a!\u0002\u0000\tiQ*\u001a;sS\u000e\u001c8+_:uK6Dq!a\"\u0001\t\u0003\tI)\u0001\bxC&$XK\u001c;jY\u0016k\u0007\u000f^=\u0015\u0007\u001d\nY\tC\u0004\u0002\u000e\u0006\u0015\u0005\u0019\u0001,\u0002\u001bQLW.Z8vi6KG\u000e\\5tQ\u0019\t))!%\u0002\u001eB)A\"a%\u0002\u0018&\u0019\u0011QS\u0007\u0003\rQD'o\\<t!\r9\u0017\u0011T\u0005\u0004\u00037k$\u0001\u0005+j[\u0016|W\u000f^#yG\u0016\u0004H/[8oG\t\t9\nC\u0004\u0002\"\u0002!\t!a)\u0002\tM$x\u000e\u001d\u000b\u0002O!A\u0011q\u0015\u0001\u0005\u0002\u0011\tI+\u0001\u000bgS:$G*[:uK:,'o\u001d\"z\u00072\f7o]\u000b\u0005\u0003W\u000b)\r\u0006\u0002\u0002.R!\u0011qVAi!\u0019\t\t,a/\u0002B:!\u00111WA\\\u001d\u0011\t\u0019%!.\n\u00039I1!!/\u000e\u0003\u001d\u0001\u0018mY6bO\u0016LA!!0\u0002@\n\u00191+Z9\u000b\u0007\u0005eV\u0002\u0005\u0003\u0002D\u0006\u0015G\u0002\u0001\u0003\t\u0003\u000f\f)K1\u0001\u0002J\n\tA+\u0005\u0003\u0002L\u0006M\u0001c\u0001\u0007\u0002N&\u0019\u0011qZ\u0007\u0003\u000f9{G\u000f[5oO\"Q\u00111[AS\u0003\u0003\u0005\u001d!!6\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0002X\u0006u\u0017\u0011Y\u0007\u0003\u00033T1!a7\u000e\u0003\u001d\u0011XM\u001a7fGRLA!a8\u0002Z\nA1\t\\1tgR\u000bw\r\u0003\u0005\u0002d\u0002!\t\u0001BAs\u0003%a\u0017n\u001d;f]\u0016\u00148/\u0006\u0002\u0002hB1\u0011\u0011^Av\u0003'i\u0011aP\u0005\u0004\u0003[|$\u0001\u0002'jgRD\u0001\"!=\u0001\t\u0003\u0011\u00111_\u0001\rC\u000e$\u0018N^3Rk\u0016,Xm\u001d\u000b\u0003\u0003k\u0004b!a\u0010\u0002x\u0006u\u0012\u0002BA}\u0003#\u00121aU3u\u000f!\tiP\u0001E\u0001\t\u0005}\u0018a\u0004'jm\u0016d\u0015n\u001d;f]\u0016\u0014()^:\u0011\u0007q\u0011\tAB\u0004\u0002\u0005!\u0005AAa\u0001\u0014\u0007\t\u00051\u0002C\u0004\u001a\u0005\u0003!\tAa\u0002\u0015\u0005\u0005}\bB\u0003B\u0006\u0005\u0003\u0011\r\u0011\"\u0001\u0003\u000e\u0005!r/\u001b;iS:d\u0015n\u001d;f]\u0016\u0014H\u000b\u001b:fC\u0012,\"Aa\u0004\u0011\r\tE!Q\u0003B\r\u001b\t\u0011\u0019B\u0003\u0002A\u001b%!!q\u0003B\n\u0005=!\u0015P\\1nS\u000e4\u0016M]5bE2,\u0007c\u0001\u0007\u0003\u001c%\u0019!QD\u0007\u0003\u000f\t{w\u000e\\3b]\"I!\u0011\u0005B\u0001A\u0003%!qB\u0001\u0016o&$\b.\u001b8MSN$XM\\3s)\"\u0014X-\u00193!\u0011-\u0011)C!\u0001C\u0002\u0013\u0005!Aa\n\u0002\u0019MC\u0015IU#E?F+V)V#\u0016\u0005\t%\u0002\u0003\u0002B\u0016\u0005ci!A!\f\u000b\u0007\t=\u0012)\u0001\u0003mC:<\u0017\u0002BA(\u0005[A\u0011B!\u000e\u0003\u0002\u0001\u0006IA!\u000b\u0002\u001bMC\u0015IU#E?F+V)V#!\u0011-\u0011ID!\u0001C\u0002\u0013\u0005!Aa\n\u0002!\u0005\u0003\u0006kX*U\u0003R+6kX)V\u000bV+\u0005\"\u0003B\u001f\u0005\u0003\u0001\u000b\u0011\u0002B\u0015\u0003E\t\u0005\u000bU0T)\u0006#VkU0R+\u0016+V\t\t\u0005\f\u0005\u0003\u0012\tA1A\u0005\u0002\t\u00119#A\rF1\u0016\u001bU\u000bV(S?6\u000be*Q$F\u001b\u0016sEkX)V\u000bV+\u0005\"\u0003B#\u0005\u0003\u0001\u000b\u0011\u0002B\u0015\u0003i)\u0005,R\"V)>\u0013v,T!O\u0003\u001e+U*\u0012(U?F+V)V#!\u0011-\u0011IE!\u0001C\u0002\u0013\u0005!Aa\n\u0002\u001f\u00153VI\u0014+`\u0019>;u,U+F+\u0016C\u0011B!\u0014\u0003\u0002\u0001\u0006IA!\u000b\u0002!\u00153VI\u0014+`\u0019>;u,U+F+\u0016\u0003\u0003")
public class LiveListenerBus {
    private final SparkConf conf;
    private SparkContext sparkContext;
    private final LiveListenerBusMetrics metrics;
    private final AtomicBoolean started;
    private final AtomicBoolean stopped;
    private final AtomicLong droppedEventsCounter;
    private volatile long lastReportTimestamp;
    private final CopyOnWriteArrayList<AsyncEventQueue> queues;
    private volatile ListBuffer<SparkListenerEvent> queuedEvents;

    public static DynamicVariable<Object> withinListenerThread() {
        return LiveListenerBus$.MODULE$.withinListenerThread();
    }

    private SparkContext sparkContext() {
        return this.sparkContext;
    }

    private void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    public LiveListenerBusMetrics metrics() {
        return this.metrics;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private AtomicLong droppedEventsCounter() {
        return this.droppedEventsCounter;
    }

    private long lastReportTimestamp() {
        return this.lastReportTimestamp;
    }

    private void lastReportTimestamp_$eq(long x$1) {
        this.lastReportTimestamp = x$1;
    }

    private CopyOnWriteArrayList<AsyncEventQueue> queues() {
        return this.queues;
    }

    public ListBuffer<SparkListenerEvent> queuedEvents() {
        return this.queuedEvents;
    }

    public void queuedEvents_$eq(ListBuffer<SparkListenerEvent> x$1) {
        this.queuedEvents = x$1;
    }

    public void addToSharedQueue(SparkListenerInterface listener) {
        this.addToQueue(listener, LiveListenerBus$.MODULE$.SHARED_QUEUE());
    }

    public void addToManagementQueue(SparkListenerInterface listener) {
        this.addToQueue(listener, LiveListenerBus$.MODULE$.EXECUTOR_MANAGEMENT_QUEUE());
    }

    public void addToStatusQueue(SparkListenerInterface listener) {
        this.addToQueue(listener, LiveListenerBus$.MODULE$.APP_STATUS_QUEUE());
    }

    public void addToEventLogQueue(SparkListenerInterface listener) {
        this.addToQueue(listener, LiveListenerBus$.MODULE$.EVENT_LOG_QUEUE());
    }

    public void addToQueue(SparkListenerInterface listener, String queue) {
        LiveListenerBus liveListenerBus = this;
        synchronized (liveListenerBus) {
            Object object;
            if (this.stopped().get()) {
                throw new IllegalStateException("LiveListenerBus is stopped.");
            }
            Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LiveListenerBus.$anonfun$addToQueue$1(queue, x$1)));
            if (option instanceof Some) {
                Some some = (Some)option;
                AsyncEventQueue queue2 = (AsyncEventQueue)some.value();
                queue2.addListener(listener);
                object = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                AsyncEventQueue newQueue = new AsyncEventQueue(queue, this.conf, this.metrics(), this);
                newQueue.addListener(listener);
                if (this.started().get()) {
                    newQueue.start(this.sparkContext());
                }
                object = BoxesRunTime.boxToBoolean((boolean)this.queues().add(newQueue));
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    public synchronized void removeListener(SparkListenerInterface listener) {
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).filter((Function1 & Serializable & scala.Serializable)queue -> BoxesRunTime.boxToBoolean((boolean)LiveListenerBus.$anonfun$removeListener$1(listener, queue)))).foreach((Function1 & Serializable & scala.Serializable)toRemove -> BoxesRunTime.boxToBoolean((boolean)LiveListenerBus.$anonfun$removeListener$2(this, toRemove)));
    }

    public void post(SparkListenerEvent event) {
        block7: {
            if (this.stopped().get()) {
                return;
            }
            this.metrics().numEventsPosted().inc();
            if (this.queuedEvents() == null) {
                this.postToQueues(event);
                return;
            }
            LiveListenerBus liveListenerBus = this;
            synchronized (liveListenerBus) {
                block6: {
                    if (!this.started().get()) {
                        this.queuedEvents().$plus$eq((Object)event);
                        break block6;
                    }
                    break block7;
                }
                return;
            }
        }
        this.postToQueues(event);
    }

    private void postToQueues(SparkListenerEvent event) {
        Iterator<AsyncEventQueue> it = this.queues().iterator();
        while (it.hasNext()) {
            it.next().post(event);
        }
    }

    public synchronized void start(SparkContext sc, MetricsSystem metricsSystem) {
        if (!this.started().compareAndSet(false, true)) {
            throw new IllegalStateException("LiveListenerBus already started.");
        }
        this.sparkContext_$eq(sc);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)q -> {
            LiveListenerBus.$anonfun$start$1(this, sc, q);
            return BoxedUnit.UNIT;
        });
        this.queuedEvents_$eq(null);
        metricsSystem.registerSource(this.metrics());
    }

    public void waitUntilEmpty(long timeoutMillis) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeoutMillis;
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)queue -> {
            LiveListenerBus.$anonfun$waitUntilEmpty$1(timeoutMillis, deadline, queue);
            return BoxedUnit.UNIT;
        });
    }

    public void stop() {
        if (!this.started().get()) {
            throw new IllegalStateException("Attempted to stop bus that has not yet started!");
        }
        if (!this.stopped().compareAndSet(false, true)) {
            return;
        }
        LiveListenerBus liveListenerBus = this;
        synchronized (liveListenerBus) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.stop();
                return BoxedUnit.UNIT;
            });
            this.queues().clear();
        }
    }

    public <T extends SparkListenerInterface> Seq<T> findListenersByClass(ClassTag<T> evidence$1) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)queue -> queue.findListenersByClass(evidence$1), Buffer$.MODULE$.canBuildFrom());
    }

    public List<SparkListenerInterface> listeners() {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$3.listeners()).asScala(), Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    public Set<String> activeQueues() {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.queues()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$addToQueue$1(String queue$1, AsyncEventQueue x$1) {
        String string = x$1.name();
        String string2 = queue$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removeListener$1(SparkListenerInterface listener$1, AsyncEventQueue queue) {
        queue.removeListener(listener$1);
        return queue.listeners().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$removeListener$2(LiveListenerBus $this, AsyncEventQueue toRemove) {
        block0: {
            if (!$this.started().get() || $this.stopped().get()) break block0;
            toRemove.stop();
        }
        return $this.queues().remove(toRemove);
    }

    public static final /* synthetic */ void $anonfun$start$1(LiveListenerBus $this, SparkContext sc$1, AsyncEventQueue q) {
        q.start(sc$1);
        $this.queuedEvents().foreach((Function1 & Serializable & scala.Serializable)event -> {
            q.post(event);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitUntilEmpty$1(long timeoutMillis$1, long deadline$1, AsyncEventQueue queue) {
        if (!queue.waitUntilEmpty(deadline$1)) {
            throw new TimeoutException(new StringBuilder(39).append("The event queue is not empty after ").append(timeoutMillis$1).append(" ms.").toString());
        }
    }

    public LiveListenerBus(SparkConf conf) {
        this.conf = conf;
        this.metrics = new LiveListenerBusMetrics(conf);
        this.started = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
        this.droppedEventsCounter = new AtomicLong(0L);
        this.lastReportTimestamp = 0L;
        this.queues = new CopyOnWriteArrayList();
        this.queuedEvents = new ListBuffer();
    }
}

