/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.apache.spark.SparkConf;
import org.apache.spark.util.IntParam$;
import org.apache.spark.util.MemoryParam$;
import org.apache.spark.util.Utils$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb!B\u0001\u0003\u0001\ta!aD,pe.,'/\u0011:hk6,g\u000e^:\u000b\u0005\r!\u0011AB<pe.,'O\u0003\u0002\u0006\r\u00051A-\u001a9m_fT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0003\u00015\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007\u0002\u0003\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\t\u0005\u0014xm]\u0002\u0001!\rqq#G\u0005\u00031=\u0011Q!\u0011:sCf\u0004\"AG\u0011\u000f\u0005my\u0002C\u0001\u000f\u0010\u001b\u0005i\"B\u0001\u0010\u0016\u0003\u0019a$o\\8u}%\u0011\u0001eD\u0001\u0007!J,G-\u001a4\n\u0005\t\u001a#AB*ue&twM\u0003\u0002!\u001f!AQ\u0005\u0001B\u0001B\u0003%a%\u0001\u0003d_:4\u0007CA\u0014)\u001b\u00051\u0011BA\u0015\u0007\u0005%\u0019\u0006/\u0019:l\u0007>tg\rC\u0003,\u0001\u0011\u0005A&\u0001\u0004=S:LGO\u0010\u000b\u0004[=\u0002\u0004C\u0001\u0018\u0001\u001b\u0005\u0011\u0001\"\u0002\u000b+\u0001\u00041\u0002\"B\u0013+\u0001\u00041\u0003b\u0002\u001a\u0001\u0001\u0004%\taM\u0001\u0005Q>\u001cH/F\u0001\u001a\u0011\u001d)\u0004\u00011A\u0005\u0002Y\n\u0001\u0002[8ti~#S-\u001d\u000b\u0003oi\u0002\"A\u0004\u001d\n\u0005ez!\u0001B+oSRDqa\u000f\u001b\u0002\u0002\u0003\u0007\u0011$A\u0002yIEBa!\u0010\u0001!B\u0013I\u0012!\u00025pgR\u0004\u0003bB \u0001\u0001\u0004%\t\u0001Q\u0001\u0005a>\u0014H/F\u0001B!\tq!)\u0003\u0002D\u001f\t\u0019\u0011J\u001c;\t\u000f\u0015\u0003\u0001\u0019!C\u0001\r\u0006A\u0001o\u001c:u?\u0012*\u0017\u000f\u0006\u00028\u000f\"91\bRA\u0001\u0002\u0004\t\u0005BB%\u0001A\u0003&\u0011)A\u0003q_J$\b\u0005C\u0004L\u0001\u0001\u0007I\u0011\u0001!\u0002\u0013],'-V5Q_J$\bbB'\u0001\u0001\u0004%\tAT\u0001\u000eo\u0016\u0014W+\u001b)peR|F%Z9\u0015\u0005]z\u0005bB\u001eM\u0003\u0003\u0005\r!\u0011\u0005\u0007#\u0002\u0001\u000b\u0015B!\u0002\u0015],'-V5Q_J$\b\u0005C\u0004T\u0001\u0001\u0007I\u0011\u0001!\u0002\u000b\r|'/Z:\t\u000fU\u0003\u0001\u0019!C\u0001-\u0006I1m\u001c:fg~#S-\u001d\u000b\u0003o]Cqa\u000f+\u0002\u0002\u0003\u0007\u0011\t\u0003\u0004Z\u0001\u0001\u0006K!Q\u0001\u0007G>\u0014Xm\u001d\u0011\t\u000fm\u0003\u0001\u0019!C\u0001\u0001\u00061Q.Z7pefDq!\u0018\u0001A\u0002\u0013\u0005a,\u0001\u0006nK6|'/_0%KF$\"aN0\t\u000fmb\u0016\u0011!a\u0001\u0003\"1\u0011\r\u0001Q!\n\u0005\u000bq!\\3n_JL\b\u0005C\u0004d\u0001\u0001\u0007I\u0011\u00013\u0002\u000f5\f7\u000f^3sgV\ta\u0003C\u0004g\u0001\u0001\u0007I\u0011A4\u0002\u00175\f7\u000f^3sg~#S-\u001d\u000b\u0003o!DqaO3\u0002\u0002\u0003\u0007a\u0003\u0003\u0004k\u0001\u0001\u0006KAF\u0001\t[\u0006\u001cH/\u001a:tA!9A\u000e\u0001a\u0001\n\u0003\u0019\u0014aB<pe.$\u0015N\u001d\u0005\b]\u0002\u0001\r\u0011\"\u0001p\u0003-9xN]6ESJ|F%Z9\u0015\u0005]\u0002\bbB\u001en\u0003\u0003\u0005\r!\u0007\u0005\u0007e\u0002\u0001\u000b\u0015B\r\u0002\u0011]|'o\u001b#je\u0002Bq\u0001\u001e\u0001A\u0002\u0013\u00051'\u0001\bqe>\u0004XM\u001d;jKN4\u0015\u000e\\3\t\u000fY\u0004\u0001\u0019!C\u0001o\u0006\u0011\u0002O]8qKJ$\u0018.Z:GS2,w\fJ3r)\t9\u0004\u0010C\u0004<k\u0006\u0005\t\u0019A\r\t\ri\u0004\u0001\u0015)\u0003\u001a\u0003=\u0001(o\u001c9feRLWm\u001d$jY\u0016\u0004\u0003\"\u0002?\u0001\t\u0013i\u0018!\u00029beN,GCA\u001c\u007f\u0011\u0015!2\u00101\u0001\u0000!\u0015\t\t!a\u0003\u001a\u001d\u0011\t\u0019!a\u0002\u000f\u0007q\t)!C\u0001\u0011\u0013\r\tIaD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti!a\u0004\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u0013y\u0001fA>\u0002\u0014A!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a=\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti\"a\u0006\u0003\u000fQ\f\u0017\u000e\u001c:fG\"9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0012!\u00059sS:$Xk]1hK\u0006sG-\u0012=jiR\u0019q'!\n\t\u000f\u0005\u001d\u0012q\u0004a\u0001\u0003\u0006AQ\r_5u\u0007>$W\rC\u0004\u0002,\u0001!\t!!\f\u0002#%tg-\u001a:EK\u001a\fW\u000f\u001c;D_J,7\u000fF\u0001B\u0011\u001d\t\t\u0004\u0001C\u0001\u0003[\t!#\u001b8gKJ$UMZ1vYRlU-\\8ss\"9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0012!E2iK\u000e\\wk\u001c:lKJlU-\\8ssR\tq\u0007")
public class WorkerArguments {
    private String host = Utils$.MODULE$.localHostName();
    private int port = 0;
    private int webUiPort = 8081;
    private int cores = this.inferDefaultCores();
    private int memory = this.inferDefaultMemory();
    private String[] masters = null;
    private String workDir = null;
    private String propertiesFile = null;

    public String host() {
        return this.host;
    }

    public void host_$eq(String x$1) {
        this.host = x$1;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int x$1) {
        this.port = x$1;
    }

    public int webUiPort() {
        return this.webUiPort;
    }

    public void webUiPort_$eq(int x$1) {
        this.webUiPort = x$1;
    }

    public int cores() {
        return this.cores;
    }

    public void cores_$eq(int x$1) {
        this.cores = x$1;
    }

    public int memory() {
        return this.memory;
    }

    public void memory_$eq(int x$1) {
        this.memory = x$1;
    }

    public String[] masters() {
        return this.masters;
    }

    public void masters_$eq(String[] x$1) {
        this.masters = x$1;
    }

    public String workDir() {
        return this.workDir;
    }

    public void workDir_$eq(String x$1) {
        this.workDir = x$1;
    }

    public String propertiesFile() {
        return this.propertiesFile;
    }

    public void propertiesFile_$eq(String x$1) {
        this.propertiesFile = x$1;
    }

    private void parse(List<String> args) {
        block27: {
            List list;
            while (true) {
                String string;
                boolean bl = false;
                .colon.colon colon2 = null;
                list = args;
                if (list instanceof .colon.colon) {
                    bl = true;
                    colon2 = (.colon.colon)list;
                    String string2 = (String)colon2.head();
                    List list2 = colon2.tl$access$1();
                    boolean bl2 = "--ip".equals(string2) ? true : "-i".equals(string2);
                    if (bl2 && list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        String value = (String)colon3.head();
                        List tail = colon3.tl$access$1();
                        Utils$.MODULE$.checkHost(value);
                        this.host_$eq(value);
                        args = tail;
                        continue;
                    }
                }
                if (bl) {
                    String string3 = (String)colon2.head();
                    List list3 = colon2.tl$access$1();
                    boolean bl3 = "--host".equals(string3) ? true : "-h".equals(string3);
                    if (bl3 && list3 instanceof .colon.colon) {
                        .colon.colon colon4 = (.colon.colon)list3;
                        String value = (String)colon4.head();
                        List tail = colon4.tl$access$1();
                        Utils$.MODULE$.checkHost(value);
                        this.host_$eq(value);
                        args = tail;
                        continue;
                    }
                }
                if (bl) {
                    String string4 = (String)colon2.head();
                    List list4 = colon2.tl$access$1();
                    boolean bl4 = "--port".equals(string4) ? true : "-p".equals(string4);
                    if (bl4 && list4 instanceof .colon.colon) {
                        .colon.colon colon5 = (.colon.colon)list4;
                        String string5 = (String)colon5.head();
                        List tail = colon5.tl$access$1();
                        Option<Object> option = IntParam$.MODULE$.unapply(string5);
                        if (!option.isEmpty()) {
                            int value = BoxesRunTime.unboxToInt((Object)option.get());
                            this.port_$eq(value);
                            args = tail;
                            continue;
                        }
                    }
                }
                if (bl) {
                    String string6 = (String)colon2.head();
                    List list5 = colon2.tl$access$1();
                    boolean bl5 = "--cores".equals(string6) ? true : "-c".equals(string6);
                    if (bl5 && list5 instanceof .colon.colon) {
                        .colon.colon colon6 = (.colon.colon)list5;
                        String string7 = (String)colon6.head();
                        List tail = colon6.tl$access$1();
                        Option<Object> option = IntParam$.MODULE$.unapply(string7);
                        if (!option.isEmpty()) {
                            int value = BoxesRunTime.unboxToInt((Object)option.get());
                            this.cores_$eq(value);
                            args = tail;
                            continue;
                        }
                    }
                }
                if (bl) {
                    String string8 = (String)colon2.head();
                    List list6 = colon2.tl$access$1();
                    boolean bl6 = "--memory".equals(string8) ? true : "-m".equals(string8);
                    if (bl6 && list6 instanceof .colon.colon) {
                        .colon.colon colon7 = (.colon.colon)list6;
                        String string9 = (String)colon7.head();
                        List tail = colon7.tl$access$1();
                        Option<Object> option = MemoryParam$.MODULE$.unapply(string9);
                        if (!option.isEmpty()) {
                            int value = BoxesRunTime.unboxToInt((Object)option.get());
                            this.memory_$eq(value);
                            args = tail;
                            continue;
                        }
                    }
                }
                if (bl) {
                    String string10 = (String)colon2.head();
                    List list7 = colon2.tl$access$1();
                    boolean bl7 = "--work-dir".equals(string10) ? true : "-d".equals(string10);
                    if (bl7 && list7 instanceof .colon.colon) {
                        .colon.colon colon8 = (.colon.colon)list7;
                        String value = (String)colon8.head();
                        List tail = colon8.tl$access$1();
                        this.workDir_$eq(value);
                        args = tail;
                        continue;
                    }
                }
                if (bl) {
                    String string11 = (String)colon2.head();
                    List list8 = colon2.tl$access$1();
                    if ("--webui-port".equals(string11) && list8 instanceof .colon.colon) {
                        .colon.colon colon9 = (.colon.colon)list8;
                        String string12 = (String)colon9.head();
                        List tail = colon9.tl$access$1();
                        Option<Object> option = IntParam$.MODULE$.unapply(string12);
                        if (!option.isEmpty()) {
                            int value = BoxesRunTime.unboxToInt((Object)option.get());
                            this.webUiPort_$eq(value);
                            args = tail;
                            continue;
                        }
                    }
                }
                if (bl) {
                    String string13 = (String)colon2.head();
                    List list9 = colon2.tl$access$1();
                    if ("--properties-file".equals(string13) && list9 instanceof .colon.colon) {
                        .colon.colon colon10 = (.colon.colon)list9;
                        String value = (String)colon10.head();
                        List tail = colon10.tl$access$1();
                        this.propertiesFile_$eq(value);
                        args = tail;
                        continue;
                    }
                }
                if (bl && "--help".equals(string = (String)colon2.head())) {
                    this.printUsageAndExit(0);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block27;
                }
                if (!bl) break;
                String value = (String)colon2.head();
                List tail = colon2.tl$access$1();
                if (this.masters() != null) {
                    this.printUsageAndExit(1);
                }
                this.masters_$eq(Utils$.MODULE$.parseStandaloneMasterUrls(value));
                args = tail;
            }
            if (Nil$.MODULE$.equals(list)) {
                BoxedUnit boxedUnit;
                if (this.masters() == null) {
                    this.printUsageAndExit(1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                this.printUsageAndExit(1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void printUsageAndExit(int exitCode) {
        System.err.println("Usage: Worker [options] <master>\n\nMaster must be a URL of the form spark://hostname:port\n\nOptions:\n  -c CORES, --cores CORES  Number of cores to use\n  -m MEM, --memory MEM     Amount of memory to use (e.g. 1000M, 2G)\n  -d DIR, --work-dir DIR   Directory to run apps in (default: SPARK_HOME/work)\n  -i HOST, --ip IP         Hostname to listen on (deprecated, please use --host or -h)\n  -h HOST, --host HOST     Hostname to listen on\n  -p PORT, --port PORT     Port to listen on (default: random)\n  --webui-port PORT        Port for web UI (default: 8081)\n  --properties-file FILE   Path to a custom Spark properties file.\n                           Default is conf/spark-defaults.conf.");
        System.exit(exitCode);
    }

    public int inferDefaultCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public int inferDefaultMemory() {
        int totalMb;
        block3: {
            boolean ibmVendor = System.getProperty("java.vendor").contains("IBM");
            totalMb = 0;
            try {
                OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
                if (ibmVendor) {
                    Class<?> beanClass = Class.forName("com.ibm.lang.management.OperatingSystemMXBean");
                    Method method = beanClass.getDeclaredMethod("getTotalPhysicalMemory", new Class[0]);
                    totalMb = (int)(BoxesRunTime.unboxToLong((Object)method.invoke((Object)bean, new Object[0])) / 1024L / 1024L);
                    break block3;
                }
                Class<?> beanClass = Class.forName("com.sun.management.OperatingSystemMXBean");
                Method method = beanClass.getDeclaredMethod("getTotalPhysicalMemorySize", new Class[0]);
                totalMb = (int)(BoxesRunTime.unboxToLong((Object)method.invoke((Object)bean, new Object[0])) / 1024L / 1024L);
            }
            catch (Exception e) {
                totalMb = 2048;
                System.out.println(new StringBuilder(46).append("Failed to get total physical memory. Using ").append(totalMb).append(" MB").toString());
            }
        }
        return package$.MODULE$.max(totalMb - 1024, Utils$.MODULE$.DEFAULT_DRIVER_MEM_MB());
    }

    public void checkWorkerMemory() {
        if (this.memory() <= 0) {
            String message = "Memory is below 1MB, or missing a M/G at the end of the memory specification?";
            throw new IllegalStateException(message);
        }
    }

    public WorkerArguments(String[] args, SparkConf conf) {
        if (System.getenv("SPARK_WORKER_PORT") != null) {
            this.port_$eq(new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_WORKER_PORT"))).toInt());
        }
        if (System.getenv("SPARK_WORKER_CORES") != null) {
            this.cores_$eq(new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_WORKER_CORES"))).toInt());
        }
        if (conf.getenv("SPARK_WORKER_MEMORY") != null) {
            this.memory_$eq(Utils$.MODULE$.memoryStringToMb(conf.getenv("SPARK_WORKER_MEMORY")));
        }
        if (System.getenv("SPARK_WORKER_WEBUI_PORT") != null) {
            this.webUiPort_$eq(new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_WORKER_WEBUI_PORT"))).toInt());
        }
        if (System.getenv("SPARK_WORKER_DIR") != null) {
            this.workDir_$eq(System.getenv("SPARK_WORKER_DIR"));
        }
        this.parse((List<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).toList());
        this.propertiesFile_$eq(Utils$.MODULE$.loadDefaultSparkProperties(conf, this.propertiesFile()));
        if (conf.contains("spark.worker.ui.port")) {
            this.webUiPort_$eq(new StringOps(Predef$.MODULE$.augmentString(conf.get("spark.worker.ui.port"))).toInt());
        }
        this.checkWorkerMemory();
    }
}

