/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.security;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.security.HadoopDelegationTokenProvider;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001q4Q!\u0001\u0002\u0001\r1\u00111\u0004S5wK\u0012+G.Z4bi&|g\u000eV8lK:\u0004&o\u001c<jI\u0016\u0014(BA\u0002\u0005\u0003!\u0019XmY;sSRL(BA\u0003\u0007\u0003\u0019!W\r\u001d7ps*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0005\u0003\u0001\u001bM9\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015+5\t!!\u0003\u0002\u0017\u0005\ti\u0002*\u00193p_B$U\r\\3hCRLwN\u001c+pW\u0016t\u0007K]8wS\u0012,'\u000f\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001d3\t9Aj\\4hS:<\u0007\"\u0002\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\u0005\u0002\"\u0001\u0006\u0001\t\u000b\r\u0002A\u0011\t\u0013\u0002\u0017M,'O^5dK:\u000bW.Z\u000b\u0002KA\u0011a%\f\b\u0003O-\u0002\"\u0001K\b\u000e\u0003%R!AK\u0010\u0002\rq\u0012xn\u001c;?\u0013\tas\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003]=\u0012aa\u0015;sS:<'B\u0001\u0017\u0010\u0011\u001d\t\u0004A1A\u0005\nI\nQc\u00197bgNtu\u000e\u001e$pk:$WI\u001d:peN#(/F\u00014!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0003mC:<'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003]UBaa\u000f\u0001!\u0002\u0013\u0019\u0014AF2mCN\u001chj\u001c;G_VtG-\u0012:s_J\u001cFO\u001d\u0011\t\u000bu\u0002A\u0011\u0002 \u0002\u0011!Lg/Z\"p]\u001a$\"aP$\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001B2p]\u001aT!\u0001\u0012\u0005\u0002\r!\fGm\\8q\u0013\t1\u0015IA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006\u0011r\u0002\raP\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\"\u0002&\u0001\t\u0003Z\u0015\u0001\u00073fY\u0016<\u0017\r^5p]R{7.\u001a8t%\u0016\fX/\u001b:fIR\u0019AjT+\u0011\u00059i\u0015B\u0001(\u0010\u0005\u001d\u0011un\u001c7fC:DQ\u0001U%A\u0002E\u000b\u0011b\u001d9be.\u001cuN\u001c4\u0011\u0005I\u001bV\"\u0001\u0004\n\u0005Q3!!C*qCJ\\7i\u001c8g\u0011\u0015A\u0015\n1\u0001@\u0011\u00159\u0006\u0001\"\u0011Y\u0003Yy'\r^1j]\u0012+G.Z4bi&|g\u000eV8lK:\u001cH\u0003B-`A\u0006\u00042A\u0004.]\u0013\tYvB\u0001\u0004PaRLwN\u001c\t\u0003\u001duK!AX\b\u0003\t1{gn\u001a\u0005\u0006\u0011Z\u0003\ra\u0010\u0005\u0006!Z\u0003\r!\u0015\u0005\u0006EZ\u0003\raY\u0001\u0006GJ,Gm\u001d\t\u0003I\u001al\u0011!\u001a\u0006\u0003\u0007\rK!aZ3\u0003\u0017\r\u0013X\rZ3oi&\fGn\u001d\u0005\u0006S\u0002!IA[\u0001\rI>\f5OU3bYV\u001bXM]\u000b\u0003W:$\"\u0001\\<\u0011\u00055tG\u0002\u0001\u0003\u0006_\"\u0014\r\u0001\u001d\u0002\u0002)F\u0011\u0011\u000f\u001e\t\u0003\u001dIL!a]\b\u0003\u000f9{G\u000f[5oOB\u0011a\"^\u0005\u0003m>\u00111!\u00118z\u0011\u0019A\b\u000e\"a\u0001s\u0006\u0011aM\u001c\t\u0004\u001did\u0017BA>\u0010\u0005!a$-\u001f8b[\u0016t\u0004")
public class HiveDelegationTokenProvider
implements HadoopDelegationTokenProvider,
Logging {
    private final String classNotFoundErrorStr;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String serviceName() {
        return "hive";
    }

    private String classNotFoundErrorStr() {
        return this.classNotFoundErrorStr;
    }

    private Configuration hiveConf(Configuration hadoopConf) {
        HiveConf hiveConf;
        try {
            hiveConf = new HiveConf(hadoopConf, HiveConf.class);
        }
        catch (Throwable throwable) {
            Configuration configuration;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fail to create Hive Configuration", e);
                configuration = hadoopConf;
            } else if (throwable2 instanceof NoClassDefFoundError) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> this.classNotFoundErrorStr());
                configuration = hadoopConf;
            } else {
                throw throwable;
            }
            hiveConf = configuration;
        }
        return hiveConf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean delegationTokensRequired(SparkConf sparkConf, Configuration hadoopConf) {
        String deployMode = sparkConf.get("spark.submit.deployMode", "client");
        if (!UserGroupInformation.isSecurityEnabled()) return false;
        if (!new StringOps(Predef$.MODULE$.augmentString(this.hiveConf(hadoopConf).getTrimmed("hive.metastore.uris", ""))).nonEmpty()) return false;
        if (SparkHadoopUtil$.MODULE$.get().isProxyUser(UserGroupInformation.getCurrentUser())) return true;
        String string = deployMode;
        String string2 = "cluster";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (sparkConf.contains(package$.MODULE$.KEYTAB())) return false;
        return true;
    }

    @Override
    public Option<Object> obtainDelegationTokens(Configuration hadoopConf, SparkConf sparkConf, Credentials creds) {
        None$ none$;
        try {
            try {
                Configuration conf = this.hiveConf(hadoopConf);
                String principalKey = "hive.metastore.kerberos.principal";
                String principal = conf.getTrimmed(principalKey, "");
                Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(principal)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Hive principal ").append(principalKey).append(" undefined").toString());
                String metastoreUri = conf.getTrimmed("hive.metastore.uris", "");
                Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(metastoreUri)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Hive metastore uri undefined");
                UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Getting Hive delegation token for ").append(currentUser.getUserName()).append(" against ").append(new StringBuilder(4).append(principal).append(" at ").append(metastoreUri).toString()).toString());
                this.doAsRealUser((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Hive hive = Hive.get((Configuration)conf, HiveConf.class);
                    String tokenStr = hive.getDelegationToken(currentUser.getUserName(), principal);
                    Token hive2Token = new Token();
                    hive2Token.decodeFromUrlString(tokenStr);
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Get Token from hive metastore: ").append(hive2Token.toString()).toString());
                    creds.addToken(new Text("hive.server2.delegation.token"), hive2Token);
                });
                none$ = None$.MODULE$;
            }
            catch (Throwable throwable) {
                None$ none$2;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Failed to get token from service ").append(this.serviceName()).toString(), e);
                    none$2 = None$.MODULE$;
                } else if (throwable2 instanceof NoClassDefFoundError) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> this.classNotFoundErrorStr());
                    none$2 = None$.MODULE$;
                } else {
                    throw throwable;
                }
                none$ = none$2;
            }
        }
        finally {
            Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Hive.closeCurrent());
        }
        return none$;
    }

    private <T> T doAsRealUser(Function0<T> fn) {
        Object object;
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        UserGroupInformation realUser = (UserGroupInformation)Option$.MODULE$.apply((Object)currentUser.getRealUser()).getOrElse((Function0 & Serializable & scala.Serializable)() -> currentUser);
        try {
            object = realUser.doAs(new PrivilegedExceptionAction<T>(null, fn){
                private final Function0 fn$1;

                public T run() {
                    return (T)this.fn$1.apply();
                }
                {
                    this.fn$1 = fn$1;
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            throw (Throwable)Option$.MODULE$.apply((Object)e.getCause()).getOrElse((Function0 & Serializable & scala.Serializable)() -> e);
        }
        return (T)object;
    }

    public HiveDelegationTokenProvider() {
        Logging.$init$(this);
        this.classNotFoundErrorStr = new StringBuilder(30).append("You are attempting to use the ").append(new StringBuilder(63).append(this.getClass().getCanonicalName()).append(", but your Spark distribution is not built with Hive libraries.").toString()).toString();
    }
}

