/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.rds.model.RebootDBInstanceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebootDBInstanceRequestMarshaller
implements Marshaller<Request<RebootDBInstanceRequest>, RebootDBInstanceRequest> {
    @Override
    public Request<RebootDBInstanceRequest> marshall(RebootDBInstanceRequest rebootDBInstanceRequest) {
        if (rebootDBInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RebootDBInstanceRequest> request = new DefaultRequest<RebootDBInstanceRequest>(rebootDBInstanceRequest, "AmazonRDS");
        request.addParameter("Action", "RebootDBInstance");
        request.addParameter("Version", "2013-01-10");
        if (rebootDBInstanceRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString(rebootDBInstanceRequest.getDBInstanceIdentifier()));
        }
        if (rebootDBInstanceRequest.isForceFailover() != null) {
            request.addParameter("ForceFailover", StringUtils.fromBoolean(rebootDBInstanceRequest.isForceFailover()));
        }
        return request;
    }
}

