/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rdd;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.internal.Logging;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.partial.MeanEvaluator;
import org.apache.spark.partial.PartialResult;
import org.apache.spark.partial.SumEvaluator;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.StatCounter;
import org.apache.spark.util.StatCounter$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0001\u0003\u0001-\u0011!\u0003R8vE2,'\u000b\u0012#Gk:\u001cG/[8og*\u00111\u0001B\u0001\u0004e\u0012$'BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0004\n\u0019!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\tS:$XM\u001d8bY&\u0011q\u0003\u0006\u0002\b\u0019><w-\u001b8h!\ti\u0011$\u0003\u0002\u001b\u001d\ta1+\u001a:jC2L'0\u00192mK\"AA\u0004\u0001B\u0001B\u0003%Q$\u0001\u0003tK24\u0007c\u0001\u0010 C5\t!!\u0003\u0002!\u0005\t\u0019!\u000b\u0012#\u0011\u00055\u0011\u0013BA\u0012\u000f\u0005\u0019!u.\u001e2mK\")Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"\"a\n\u0015\u0011\u0005y\u0001\u0001\"\u0002\u000f%\u0001\u0004i\u0002\"\u0002\u0016\u0001\t\u0003Y\u0013aA:v[R\t\u0011\u0005C\u0003.\u0001\u0011\u0005a&A\u0003ti\u0006$8\u000fF\u00010!\t\u00014'D\u00012\u0015\t\u0011D!\u0001\u0003vi&d\u0017B\u0001\u001b2\u0005-\u0019F/\u0019;D_VtG/\u001a:\t\u000bY\u0002A\u0011A\u0016\u0002\t5,\u0017M\u001c\u0005\u0006q\u0001!\taK\u0001\tm\u0006\u0014\u0018.\u00198dK\")!\b\u0001C\u0001W\u0005)1\u000f\u001e3fm\")A\b\u0001C\u0001W\u0005Y1/Y7qY\u0016\u001cF\u000fZ3w\u0011\u0015q\u0004\u0001\"\u0001,\u00039\u0019\u0018-\u001c9mKZ\u000b'/[1oG\u0016DQ\u0001\u0011\u0001\u0005\u0002-\n\u0001\u0002]8q'R$WM\u001e\u0015\u0004\u007f\tC\u0005CA\"G\u001b\u0005!%BA#\u0005\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u000f\u0012\u0013QaU5oG\u0016\f\u0013!S\u0001\u0006e9\nd\u0006\r\u0005\u0006\u0017\u0002!\taK\u0001\fa>\u0004h+\u0019:jC:\u001cW\rK\u0002K\u0005\"CQA\u0014\u0001\u0005\u0002=\u000b!\"\\3b]\u0006\u0003\bO]8y)\r\u0001\u0016L\u0018\t\u0004#R3V\"\u0001*\u000b\u0005M#\u0011a\u00029beRL\u0017\r\\\u0005\u0003+J\u0013Q\u0002U1si&\fGNU3tk2$\bCA)X\u0013\tA&KA\u0007C_VtG-\u001a3E_V\u0014G.\u001a\u0005\u000656\u0003\raW\u0001\bi&lWm\\;u!\tiA,\u0003\u0002^\u001d\t!Aj\u001c8h\u0011\u001dyV\n%AA\u0002\u0005\n!bY8oM&$WM\\2f\u0011\u0015\t\u0007\u0001\"\u0001c\u0003%\u0019X/\\!qaJ|\u0007\u0010F\u0002QG\u0012DQA\u00171A\u0002mCqa\u00181\u0011\u0002\u0003\u0007\u0011\u0005C\u0003g\u0001\u0011\u0005q-A\u0005iSN$xn\u001a:b[R\u0011\u0001n\u001c\t\u0005\u001b%\\g.\u0003\u0002k\u001d\t1A+\u001e9mKJ\u00022!\u00047\"\u0013\tigBA\u0003BeJ\f\u0017\u0010E\u0002\u000eYnCQ\u0001]3A\u0002E\f1BY;dW\u0016$8i\\;oiB\u0011QB]\u0005\u0003g:\u00111!\u00138u\u0011\u00151\u0007\u0001\"\u0001v)\rqg\u000f\u001f\u0005\u0006oR\u0004\ra[\u0001\bEV\u001c7.\u001a;t\u0011\u001dIH\u000f%AA\u0002i\f1\"\u001a<f]\n+8m[3ugB\u0011Qb_\u0005\u0003y:\u0011qAQ8pY\u0016\fg\u000eC\u0004\u007f\u0001E\u0005I\u0011A@\u0002)5,\u0017M\\!qaJ|\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tAK\u0002\"\u0003\u0007Y#!!\u0002\u0011\t\u0005\u001d\u0011qB\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u000b:IA!!\u0005\u0002\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0011\u0005U\u0001!%A\u0005\u0002}\f1c];n\u0003B\u0004(o\u001c=%I\u00164\u0017-\u001e7uIIB\u0011\"!\u0007\u0001#\u0003%\t!a\u0007\u0002'!L7\u000f^8he\u0006lG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u!f\u0001>\u0002\u0004\u0001")
public class DoubleRDDFunctions
implements Logging,
scala.Serializable {
    private final RDD<Object> self;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public double sum() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToDouble((Object)$this.self.fold(BoxesRunTime.boxToDouble((double)0.0), (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$1, x$2) -> x$1 + x$2))));
    }

    public StatCounter stats() {
        return (StatCounter)this.self.withScope((Function0 & Serializable & scala.Serializable)() -> (StatCounter)$this.self.mapPartitions((Function1 & Serializable & scala.Serializable)nums -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StatCounter[]{StatCounter$.MODULE$.apply((TraversableOnce<Object>)nums)})), $this.self.mapPartitions$default$2(), ClassTag$.MODULE$.apply(StatCounter.class)).reduce((Function2 & Serializable & scala.Serializable)(a, b) -> a.merge((StatCounter)b)));
    }

    public double mean() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.stats().mean()));
    }

    public double variance() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.stats().variance()));
    }

    public double stdev() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.stats().stdev()));
    }

    public double sampleStdev() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.stats().sampleStdev()));
    }

    public double sampleVariance() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.stats().sampleVariance()));
    }

    public double popStdev() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.stats().popStdev()));
    }

    public double popVariance() {
        return BoxesRunTime.unboxToDouble(this.self.withScope((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.stats().popVariance()));
    }

    public PartialResult<BoundedDouble> meanApprox(long timeout, double confidence) {
        return (PartialResult)this.self.withScope((Function0 & Serializable & scala.Serializable)() -> {
            Function2 & Serializable & scala.Serializable processPartition = (Function2 & Serializable & scala.Serializable)(ctx, ns) -> StatCounter$.MODULE$.apply((TraversableOnce<Object>)ns);
            MeanEvaluator evaluator = new MeanEvaluator($this.self.partitions().length, confidence);
            return $this.self.context().runApproximateJob($this.self, processPartition, evaluator, timeout);
        });
    }

    public double meanApprox$default$2() {
        return 0.95;
    }

    public PartialResult<BoundedDouble> sumApprox(long timeout, double confidence) {
        return (PartialResult)this.self.withScope((Function0 & Serializable & scala.Serializable)() -> {
            Function2 & Serializable & scala.Serializable processPartition = (Function2 & Serializable & scala.Serializable)(ctx, ns) -> StatCounter$.MODULE$.apply((TraversableOnce<Object>)ns);
            SumEvaluator evaluator = new SumEvaluator($this.self.partitions().length, confidence);
            return $this.self.context().runApproximateJob($this.self, processPartition, evaluator, timeout);
        });
    }

    public double sumApprox$default$2() {
        return 0.95;
    }

    public Tuple2<double[], long[]> histogram(int bucketCount) {
        return (Tuple2)this.self.withScope((Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = (Tuple2)$this.self.mapPartitions((Function1 & Serializable & scala.Serializable)items -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{(Tuple2)items.foldRight((Object)new Tuple2.mcDD.sp(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), (Function2 & Serializable & scala.Serializable)(e, x) -> DoubleRDDFunctions.$anonfun$histogram$4(BoxesRunTime.unboxToDouble((Object)e), x))})), $this.self.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)).reduce((Function2 & Serializable & scala.Serializable)(maxmin1, maxmin2) -> new Tuple2.mcDD.sp(RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(maxmin1._1$mcD$sp()), maxmin2._1$mcD$sp()), RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(maxmin1._2$mcD$sp()), maxmin2._2$mcD$sp())));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double max = tuple2._1$mcD$sp();
            double min = tuple2._2$mcD$sp();
            double d = max;
            double d2 = min;
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
            Tuple2.mcDD.sp sp3 = sp2;
            double max2 = sp3._1$mcD$sp();
            double min2 = sp3._2$mcD$sp();
            if (Predef$.MODULE$.double2Double(min2).isNaN() || Predef$.MODULE$.double2Double(max2).isNaN() || RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(max2)) || RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(min2))) {
                throw new UnsupportedOperationException("Histogram on either an empty RDD or RDD containing +/-infinity or NaN");
            }
            IndexedSeq range = min2 != max2 ? DoubleRDDFunctions.customRange$1(min2, max2, bucketCount) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{min2, min2}));
            double[] buckets = (double[])range.toArray(ClassTag$.MODULE$.Double());
            return new Tuple2((Object)buckets, (Object)this.histogram(buckets, true));
        });
    }

    public long[] histogram(double[] buckets, boolean evenBuckets) {
        return (long[])this.self.withScope((Function0 & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable intersect;
            if (buckets.length < 2) {
                throw new IllegalArgumentException("buckets array must have at least two elements");
            }
            if (evenBuckets) {
                double d = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(buckets)).head());
                double d2 = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(buckets)).last());
                int n = buckets.length - 1;
                intersect = (Function1 & Serializable & scala.Serializable)e -> DoubleRDDFunctions.fastBucketFunction$1(d, d2, n, BoxesRunTime.unboxToDouble((Object)e));
            } else {
                intersect = (Function1 & Serializable & scala.Serializable)e -> DoubleRDDFunctions.basicBucketFunction$1(BoxesRunTime.unboxToDouble((Object)e), buckets);
            }
            Function1 & Serializable & scala.Serializable bucketFunction = intersect;
            return $this.self.partitions().length == 0 ? new long[buckets.length - 1] : (long[])$this.self.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> DoubleRDDFunctions.histogramPartition$1(bucketFunction, iter, buckets), $this.self.mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE))).reduce((Function2 & Serializable & scala.Serializable)(a1, a2) -> DoubleRDDFunctions.mergeCounters$1(a1, a2));
        });
    }

    public boolean histogram$default$2() {
        return false;
    }

    private static final IndexedSeq customRange$1(double min, double max, int steps) {
        double span = max - min;
        return (IndexedSeq)((SeqLike)Range.Int$.MODULE$.apply(0, steps, 1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)s -> min + (double)s * span / (double)steps, IndexedSeq$.MODULE$.canBuildFrom())).$colon$plus((Object)BoxesRunTime.boxToDouble((double)max), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Tuple2 $anonfun$histogram$4(double e, Tuple2 x) {
        return new Tuple2.mcDD.sp(RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(x._1$mcD$sp()), e), RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(x._2$mcD$sp()), e));
    }

    private static final Iterator histogramPartition$1(Function1 bucketFunction, Iterator iter, double[] buckets$1) {
        long[] counters = new long[buckets$1.length - 1];
        while (iter.hasNext()) {
            BoxedUnit boxedUnit;
            Option option = (Option)bucketFunction.apply(iter.next());
            if (option instanceof Some) {
                int x;
                Some some = (Some)option;
                int n = x = BoxesRunTime.unboxToInt((Object)some.value());
                counters[n] = counters[n] + 1L;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new long[][]{counters}));
    }

    private static final long[] mergeCounters$1(long[] a1, long[] a2) {
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(a1)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            a1$1[i] = a1[i] + a2[i];
        });
        return a1;
    }

    private static final Option basicBucketFunction$1(double e, double[] buckets$1) {
        int insertionPoint;
        int location = Arrays.binarySearch(buckets$1, e);
        return location < 0 ? ((insertionPoint = -location - 1) > 0 && insertionPoint < buckets$1.length ? new Some((Object)BoxesRunTime.boxToInteger((int)(insertionPoint - 1))) : None$.MODULE$) : (location < buckets$1.length - 1 ? new Some((Object)BoxesRunTime.boxToInteger((int)location)) : new Some((Object)BoxesRunTime.boxToInteger((int)(location - 1))));
    }

    private static final Option fastBucketFunction$1(double min, double max, int count, double e) {
        None$ none$;
        if (Predef$.MODULE$.double2Double(e).isNaN() || e < min || e > max) {
            none$ = None$.MODULE$;
        } else {
            int bucketNumber = (int)((e - min) / (max - min) * (double)count);
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.min(bucketNumber, count - 1)));
        }
        return none$;
    }

    public DoubleRDDFunctions(RDD<Object> self) {
        this.self = self;
        Logging.$init$(this);
    }
}

