/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.config;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.ConfigEntry$;
import org.apache.spark.internal.config.ConfigEntryWithDefault;
import org.apache.spark.internal.config.ConfigEntryWithDefaultFunction;
import org.apache.spark.internal.config.ConfigEntryWithDefaultString;
import org.apache.spark.internal.config.ConfigProvider;
import org.apache.spark.internal.config.ConfigReader$;
import org.apache.spark.internal.config.EnvProvider;
import org.apache.spark.internal.config.FallbackConfigEntry;
import org.apache.spark.internal.config.MapProvider;
import org.apache.spark.internal.config.SystemProvider;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dq!B\u0001\u0003\u0011\u0013i\u0011\u0001D\"p]\u001aLwMU3bI\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0019wN\u001c4jO*\u0011QAB\u0001\tS:$XM\u001d8bY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0011\u00059yQ\"\u0001\u0002\u0007\u000bA\u0011\u0001\u0012B\t\u0003\u0019\r{gNZ5h%\u0016\fG-\u001a:\u0014\u0005=\u0011\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\rC\u0003\u001a\u001f\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001b!9Ad\u0004b\u0001\n\u0013i\u0012A\u0002*F\r~\u0013V)F\u0001\u001f!\tyB%D\u0001!\u0015\t\t#%\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\t\u0019C#\u0001\u0003vi&d\u0017BA\u0013!\u0005\u0015\u0011VmZ3y\u0011\u00199s\u0002)A\u0005=\u00059!+\u0012$`%\u0016\u0003c!\u0002\t\u0003\u0001\u0019I3C\u0001\u0015\u0013\u0011!Y\u0003F!A!\u0002\u0013a\u0013\u0001B2p]\u001a\u0004\"AD\u0017\n\u00059\u0012!AD\"p]\u001aLw\r\u0015:pm&$WM\u001d\u0005\u00063!\"\t\u0001\r\u000b\u0003cI\u0002\"A\u0004\u0015\t\u000b-z\u0003\u0019\u0001\u0017\t\u000beAC\u0011\u0001\u001b\u0015\u0005E*\u0004\"B\u00164\u0001\u00041\u0004\u0003B\u001c<{uj\u0011\u0001\u000f\u0006\u0003GeR\u0011AO\u0001\u0005U\u00064\u0018-\u0003\u0002=q\t\u0019Q*\u00199\u0011\u0005y*eBA D!\t\u0001E#D\u0001B\u0015\t\u0011E\"\u0001\u0004=e>|GOP\u0005\u0003\tR\ta\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\u0019\u0019FO]5oO*\u0011A\t\u0006\u0005\b\u0013\"\u0012\r\u0011\"\u0003K\u0003!\u0011\u0017N\u001c3j]\u001e\u001cX#A&\u0011\t1\u000bV\bL\u0007\u0002\u001b*\u0011ajT\u0001\b[V$\u0018M\u00197f\u0015\t\u0001F#\u0001\u0006d_2dWm\u0019;j_:L!AU'\u0003\u000f!\u000b7\u000f['ba\"1A\u000b\u000bQ\u0001\n-\u000b\u0011BY5oI&twm\u001d\u0011\t\u000bYCC\u0011A,\u0002\t\tLg\u000e\u001a\u000b\u0004caS\u0006\"B-V\u0001\u0004i\u0014A\u00029sK\u001aL\u0007\u0010C\u0003\\+\u0002\u0007A&\u0001\u0005qe>4\u0018\u000eZ3s\u0011\u00151\u0006\u0006\"\u0001^)\r\tdl\u0018\u0005\u00063r\u0003\r!\u0010\u0005\u0006Ar\u0003\rAN\u0001\u0007m\u0006dW/Z:\t\u000b\tDC\u0011A2\u0002\u000f\tLg\u000eZ#omR\u0011\u0011\u0007\u001a\u0005\u00067\u0006\u0004\r\u0001\f\u0005\u0006M\"\"\taZ\u0001\u000bE&tGmU=ti\u0016lGCA\u0019i\u0011\u0015YV\r1\u0001-\u0011\u0015Q\u0007\u0006\"\u0001l\u0003\r9W\r\u001e\u000b\u0003Y>\u00042aE7>\u0013\tqGC\u0001\u0004PaRLwN\u001c\u0005\u0006a&\u0004\r!P\u0001\u0004W\u0016L\b\"\u0002:)\t\u0003\u0019\u0018AC:vEN$\u0018\u000e^;uKR\u0011Q\b\u001e\u0005\u0006kF\u0004\r!P\u0001\u0006S:\u0004X\u000f\u001e\u0005\u0006e\"\"Ia\u001e\u000b\u0004{aL\b\"B;w\u0001\u0004i\u0004\"\u0002>w\u0001\u0004Y\u0018\u0001C;tK\u0012\u0014VMZ:\u0011\u0007ybX(\u0003\u0002~\u000f\n\u00191+\u001a;\t\r}DC\u0011BA\u0001\u000319W\r^(s\t\u00164\u0017-\u001e7u)\u0015a\u00171AA\u0003\u0011\u0015Yc\u00101\u0001-\u0011\u0015\u0001h\u00101\u0001>\u0001")
public class ConfigReader {
    private final ConfigProvider conf;
    private final HashMap<String, ConfigProvider> bindings;

    private HashMap<String, ConfigProvider> bindings() {
        return this.bindings;
    }

    public ConfigReader bind(String prefix, ConfigProvider provider) {
        this.bindings().update((Object)prefix, (Object)provider);
        return this;
    }

    public ConfigReader bind(String prefix, Map<String, String> values) {
        return this.bind(prefix, new MapProvider(values));
    }

    public ConfigReader bindEnv(ConfigProvider provider) {
        return this.bind("env", provider);
    }

    public ConfigReader bindSystem(ConfigProvider provider) {
        return this.bind("system", provider);
    }

    public Option<String> get(String key) {
        return this.conf.get(key).map((Function1 & Serializable & scala.Serializable)input -> this.substitute((String)input));
    }

    public String substitute(String input) {
        return this.substitute(input, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    private String substitute(String input, Set<String> usedRefs) {
        return input != null ? ConfigReader$.MODULE$.org$apache$spark$internal$config$ConfigReader$$REF_RE().replaceAllIn((CharSequence)input, (Function1 & Serializable & scala.Serializable)m -> {
            String prefix = m.group(1);
            String name = m.group(2);
            String ref = prefix == null ? name : new StringBuilder(1).append(prefix).append(":").append(name).toString();
            Predef$.MODULE$.require(!usedRefs.contains((Object)ref), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Circular reference in ").append(input).append(": ").append(ref).toString());
            String replacement = (String)this.bindings().get((Object)prefix).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> this.getOrDefault((ConfigProvider)x$1, name)).map((Function1 & Serializable & scala.Serializable)v -> this.substitute((String)v, (Set<String>)((Set)usedRefs.$plus((Object)ref)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> m.matched());
            return Regex$.MODULE$.quoteReplacement(replacement);
        }) : input;
    }

    private Option<String> getOrDefault(ConfigProvider conf, String key) {
        return conf.get(key).orElse((Function0 & Serializable & scala.Serializable)() -> {
            Option<String> option;
            ConfigEntry<?> configEntry = ConfigEntry$.MODULE$.findEntry(key);
            if (configEntry instanceof ConfigEntryWithDefault) {
                ConfigEntryWithDefault configEntryWithDefault = (ConfigEntryWithDefault)configEntry;
                option = Option$.MODULE$.apply((Object)configEntryWithDefault.defaultValueString());
            } else if (configEntry instanceof ConfigEntryWithDefaultString) {
                ConfigEntryWithDefaultString configEntryWithDefaultString = (ConfigEntryWithDefaultString)configEntry;
                option = Option$.MODULE$.apply((Object)configEntryWithDefaultString.defaultValueString());
            } else if (configEntry instanceof ConfigEntryWithDefaultFunction) {
                ConfigEntryWithDefaultFunction configEntryWithDefaultFunction = (ConfigEntryWithDefaultFunction)configEntry;
                option = Option$.MODULE$.apply((Object)configEntryWithDefaultFunction.defaultValueString());
            } else if (configEntry instanceof FallbackConfigEntry) {
                FallbackConfigEntry fallbackConfigEntry = (FallbackConfigEntry)configEntry;
                option = this.getOrDefault(conf, fallbackConfigEntry.fallback().key());
            } else {
                option = None$.MODULE$;
            }
            return option;
        });
    }

    public ConfigReader(ConfigProvider conf) {
        this.conf = conf;
        this.bindings = new HashMap();
        this.bind(null, conf);
        this.bindEnv(new EnvProvider());
        this.bindSystem(new SystemProvider());
    }

    public ConfigReader(Map<String, String> conf) {
        this(new MapProvider(conf));
    }
}

