/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.security;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.security.HBaseDelegationTokenProvider;
import org.apache.spark.deploy.security.HadoopDelegationTokenProvider;
import org.apache.spark.deploy.security.HadoopFSDelegationTokenProvider;
import org.apache.spark.deploy.security.HiveDelegationTokenProvider;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005]b!B\u0001\u0003\u0001\u0019a!\u0001\b%bI>|\u0007\u000fR3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\t\u0001b]3dkJLG/\u001f\u0006\u0003\u000b\u0019\ta\u0001Z3qY>L(BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00031U\u0011q\u0001T8hO&tw\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001d\u0003%\u0019\b/\u0019:l\u0007>tgm\u0001\u0001\u0011\u0005uqR\"\u0001\u0004\n\u0005}1!!C*qCJ\\7i\u001c8g\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013A\u00035bI>|\u0007oQ8oMB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005G>tgM\u0003\u0002(\u0011\u00051\u0001.\u00193p_BL!!\u000b\u0013\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011!Y\u0003A!A!\u0002\u0013a\u0013a\u00034jY\u0016\u001c\u0016p\u001d;f[N\u0004BAD\u0017#_%\u0011af\u0004\u0002\n\rVt7\r^5p]F\u00022\u0001M\u001c;\u001d\t\tT\u0007\u0005\u00023\u001f5\t1G\u0003\u000257\u00051AH]8pizJ!AN\b\u0002\rA\u0013X\rZ3g\u0013\tA\u0014HA\u0002TKRT!AN\b\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0013A\u00014t\u0013\tyDH\u0001\u0006GS2,7+_:uK6DQ!\u0011\u0001\u0005\u0002\t\u000ba\u0001P5oSRtD\u0003B\"F\r\u001e\u0003\"\u0001\u0012\u0001\u000e\u0003\tAQA\u0007!A\u0002qAQ!\t!A\u0002\tBQa\u000b!A\u00021Bq!\u0013\u0001C\u0002\u0013%!*\u0001\u0011eKB\u0014XmY1uK\u0012\u0004&o\u001c<jI\u0016\u0014XI\\1cY\u0016$7i\u001c8gS\u001e\u001cX#A&\u0011\u00071\u000b6+D\u0001N\u0015\tqu*A\u0005j[6,H/\u00192mK*\u0011\u0001kD\u0001\u000bG>dG.Z2uS>t\u0017B\u0001*N\u0005\u0011a\u0015n\u001d;\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016\u0001\u00027b]\u001eT\u0011\u0001W\u0001\u0005U\u00064\u0018-\u0003\u0002[+\n11\u000b\u001e:j]\u001eDa\u0001\u0018\u0001!\u0002\u0013Y\u0015!\t3faJ,7-\u0019;fIB\u0013xN^5eKJ,e.\u00192mK\u0012\u001cuN\u001c4jON\u0004\u0003b\u00020\u0001\u0005\u0004%IaX\u0001\u0016aJ|g/\u001b3fe\u0016s\u0017M\u00197fI\u000e{gNZ5h+\u0005\u0019\u0006BB1\u0001A\u0003%1+\u0001\fqe>4\u0018\u000eZ3s\u000b:\f'\r\\3e\u0007>tg-[4!\u0011\u001d\u0019\u0007A1A\u0005\n\u0011\f\u0001\u0004Z3mK\u001e\fG/[8o)>\\WM\u001c)s_ZLG-\u001a:t+\u0005)\u0007\u0003\u0002\u0019gQ*L!aZ\u001d\u0003\u00075\u000b\u0007\u000f\u0005\u00021S&\u0011!,\u000f\t\u0003\t.L!\u0001\u001c\u0002\u0003;!\u000bGm\\8q\t\u0016dWmZ1uS>tGk\\6f]B\u0013xN^5eKJDaA\u001c\u0001!\u0002\u0013)\u0017!\u00073fY\u0016<\u0017\r^5p]R{7.\u001a8Qe>4\u0018\u000eZ3sg\u0002BQ!\u0011\u0001\u0005\u0002A$2aQ9s\u0011\u0015Qr\u000e1\u0001\u001d\u0011\u0015\ts\u000e1\u0001#\u0011\u0015!\b\u0001\"\u0003e\u0003m9W\r\u001e#fY\u0016<\u0017\r^5p]R{7.\u001a8Qe>4\u0018\u000eZ3sg\")a\u000f\u0001C\u0005o\u0006\u00112/\u00194f\u0007J,\u0017\r^3Qe>4\u0018\u000eZ3s)\tA8\u0010E\u0002\u000fs*L!A_\b\u0003\r=\u0003H/[8o\u0011\u0019aX\u000f\"a\u0001{\u0006A1M]3bi\u00164e\u000eE\u0002\u000f}*L!a`\b\u0003\u0011q\u0012\u0017P\\1nKzBq!a\u0001\u0001\t\u0003\t)!\u0001\tjgN+'O^5dK\u0016s\u0017M\u00197fIR!\u0011qAA\u0007!\rq\u0011\u0011B\u0005\u0004\u0003\u0017y!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u001f\t\t\u00011\u0001i\u0003-\u0019XM\u001d<jG\u0016t\u0015-\\3\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u0005\ts-\u001a;TKJ4\u0018nY3EK2,w-\u0019;j_:$vn[3o!J|g/\u001b3feR\u0019\u00010a\u0006\t\u000f\u0005e\u0011\u0011\u0003a\u0001Q\u000691/\u001a:wS\u000e,\u0007bBA\u000f\u0001\u0011\u0005\u0011qD\u0001\u0017_\n$\u0018-\u001b8EK2,w-\u0019;j_:$vn[3ogR1\u0011\u0011EA\u0014\u0003S\u00012ADA\u0012\u0013\r\t)c\u0004\u0002\u0005\u0019>tw\r\u0003\u0004\"\u00037\u0001\rA\t\u0005\t\u0003W\tY\u00021\u0001\u0002.\u0005)1M]3egB!\u0011qFA\u001a\u001b\t\t\tD\u0003\u0002\u0004M%!\u0011QGA\u0019\u0005-\u0019%/\u001a3f]RL\u0017\r\\:")
public class HadoopDelegationTokenManager
implements Logging {
    private final SparkConf sparkConf;
    private final Function1<Configuration, Set<FileSystem>> fileSystems;
    private final List<String> deprecatedProviderEnabledConfigs;
    private final String providerEnabledConfig;
    private final Map<String, HadoopDelegationTokenProvider> delegationTokenProviders;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private List<String> deprecatedProviderEnabledConfigs() {
        return this.deprecatedProviderEnabledConfigs;
    }

    private String providerEnabledConfig() {
        return this.providerEnabledConfig;
    }

    private Map<String, HadoopDelegationTokenProvider> delegationTokenProviders() {
        return this.delegationTokenProviders;
    }

    private Map<String, HadoopDelegationTokenProvider> getDelegationTokenProviders() {
        Seq providers = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HadoopFSDelegationTokenProvider[]{new HadoopFSDelegationTokenProvider(this.fileSystems)}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.safeCreateProvider((Function0<HadoopDelegationTokenProvider>)(Function0 & Serializable & scala.Serializable)() -> new HiveDelegationTokenProvider())), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.safeCreateProvider((Function0<HadoopDelegationTokenProvider>)(Function0 & Serializable & scala.Serializable)() -> new HBaseDelegationTokenProvider())), Seq$.MODULE$.canBuildFrom());
        return ((TraversableOnce)((TraversableLike)providers.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)this.isServiceEnabled(p.serviceName())))).map((Function1 & Serializable & scala.Serializable)p -> new Tuple2((Object)p.serviceName(), p), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Option<HadoopDelegationTokenProvider> safeCreateProvider(Function0<HadoopDelegationTokenProvider> createFn) {
        Some some;
        try {
            some = new Some(createFn.apply());
        }
        catch (Throwable t) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to load built in provider.", t);
            some = None$.MODULE$;
        }
        return some;
    }

    public boolean isServiceEnabled(String serviceName) {
        String key = new StringOps(Predef$.MODULE$.augmentString(this.providerEnabledConfig())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceName}));
        this.deprecatedProviderEnabledConfigs().foreach((Function1 & Serializable & scala.Serializable)pattern -> {
            HadoopDelegationTokenManager.$anonfun$isServiceEnabled$1(this, serviceName, key, pattern);
            return BoxedUnit.UNIT;
        });
        boolean isEnabledDeprecated = this.deprecatedProviderEnabledConfigs().forall((Function1 & Serializable & scala.Serializable)pattern -> BoxesRunTime.boxToBoolean((boolean)HadoopDelegationTokenManager.$anonfun$isServiceEnabled$3(this, serviceName, pattern)));
        return BoxesRunTime.unboxToBoolean((Object)this.sparkConf.getOption(key).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HadoopDelegationTokenManager.$anonfun$isServiceEnabled$6(x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> isEnabledDeprecated));
    }

    public Option<HadoopDelegationTokenProvider> getServiceDelegationTokenProvider(String service) {
        return this.delegationTokenProviders().get((Object)service);
    }

    public long obtainDelegationTokens(Configuration hadoopConf, Credentials creds) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.delegationTokenProviders().values().flatMap((Function1 & Serializable & scala.Serializable)provider -> {
            Iterable iterable;
            if (provider.delegationTokensRequired($this.sparkConf, hadoopConf)) {
                iterable = Option$.MODULE$.option2Iterable(provider.obtainDelegationTokens(hadoopConf, $this.sparkConf, creds));
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(98).append("Service ").append(provider.serviceName()).append(" does not require a token.").append(" Check your configuration to see if security is disabled or not.").toString());
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.min(x, y)));
    }

    public static final /* synthetic */ void $anonfun$isServiceEnabled$1(HadoopDelegationTokenManager $this, String serviceName$1, String key$1, String pattern) {
        block0: {
            String deprecatedKey = new StringOps(Predef$.MODULE$.augmentString(pattern)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceName$1}));
            if (!$this.sparkConf.contains(deprecatedKey)) break block0;
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append(deprecatedKey).append(" is deprecated.  Please use ").append(key$1).append(" instead.").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$isServiceEnabled$4(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$isServiceEnabled$3(HadoopDelegationTokenManager $this, String serviceName$1, String pattern) {
        return BoxesRunTime.unboxToBoolean((Object)$this.sparkConf.getOption(new StringOps(Predef$.MODULE$.augmentString(pattern)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceName$1}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopDelegationTokenManager.$anonfun$isServiceEnabled$4(x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    public static final /* synthetic */ boolean $anonfun$isServiceEnabled$6(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
    }

    public HadoopDelegationTokenManager(SparkConf sparkConf, Configuration hadoopConf, Function1<Configuration, Set<FileSystem>> fileSystems) {
        this.sparkConf = sparkConf;
        this.fileSystems = fileSystems;
        Logging.$init$(this);
        this.deprecatedProviderEnabledConfigs = new .colon.colon((Object)"spark.yarn.security.tokens.%s.enabled", (List)new .colon.colon((Object)"spark.yarn.security.credentials.%s.enabled", (List)Nil$.MODULE$));
        this.providerEnabledConfig = "spark.security.credentials.%s.enabled";
        this.delegationTokenProviders = this.getDelegationTokenProviders();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Using the following builtin delegation token providers: ").append(new StringBuilder(1).append(this.delegationTokenProviders().keys().mkString(", ")).append(".").toString()).toString());
    }

    public HadoopDelegationTokenManager(SparkConf sparkConf, Configuration hadoopConf) {
        this(sparkConf, hadoopConf, (Function1<Configuration, Set<FileSystem>>)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<FileSystem> apply(Configuration hadoopConf) {
                return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileSystem[]{FileSystem.get((Configuration)hadoopConf).getHomeDirectory().getFileSystem(hadoopConf)}));
            }
        });
    }
}

