/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda;

import org.jadira.usertype.dateandtime.joda.columnmapper.StringColumnDateTimeZoneWithOffsetMapper;
import org.jadira.usertype.dateandtime.joda.columnmapper.StringColumnLocalDateTimeMapper;
import org.jadira.usertype.dateandtime.joda.util.DateTimeZoneWithOffset;
import org.jadira.usertype.spi.shared.AbstractParameterizedMultiColumnUserType;
import org.jadira.usertype.spi.shared.ColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.utils.reflection.ArrayUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;

public class PersistentDateTimeAsString
extends AbstractParameterizedMultiColumnUserType<DateTime>
implements DatabaseZoneConfigured<DateTimeZone> {
    private static final long serialVersionUID = 1364221029397346011L;
    private static final ColumnMapper<?, ?>[] COLUMN_MAPPERS = new ColumnMapper[]{new StringColumnLocalDateTimeMapper(), new StringColumnDateTimeZoneWithOffsetMapper()};
    private static final String[] PROPERTY_NAMES = new String[]{"datetime", "offset"};
    private DateTimeZone databaseZone = DateTimeZone.UTC;

    protected ColumnMapper<?, ?>[] getColumnMappers() {
        return COLUMN_MAPPERS;
    }

    public String[] getPropertyNames() {
        return (String[])ArrayUtils.copyOf((Object[])PROPERTY_NAMES);
    }

    protected DateTime fromConvertedColumns(Object[] convertedColumns) {
        DateTime result;
        LocalDateTime datePart = (LocalDateTime)convertedColumns[0];
        DateTimeZoneWithOffset offset = (DateTimeZoneWithOffset)convertedColumns[1];
        if (datePart == null) {
            result = null;
        } else {
            result = datePart.toDateTime(this.databaseZone == null ? offset.getStandardDateTimeZone() : this.databaseZone);
            if (this.databaseZone != null) {
                result = result.withZone(offset.getStandardDateTimeZone());
            }
        }
        if (result != null && offset.getOffsetDateTimeZone() != null && offset.getStandardDateTimeZone().getOffset((ReadableInstant)result) > offset.getOffsetDateTimeZone().getOffset((ReadableInstant)result)) {
            return result.withLaterOffsetAtOverlap();
        }
        return result;
    }

    protected Object[] toConvertedColumns(DateTime value) {
        DateTime myValue = this.databaseZone == null ? value : value.withZone(this.databaseZone);
        return new Object[]{myValue.toLocalDateTime(), new DateTimeZoneWithOffset(value.getZone(), value.getZone().isFixed() ? null : DateTimeZone.forOffsetMillis((int)value.getZone().getOffset((ReadableInstant)value)))};
    }

    public void setDatabaseZone(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public DateTimeZone parseZone(String zoneString) {
        return DateTimeZone.forID((String)zoneString);
    }
}

