/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpleemail.model.RawMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendRawEmailRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String source;
    private List<String> destinations;
    private RawMessage rawMessage;

    public SendRawEmailRequest() {
    }

    public SendRawEmailRequest(RawMessage rawMessage) {
        this.rawMessage = rawMessage;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public SendRawEmailRequest withSource(String source) {
        this.source = source;
        return this;
    }

    public List<String> getDestinations() {
        if (this.destinations == null) {
            this.destinations = new ArrayList<String>();
        }
        return this.destinations;
    }

    public void setDestinations(Collection<String> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        ArrayList<String> destinationsCopy = new ArrayList<String>(destinations.size());
        destinationsCopy.addAll(destinations);
        this.destinations = destinationsCopy;
    }

    public SendRawEmailRequest withDestinations(String ... destinations) {
        if (this.getDestinations() == null) {
            this.setDestinations(new ArrayList<String>(destinations.length));
        }
        for (String value : destinations) {
            this.getDestinations().add(value);
        }
        return this;
    }

    public SendRawEmailRequest withDestinations(Collection<String> destinations) {
        if (destinations == null) {
            this.destinations = null;
        } else {
            ArrayList<String> destinationsCopy = new ArrayList<String>(destinations.size());
            destinationsCopy.addAll(destinations);
            this.destinations = destinationsCopy;
        }
        return this;
    }

    public RawMessage getRawMessage() {
        return this.rawMessage;
    }

    public void setRawMessage(RawMessage rawMessage) {
        this.rawMessage = rawMessage;
    }

    public SendRawEmailRequest withRawMessage(RawMessage rawMessage) {
        this.rawMessage = rawMessage;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSource() != null) {
            sb.append("Source: " + this.getSource() + ", ");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: " + this.getDestinations() + ", ");
        }
        if (this.getRawMessage() != null) {
            sb.append("RawMessage: " + this.getRawMessage() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : ((Object)this.getDestinations()).hashCode());
        hashCode = 31 * hashCode + (this.getRawMessage() == null ? 0 : this.getRawMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendRawEmailRequest)) {
            return false;
        }
        SendRawEmailRequest other = (SendRawEmailRequest)obj;
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !((Object)other.getDestinations()).equals(this.getDestinations())) {
            return false;
        }
        if (other.getRawMessage() == null ^ this.getRawMessage() == null) {
            return false;
        }
        return other.getRawMessage() == null || other.getRawMessage().equals(this.getRawMessage());
    }
}

