/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.simpledb.AmazonSimpleDBAsync;
import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.DeleteDomainRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataResult;
import com.amazonaws.services.simpledb.model.GetAttributesRequest;
import com.amazonaws.services.simpledb.model.GetAttributesResult;
import com.amazonaws.services.simpledb.model.ListDomainsRequest;
import com.amazonaws.services.simpledb.model.ListDomainsResult;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSimpleDBAsyncClient
extends AmazonSimpleDBClient
implements AmazonSimpleDBAsync {
    private ExecutorService executorService;

    public AmazonSimpleDBAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonSimpleDBAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonSimpleDBAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonSimpleDBAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonSimpleDBAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSimpleDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonSimpleDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonSimpleDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<SelectResult> selectAsync(final SelectRequest selectRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SelectResult>(){

            @Override
            public SelectResult call() throws Exception {
                return AmazonSimpleDBAsyncClient.this.select(selectRequest);
            }
        });
    }

    @Override
    public Future<SelectResult> selectAsync(final SelectRequest selectRequest, final AsyncHandler<SelectRequest, SelectResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SelectResult>(){

            @Override
            public SelectResult call() throws Exception {
                SelectResult result;
                try {
                    result = AmazonSimpleDBAsyncClient.this.select(selectRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(selectRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putAttributesAsync(final PutAttributesRequest putAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.putAttributes(putAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putAttributesAsync(final PutAttributesRequest putAttributesRequest, final AsyncHandler<PutAttributesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSimpleDBAsyncClient.this.putAttributes(putAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putAttributesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> batchDeleteAttributesAsync(final BatchDeleteAttributesRequest batchDeleteAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.batchDeleteAttributes(batchDeleteAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> batchDeleteAttributesAsync(final BatchDeleteAttributesRequest batchDeleteAttributesRequest, final AsyncHandler<BatchDeleteAttributesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSimpleDBAsyncClient.this.batchDeleteAttributes(batchDeleteAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(batchDeleteAttributesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDomainAsync(final DeleteDomainRequest deleteDomainRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.deleteDomain(deleteDomainRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDomainAsync(final DeleteDomainRequest deleteDomainRequest, final AsyncHandler<DeleteDomainRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSimpleDBAsyncClient.this.deleteDomain(deleteDomainRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteDomainRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createDomainAsync(final CreateDomainRequest createDomainRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.createDomain(createDomainRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createDomainAsync(final CreateDomainRequest createDomainRequest, final AsyncHandler<CreateDomainRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSimpleDBAsyncClient.this.createDomain(createDomainRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createDomainRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteAttributesAsync(final DeleteAttributesRequest deleteAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.deleteAttributes(deleteAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteAttributesAsync(final DeleteAttributesRequest deleteAttributesRequest, final AsyncHandler<DeleteAttributesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSimpleDBAsyncClient.this.deleteAttributes(deleteAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteAttributesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ListDomainsResult> listDomainsAsync(final ListDomainsRequest listDomainsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDomainsResult>(){

            @Override
            public ListDomainsResult call() throws Exception {
                return AmazonSimpleDBAsyncClient.this.listDomains(listDomainsRequest);
            }
        });
    }

    @Override
    public Future<ListDomainsResult> listDomainsAsync(final ListDomainsRequest listDomainsRequest, final AsyncHandler<ListDomainsRequest, ListDomainsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDomainsResult>(){

            @Override
            public ListDomainsResult call() throws Exception {
                ListDomainsResult result;
                try {
                    result = AmazonSimpleDBAsyncClient.this.listDomains(listDomainsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listDomainsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetAttributesResult> getAttributesAsync(final GetAttributesRequest getAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetAttributesResult>(){

            @Override
            public GetAttributesResult call() throws Exception {
                return AmazonSimpleDBAsyncClient.this.getAttributes(getAttributesRequest);
            }
        });
    }

    @Override
    public Future<GetAttributesResult> getAttributesAsync(final GetAttributesRequest getAttributesRequest, final AsyncHandler<GetAttributesRequest, GetAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetAttributesResult>(){

            @Override
            public GetAttributesResult call() throws Exception {
                GetAttributesResult result;
                try {
                    result = AmazonSimpleDBAsyncClient.this.getAttributes(getAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getAttributesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> batchPutAttributesAsync(final BatchPutAttributesRequest batchPutAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.batchPutAttributes(batchPutAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> batchPutAttributesAsync(final BatchPutAttributesRequest batchPutAttributesRequest, final AsyncHandler<BatchPutAttributesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSimpleDBAsyncClient.this.batchPutAttributes(batchPutAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(batchPutAttributesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DomainMetadataResult> domainMetadataAsync(final DomainMetadataRequest domainMetadataRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DomainMetadataResult>(){

            @Override
            public DomainMetadataResult call() throws Exception {
                return AmazonSimpleDBAsyncClient.this.domainMetadata(domainMetadataRequest);
            }
        });
    }

    @Override
    public Future<DomainMetadataResult> domainMetadataAsync(final DomainMetadataRequest domainMetadataRequest, final AsyncHandler<DomainMetadataRequest, DomainMetadataResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DomainMetadataResult>(){

            @Override
            public DomainMetadataResult call() throws Exception {
                DomainMetadataResult result;
                try {
                    result = AmazonSimpleDBAsyncClient.this.domainMetadata(domainMetadataRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(domainMetadataRequest, result);
                return result;
            }
        });
    }
}

