/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.workflow;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.workflow.WorkflowCumulativeStatisticsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkflowCumulativeStatistics
extends Resource {
    private static final long serialVersionUID = 190316702112429L;
    private final String accountSid;
    private final Integer avgTaskAcceptanceTime;
    private final DateTime startTime;
    private final DateTime endTime;
    private final Integer reservationsCreated;
    private final Integer reservationsAccepted;
    private final Integer reservationsRejected;
    private final Integer reservationsTimedOut;
    private final Integer reservationsCanceled;
    private final Integer reservationsRescinded;
    private final Map<String, Object> splitByWaitTime;
    private final Map<String, Object> waitDurationUntilAccepted;
    private final Map<String, Object> waitDurationUntilCanceled;
    private final Integer tasksCanceled;
    private final Integer tasksCompleted;
    private final Integer tasksEntered;
    private final Integer tasksDeleted;
    private final Integer tasksMoved;
    private final Integer tasksTimedOutInWorkflow;
    private final String workflowSid;
    private final String workspaceSid;
    private final URI url;

    public static WorkflowCumulativeStatisticsFetcher fetcher(String pathWorkspaceSid, String pathWorkflowSid) {
        return new WorkflowCumulativeStatisticsFetcher(pathWorkspaceSid, pathWorkflowSid);
    }

    public static WorkflowCumulativeStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, WorkflowCumulativeStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static WorkflowCumulativeStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, WorkflowCumulativeStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private WorkflowCumulativeStatistics(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="avg_task_acceptance_time") Integer avgTaskAcceptanceTime, @JsonProperty(value="start_time") String startTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="reservations_created") Integer reservationsCreated, @JsonProperty(value="reservations_accepted") Integer reservationsAccepted, @JsonProperty(value="reservations_rejected") Integer reservationsRejected, @JsonProperty(value="reservations_timed_out") Integer reservationsTimedOut, @JsonProperty(value="reservations_canceled") Integer reservationsCanceled, @JsonProperty(value="reservations_rescinded") Integer reservationsRescinded, @JsonProperty(value="split_by_wait_time") Map<String, Object> splitByWaitTime, @JsonProperty(value="wait_duration_until_accepted") Map<String, Object> waitDurationUntilAccepted, @JsonProperty(value="wait_duration_until_canceled") Map<String, Object> waitDurationUntilCanceled, @JsonProperty(value="tasks_canceled") Integer tasksCanceled, @JsonProperty(value="tasks_completed") Integer tasksCompleted, @JsonProperty(value="tasks_entered") Integer tasksEntered, @JsonProperty(value="tasks_deleted") Integer tasksDeleted, @JsonProperty(value="tasks_moved") Integer tasksMoved, @JsonProperty(value="tasks_timed_out_in_workflow") Integer tasksTimedOutInWorkflow, @JsonProperty(value="workflow_sid") String workflowSid, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.avgTaskAcceptanceTime = avgTaskAcceptanceTime;
        this.startTime = DateConverter.iso8601DateTimeFromString(startTime);
        this.endTime = DateConverter.iso8601DateTimeFromString(endTime);
        this.reservationsCreated = reservationsCreated;
        this.reservationsAccepted = reservationsAccepted;
        this.reservationsRejected = reservationsRejected;
        this.reservationsTimedOut = reservationsTimedOut;
        this.reservationsCanceled = reservationsCanceled;
        this.reservationsRescinded = reservationsRescinded;
        this.splitByWaitTime = splitByWaitTime;
        this.waitDurationUntilAccepted = waitDurationUntilAccepted;
        this.waitDurationUntilCanceled = waitDurationUntilCanceled;
        this.tasksCanceled = tasksCanceled;
        this.tasksCompleted = tasksCompleted;
        this.tasksEntered = tasksEntered;
        this.tasksDeleted = tasksDeleted;
        this.tasksMoved = tasksMoved;
        this.tasksTimedOutInWorkflow = tasksTimedOutInWorkflow;
        this.workflowSid = workflowSid;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Integer getAvgTaskAcceptanceTime() {
        return this.avgTaskAcceptanceTime;
    }

    public final DateTime getStartTime() {
        return this.startTime;
    }

    public final DateTime getEndTime() {
        return this.endTime;
    }

    public final Integer getReservationsCreated() {
        return this.reservationsCreated;
    }

    public final Integer getReservationsAccepted() {
        return this.reservationsAccepted;
    }

    public final Integer getReservationsRejected() {
        return this.reservationsRejected;
    }

    public final Integer getReservationsTimedOut() {
        return this.reservationsTimedOut;
    }

    public final Integer getReservationsCanceled() {
        return this.reservationsCanceled;
    }

    public final Integer getReservationsRescinded() {
        return this.reservationsRescinded;
    }

    public final Map<String, Object> getSplitByWaitTime() {
        return this.splitByWaitTime;
    }

    public final Map<String, Object> getWaitDurationUntilAccepted() {
        return this.waitDurationUntilAccepted;
    }

    public final Map<String, Object> getWaitDurationUntilCanceled() {
        return this.waitDurationUntilCanceled;
    }

    public final Integer getTasksCanceled() {
        return this.tasksCanceled;
    }

    public final Integer getTasksCompleted() {
        return this.tasksCompleted;
    }

    public final Integer getTasksEntered() {
        return this.tasksEntered;
    }

    public final Integer getTasksDeleted() {
        return this.tasksDeleted;
    }

    public final Integer getTasksMoved() {
        return this.tasksMoved;
    }

    public final Integer getTasksTimedOutInWorkflow() {
        return this.tasksTimedOutInWorkflow;
    }

    public final String getWorkflowSid() {
        return this.workflowSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowCumulativeStatistics other = (WorkflowCumulativeStatistics)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.avgTaskAcceptanceTime, other.avgTaskAcceptanceTime) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.reservationsCreated, other.reservationsCreated) && Objects.equals(this.reservationsAccepted, other.reservationsAccepted) && Objects.equals(this.reservationsRejected, other.reservationsRejected) && Objects.equals(this.reservationsTimedOut, other.reservationsTimedOut) && Objects.equals(this.reservationsCanceled, other.reservationsCanceled) && Objects.equals(this.reservationsRescinded, other.reservationsRescinded) && Objects.equals(this.splitByWaitTime, other.splitByWaitTime) && Objects.equals(this.waitDurationUntilAccepted, other.waitDurationUntilAccepted) && Objects.equals(this.waitDurationUntilCanceled, other.waitDurationUntilCanceled) && Objects.equals(this.tasksCanceled, other.tasksCanceled) && Objects.equals(this.tasksCompleted, other.tasksCompleted) && Objects.equals(this.tasksEntered, other.tasksEntered) && Objects.equals(this.tasksDeleted, other.tasksDeleted) && Objects.equals(this.tasksMoved, other.tasksMoved) && Objects.equals(this.tasksTimedOutInWorkflow, other.tasksTimedOutInWorkflow) && Objects.equals(this.workflowSid, other.workflowSid) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.avgTaskAcceptanceTime, this.startTime, this.endTime, this.reservationsCreated, this.reservationsAccepted, this.reservationsRejected, this.reservationsTimedOut, this.reservationsCanceled, this.reservationsRescinded, this.splitByWaitTime, this.waitDurationUntilAccepted, this.waitDurationUntilCanceled, this.tasksCanceled, this.tasksCompleted, this.tasksEntered, this.tasksDeleted, this.tasksMoved, this.tasksTimedOutInWorkflow, this.workflowSid, this.workspaceSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("avgTaskAcceptanceTime", this.avgTaskAcceptanceTime).add("startTime", this.startTime).add("endTime", this.endTime).add("reservationsCreated", this.reservationsCreated).add("reservationsAccepted", this.reservationsAccepted).add("reservationsRejected", this.reservationsRejected).add("reservationsTimedOut", this.reservationsTimedOut).add("reservationsCanceled", this.reservationsCanceled).add("reservationsRescinded", this.reservationsRescinded).add("splitByWaitTime", this.splitByWaitTime).add("waitDurationUntilAccepted", this.waitDurationUntilAccepted).add("waitDurationUntilCanceled", this.waitDurationUntilCanceled).add("tasksCanceled", this.tasksCanceled).add("tasksCompleted", this.tasksCompleted).add("tasksEntered", this.tasksEntered).add("tasksDeleted", this.tasksDeleted).add("tasksMoved", this.tasksMoved).add("tasksTimedOutInWorkflow", this.tasksTimedOutInWorkflow).add("workflowSid", this.workflowSid).add("workspaceSid", this.workspaceSid).add("url", this.url).toString();
    }
}

