/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v2.service.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.ipmessaging.v2.service.channel.MessageCreator;
import com.twilio.rest.ipmessaging.v2.service.channel.MessageDeleter;
import com.twilio.rest.ipmessaging.v2.service.channel.MessageFetcher;
import com.twilio.rest.ipmessaging.v2.service.channel.MessageReader;
import com.twilio.rest.ipmessaging.v2.service.channel.MessageUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Message
extends Resource {
    private static final long serialVersionUID = 240696203452729L;
    private final String sid;
    private final String accountSid;
    private final String attributes;
    private final String serviceSid;
    private final String to;
    private final String channelSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String lastUpdatedBy;
    private final Boolean wasEdited;
    private final String from;
    private final String body;
    private final Integer index;
    private final String type;
    private final Map<String, Object> media;
    private final URI url;

    public static MessageFetcher fetcher(String pathServiceSid, String pathChannelSid, String pathSid) {
        return new MessageFetcher(pathServiceSid, pathChannelSid, pathSid);
    }

    public static MessageCreator creator(String pathServiceSid, String pathChannelSid) {
        return new MessageCreator(pathServiceSid, pathChannelSid);
    }

    public static MessageReader reader(String pathServiceSid, String pathChannelSid) {
        return new MessageReader(pathServiceSid, pathChannelSid);
    }

    public static MessageDeleter deleter(String pathServiceSid, String pathChannelSid, String pathSid) {
        return new MessageDeleter(pathServiceSid, pathChannelSid, pathSid);
    }

    public static MessageUpdater updater(String pathServiceSid, String pathChannelSid, String pathSid) {
        return new MessageUpdater(pathServiceSid, pathChannelSid, pathSid);
    }

    public static Message fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Message fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Message(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="to") String to, @JsonProperty(value="channel_sid") String channelSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="last_updated_by") String lastUpdatedBy, @JsonProperty(value="was_edited") Boolean wasEdited, @JsonProperty(value="from") String from, @JsonProperty(value="body") String body, @JsonProperty(value="index") Integer index, @JsonProperty(value="type") String type, @JsonProperty(value="media") Map<String, Object> media, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.attributes = attributes;
        this.serviceSid = serviceSid;
        this.to = to;
        this.channelSid = channelSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.lastUpdatedBy = lastUpdatedBy;
        this.wasEdited = wasEdited;
        this.from = from;
        this.body = body;
        this.index = index;
        this.type = type;
        this.media = media;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getTo() {
        return this.to;
    }

    public final String getChannelSid() {
        return this.channelSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public final Boolean getWasEdited() {
        return this.wasEdited;
    }

    public final String getFrom() {
        return this.from;
    }

    public final String getBody() {
        return this.body;
    }

    public final Integer getIndex() {
        return this.index;
    }

    public final String getType() {
        return this.type;
    }

    public final Map<String, Object> getMedia() {
        return this.media;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message other = (Message)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.to, other.to) && Objects.equals(this.channelSid, other.channelSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.lastUpdatedBy, other.lastUpdatedBy) && Objects.equals(this.wasEdited, other.wasEdited) && Objects.equals(this.from, other.from) && Objects.equals(this.body, other.body) && Objects.equals(this.index, other.index) && Objects.equals(this.type, other.type) && Objects.equals(this.media, other.media) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.attributes, this.serviceSid, this.to, this.channelSid, this.dateCreated, this.dateUpdated, this.lastUpdatedBy, this.wasEdited, this.from, this.body, this.index, this.type, this.media, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("attributes", this.attributes).add("serviceSid", this.serviceSid).add("to", this.to).add("channelSid", this.channelSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("lastUpdatedBy", this.lastUpdatedBy).add("wasEdited", this.wasEdited).add("from", this.from).add("body", this.body).add("index", this.index).add("type", this.type).add("media", this.media).add("url", this.url).toString();
    }

    public static enum WebhookEnabledType {
        TRUE("true"),
        FALSE("false");

        private final String value;

        private WebhookEnabledType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static WebhookEnabledType forValue(String value) {
            return (WebhookEnabledType)Promoter.enumFromString((String)value, (Enum[])WebhookEnabledType.values());
        }
    }

    public static enum OrderType {
        ASC("asc"),
        DESC("desc");

        private final String value;

        private OrderType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static OrderType forValue(String value) {
            return (OrderType)Promoter.enumFromString((String)value, (Enum[])OrderType.values());
        }
    }
}

