/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.ipmessaging.v1.ServiceCreator;
import com.twilio.rest.ipmessaging.v1.ServiceDeleter;
import com.twilio.rest.ipmessaging.v1.ServiceFetcher;
import com.twilio.rest.ipmessaging.v1.ServiceReader;
import com.twilio.rest.ipmessaging.v1.ServiceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Service
extends Resource {
    private static final long serialVersionUID = 209287578457944L;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String defaultServiceRoleSid;
    private final String defaultChannelRoleSid;
    private final String defaultChannelCreatorRoleSid;
    private final Boolean readStatusEnabled;
    private final Boolean reachabilityEnabled;
    private final Integer typingIndicatorTimeout;
    private final Integer consumptionReportInterval;
    private final Map<String, Object> limits;
    private final Map<String, Object> webhooks;
    private final String preWebhookUrl;
    private final String postWebhookUrl;
    private final String webhookMethod;
    private final List<String> webhookFilters;
    private final Map<String, Object> notifications;
    private final URI url;
    private final Map<String, String> links;

    public static ServiceFetcher fetcher(String pathSid) {
        return new ServiceFetcher(pathSid);
    }

    public static ServiceDeleter deleter(String pathSid) {
        return new ServiceDeleter(pathSid);
    }

    public static ServiceCreator creator(String friendlyName) {
        return new ServiceCreator(friendlyName);
    }

    public static ServiceReader reader() {
        return new ServiceReader();
    }

    public static ServiceUpdater updater(String pathSid) {
        return new ServiceUpdater(pathSid);
    }

    public static Service fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Service fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Service(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="default_service_role_sid") String defaultServiceRoleSid, @JsonProperty(value="default_channel_role_sid") String defaultChannelRoleSid, @JsonProperty(value="default_channel_creator_role_sid") String defaultChannelCreatorRoleSid, @JsonProperty(value="read_status_enabled") Boolean readStatusEnabled, @JsonProperty(value="reachability_enabled") Boolean reachabilityEnabled, @JsonProperty(value="typing_indicator_timeout") Integer typingIndicatorTimeout, @JsonProperty(value="consumption_report_interval") Integer consumptionReportInterval, @JsonProperty(value="limits") Map<String, Object> limits, @JsonProperty(value="webhooks") Map<String, Object> webhooks, @JsonProperty(value="pre_webhook_url") String preWebhookUrl, @JsonProperty(value="post_webhook_url") String postWebhookUrl, @JsonProperty(value="webhook_method") String webhookMethod, @JsonProperty(value="webhook_filters") List<String> webhookFilters, @JsonProperty(value="notifications") Map<String, Object> notifications, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.defaultServiceRoleSid = defaultServiceRoleSid;
        this.defaultChannelRoleSid = defaultChannelRoleSid;
        this.defaultChannelCreatorRoleSid = defaultChannelCreatorRoleSid;
        this.readStatusEnabled = readStatusEnabled;
        this.reachabilityEnabled = reachabilityEnabled;
        this.typingIndicatorTimeout = typingIndicatorTimeout;
        this.consumptionReportInterval = consumptionReportInterval;
        this.limits = limits;
        this.webhooks = webhooks;
        this.preWebhookUrl = preWebhookUrl;
        this.postWebhookUrl = postWebhookUrl;
        this.webhookMethod = webhookMethod;
        this.webhookFilters = webhookFilters;
        this.notifications = notifications;
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getDefaultServiceRoleSid() {
        return this.defaultServiceRoleSid;
    }

    public final String getDefaultChannelRoleSid() {
        return this.defaultChannelRoleSid;
    }

    public final String getDefaultChannelCreatorRoleSid() {
        return this.defaultChannelCreatorRoleSid;
    }

    public final Boolean getReadStatusEnabled() {
        return this.readStatusEnabled;
    }

    public final Boolean getReachabilityEnabled() {
        return this.reachabilityEnabled;
    }

    public final Integer getTypingIndicatorTimeout() {
        return this.typingIndicatorTimeout;
    }

    public final Integer getConsumptionReportInterval() {
        return this.consumptionReportInterval;
    }

    public final Map<String, Object> getLimits() {
        return this.limits;
    }

    public final Map<String, Object> getWebhooks() {
        return this.webhooks;
    }

    public final String getPreWebhookUrl() {
        return this.preWebhookUrl;
    }

    public final String getPostWebhookUrl() {
        return this.postWebhookUrl;
    }

    public final String getWebhookMethod() {
        return this.webhookMethod;
    }

    public final List<String> getWebhookFilters() {
        return this.webhookFilters;
    }

    public final Map<String, Object> getNotifications() {
        return this.notifications;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service other = (Service)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.defaultServiceRoleSid, other.defaultServiceRoleSid) && Objects.equals(this.defaultChannelRoleSid, other.defaultChannelRoleSid) && Objects.equals(this.defaultChannelCreatorRoleSid, other.defaultChannelCreatorRoleSid) && Objects.equals(this.readStatusEnabled, other.readStatusEnabled) && Objects.equals(this.reachabilityEnabled, other.reachabilityEnabled) && Objects.equals(this.typingIndicatorTimeout, other.typingIndicatorTimeout) && Objects.equals(this.consumptionReportInterval, other.consumptionReportInterval) && Objects.equals(this.limits, other.limits) && Objects.equals(this.webhooks, other.webhooks) && Objects.equals(this.preWebhookUrl, other.preWebhookUrl) && Objects.equals(this.postWebhookUrl, other.postWebhookUrl) && Objects.equals(this.webhookMethod, other.webhookMethod) && Objects.equals(this.webhookFilters, other.webhookFilters) && Objects.equals(this.notifications, other.notifications) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.friendlyName, this.dateCreated, this.dateUpdated, this.defaultServiceRoleSid, this.defaultChannelRoleSid, this.defaultChannelCreatorRoleSid, this.readStatusEnabled, this.reachabilityEnabled, this.typingIndicatorTimeout, this.consumptionReportInterval, this.limits, this.webhooks, this.preWebhookUrl, this.postWebhookUrl, this.webhookMethod, this.webhookFilters, this.notifications, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("friendlyName", this.friendlyName).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("defaultServiceRoleSid", this.defaultServiceRoleSid).add("defaultChannelRoleSid", this.defaultChannelRoleSid).add("defaultChannelCreatorRoleSid", this.defaultChannelCreatorRoleSid).add("readStatusEnabled", this.readStatusEnabled).add("reachabilityEnabled", this.reachabilityEnabled).add("typingIndicatorTimeout", this.typingIndicatorTimeout).add("consumptionReportInterval", this.consumptionReportInterval).add("limits", this.limits).add("webhooks", this.webhooks).add("preWebhookUrl", this.preWebhookUrl).add("postWebhookUrl", this.postWebhookUrl).add("webhookMethod", this.webhookMethod).add("webhookFilters", this.webhookFilters).add("notifications", this.notifications).add("url", this.url).add("links", this.links).toString();
    }
}

