/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.conference;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.conference.Recording;

public class RecordingUpdater
extends Updater<Recording> {
    private String pathAccountSid;
    private final String pathConferenceSid;
    private final String pathSid;
    private final Recording.Status status;
    private String pauseBehavior;

    public RecordingUpdater(String pathConferenceSid, String pathSid, Recording.Status status) {
        this.pathConferenceSid = pathConferenceSid;
        this.pathSid = pathSid;
        this.status = status;
    }

    public RecordingUpdater(String pathAccountSid, String pathConferenceSid, String pathSid, Recording.Status status) {
        this.pathAccountSid = pathAccountSid;
        this.pathConferenceSid = pathConferenceSid;
        this.pathSid = pathSid;
        this.status = status;
    }

    public RecordingUpdater setPauseBehavior(String pauseBehavior) {
        this.pauseBehavior = pauseBehavior;
        return this;
    }

    @Override
    public Recording update(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Conferences/" + this.pathConferenceSid + "/Recordings/" + this.pathSid + ".json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Recording update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Recording.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
        if (this.pauseBehavior != null) {
            request.addPostParam("PauseBehavior", this.pauseBehavior);
        }
    }
}

