/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.Account;

public class AccountUpdater
extends Updater<Account> {
    private String pathSid;
    private String friendlyName;
    private Account.Status status;

    public AccountUpdater() {
    }

    public AccountUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public AccountUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public AccountUpdater setStatus(Account.Status status) {
        this.status = status;
        return this;
    }

    @Override
    public Account update(TwilioRestClient client) {
        this.pathSid = this.pathSid == null ? client.getAccountSid() : this.pathSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathSid + ".json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Account update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Account.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
    }
}

