/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.interceptors;

import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryPolicyBase;
import java.util.Collection;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExponentialRetryPolicy
extends RetryPolicyBase {
    private final long initialRetryIntervalSeconds;
    private long maximumRetryIntervalSeconds = -1L;
    private long retryExpirationIntervalSeconds = -1L;
    private double backoffCoefficient = 2.0;
    private int maximumAttempts = -1;

    public ExponentialRetryPolicy(long initialRetryIntervalSeconds) {
        this.initialRetryIntervalSeconds = initialRetryIntervalSeconds;
    }

    public long getInitialRetryIntervalSeconds() {
        return this.initialRetryIntervalSeconds;
    }

    public long getMaximumRetryIntervalSeconds() {
        return this.maximumRetryIntervalSeconds;
    }

    public void setMaximumRetryIntervalSeconds(long maximumRetryIntervalSeconds) {
        this.maximumRetryIntervalSeconds = maximumRetryIntervalSeconds;
    }

    public ExponentialRetryPolicy withMaximumRetryIntervalSeconds(long maximumRetryIntervalSeconds) {
        this.maximumRetryIntervalSeconds = maximumRetryIntervalSeconds;
        return this;
    }

    public long getRetryExpirationIntervalSeconds() {
        return this.retryExpirationIntervalSeconds;
    }

    public void setRetryExpirationIntervalSeconds(long retryExpirationIntervalSeconds) {
        this.retryExpirationIntervalSeconds = retryExpirationIntervalSeconds;
    }

    public ExponentialRetryPolicy withRetryExpirationIntervalSeconds(long retryExpirationIntervalSeconds) {
        this.retryExpirationIntervalSeconds = retryExpirationIntervalSeconds;
        return this;
    }

    public double getBackoffCoefficient() {
        return this.backoffCoefficient;
    }

    public void setBackoffCoefficient(double backoffCoefficient) {
        this.backoffCoefficient = backoffCoefficient;
    }

    public ExponentialRetryPolicy withBackoffCoefficient(double backoffCoefficient) {
        this.backoffCoefficient = backoffCoefficient;
        return this;
    }

    public int getMaximumAttempts() {
        return this.maximumAttempts;
    }

    public void setMaximumAttempts(int maximumAttempts) {
        this.maximumAttempts = maximumAttempts;
    }

    public ExponentialRetryPolicy withMaximumAttempts(int maximumAttempts) {
        this.maximumAttempts = maximumAttempts;
        return this;
    }

    @Override
    public ExponentialRetryPolicy withExceptionsToRetry(Collection<Class<? extends Throwable>> exceptionsToRetry) {
        super.withExceptionsToRetry(exceptionsToRetry);
        return this;
    }

    @Override
    public ExponentialRetryPolicy withExceptionsToExclude(Collection<Class<? extends Throwable>> exceptionsToRetry) {
        super.withExceptionsToExclude(exceptionsToRetry);
        return this;
    }

    @Override
    public long nextRetryDelaySeconds(Date firstAttempt, Date recordedFailure, int numberOfTries) {
        if (numberOfTries < 2) {
            throw new IllegalArgumentException("attempt is less then 2: " + numberOfTries);
        }
        if (this.maximumAttempts > -1 && numberOfTries > this.maximumAttempts) {
            return -1L;
        }
        long result = (long)((double)this.initialRetryIntervalSeconds * Math.pow(this.backoffCoefficient, numberOfTries - 2));
        result = this.maximumRetryIntervalSeconds > -1L ? Math.min(result, this.maximumRetryIntervalSeconds) : result;
        int secondsSinceFirstAttempt = (int)((recordedFailure.getTime() - firstAttempt.getTime()) / 1000L);
        if (this.retryExpirationIntervalSeconds > -1L && (long)secondsSinceFirstAttempt + result >= this.retryExpirationIntervalSeconds) {
            return -1L;
        }
        return result;
    }

    public void validate() throws IllegalStateException {
        if (this.maximumRetryIntervalSeconds > -1L && this.initialRetryIntervalSeconds > this.maximumRetryIntervalSeconds) {
            throw new IllegalStateException("ExponentialRetryPolicy requires maximumRetryIntervalSeconds to have a value larger than initialRetryIntervalSeconds.");
        }
        if (this.retryExpirationIntervalSeconds > -1L && this.initialRetryIntervalSeconds > this.retryExpirationIntervalSeconds) {
            throw new IllegalStateException("ExponentialRetryPolicy requires retryExpirationIntervalSeconds to have a value larger than initialRetryIntervalSeconds.");
        }
    }
}

