/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.video.v1.RecordingDeleter;
import com.twilio.rest.video.v1.RecordingFetcher;
import com.twilio.rest.video.v1.RecordingReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Recording
extends Resource {
    private static final long serialVersionUID = 75716728838736L;
    private final String accountSid;
    private final Status status;
    private final DateTime dateCreated;
    private final String sid;
    private final String sourceSid;
    private final Long size;
    private final URI url;
    private final Type type;
    private final Integer duration;
    private final Format containerFormat;
    private final Codec codec;
    private final Map<String, Object> groupingSids;
    private final String trackName;
    private final Long offset;
    private final Map<String, String> links;

    public static RecordingFetcher fetcher(String pathSid) {
        return new RecordingFetcher(pathSid);
    }

    public static RecordingReader reader() {
        return new RecordingReader();
    }

    public static RecordingDeleter deleter(String pathSid) {
        return new RecordingDeleter(pathSid);
    }

    public static Recording fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Recording.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Recording fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Recording.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Recording(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="status") Status status, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="sid") String sid, @JsonProperty(value="source_sid") String sourceSid, @JsonProperty(value="size") Long size, @JsonProperty(value="url") URI url, @JsonProperty(value="type") Type type, @JsonProperty(value="duration") Integer duration, @JsonProperty(value="container_format") Format containerFormat, @JsonProperty(value="codec") Codec codec, @JsonProperty(value="grouping_sids") Map<String, Object> groupingSids, @JsonProperty(value="track_name") String trackName, @JsonProperty(value="offset") Long offset, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.status = status;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.sid = sid;
        this.sourceSid = sourceSid;
        this.size = size;
        this.url = url;
        this.type = type;
        this.duration = duration;
        this.containerFormat = containerFormat;
        this.codec = codec;
        this.groupingSids = groupingSids;
        this.trackName = trackName;
        this.offset = offset;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getSourceSid() {
        return this.sourceSid;
    }

    public final Long getSize() {
        return this.size;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Type getType() {
        return this.type;
    }

    public final Integer getDuration() {
        return this.duration;
    }

    public final Format getContainerFormat() {
        return this.containerFormat;
    }

    public final Codec getCodec() {
        return this.codec;
    }

    public final Map<String, Object> getGroupingSids() {
        return this.groupingSids;
    }

    public final String getTrackName() {
        return this.trackName;
    }

    public final Long getOffset() {
        return this.offset;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recording other = (Recording)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.sid, other.sid) && Objects.equals(this.sourceSid, other.sourceSid) && Objects.equals(this.size, other.size) && Objects.equals(this.url, other.url) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.duration, other.duration) && Objects.equals((Object)this.containerFormat, (Object)other.containerFormat) && Objects.equals((Object)this.codec, (Object)other.codec) && Objects.equals(this.groupingSids, other.groupingSids) && Objects.equals(this.trackName, other.trackName) && Objects.equals(this.offset, other.offset) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.status, this.dateCreated, this.sid, this.sourceSid, this.size, this.url, this.type, this.duration, this.containerFormat, this.codec, this.groupingSids, this.trackName, this.offset, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("status", (Object)this.status).add("dateCreated", this.dateCreated).add("sid", this.sid).add("sourceSid", this.sourceSid).add("size", this.size).add("url", this.url).add("type", (Object)this.type).add("duration", this.duration).add("containerFormat", (Object)this.containerFormat).add("codec", (Object)this.codec).add("groupingSids", this.groupingSids).add("trackName", this.trackName).add("offset", this.offset).add("links", this.links).toString();
    }

    public static enum Codec {
        VP8("VP8"),
        H264("H264"),
        OPUS("OPUS"),
        PCMU("PCMU");

        private final String value;

        private Codec(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Codec forValue(String value) {
            return (Codec)Promoter.enumFromString((String)value, (Enum[])Codec.values());
        }
    }

    public static enum Format {
        MKA("mka"),
        MKV("mkv");

        private final String value;

        private Format(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Format forValue(String value) {
            return (Format)Promoter.enumFromString((String)value, (Enum[])Format.values());
        }
    }

    public static enum Type {
        AUDIO("audio"),
        VIDEO("video"),
        DATA("data");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Type forValue(String value) {
            return (Type)Promoter.enumFromString((String)value, (Enum[])Type.values());
        }
    }

    public static enum Status {
        PROCESSING("processing"),
        COMPLETED("completed"),
        DELETED("deleted"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

