/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow.execution.executionstep;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.studio.v1.flow.execution.executionstep.ExecutionStepContextFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExecutionStepContext
extends Resource {
    private static final long serialVersionUID = 255055850550863L;
    private final String accountSid;
    private final Map<String, Object> context;
    private final String executionSid;
    private final String flowSid;
    private final String stepSid;
    private final URI url;

    public static ExecutionStepContextFetcher fetcher(String pathFlowSid, String pathExecutionSid, String pathStepSid) {
        return new ExecutionStepContextFetcher(pathFlowSid, pathExecutionSid, pathStepSid);
    }

    public static ExecutionStepContext fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ExecutionStepContext.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ExecutionStepContext fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ExecutionStepContext.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ExecutionStepContext(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="execution_sid") String executionSid, @JsonProperty(value="flow_sid") String flowSid, @JsonProperty(value="step_sid") String stepSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.context = context;
        this.executionSid = executionSid;
        this.flowSid = flowSid;
        this.stepSid = stepSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Map<String, Object> getContext() {
        return this.context;
    }

    public final String getExecutionSid() {
        return this.executionSid;
    }

    public final String getFlowSid() {
        return this.flowSid;
    }

    public final String getStepSid() {
        return this.stepSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionStepContext other = (ExecutionStepContext)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.context, other.context) && Objects.equals(this.executionSid, other.executionSid) && Objects.equals(this.flowSid, other.flowSid) && Objects.equals(this.stepSid, other.stepSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.context, this.executionSid, this.flowSid, this.stepSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("context", this.context).add("executionSid", this.executionSid).add("flowSid", this.flowSid).add("stepSid", this.stepSid).add("url", this.url).toString();
    }
}

