/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v1.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v1.service.Channel;

public class ChannelCreator
extends Creator<Channel> {
    private final String pathServiceSid;
    private String friendlyName;
    private String uniqueName;
    private String attributes;
    private Channel.ChannelType type;

    public ChannelCreator(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public ChannelCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ChannelCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public ChannelCreator setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public ChannelCreator setType(Channel.ChannelType type) {
        this.type = type;
        return this;
    }

    @Override
    public Channel create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.IPMESSAGING.toString(), "/v1/Services/" + this.pathServiceSid + "/Channels", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Channel creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Channel.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.type != null) {
            request.addPostParam("Type", this.type.toString());
        }
    }
}

