package util.notifiers;

import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.AmazonRoute53Client;
import com.amazonaws.services.route53.model.*;
import play.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Leonidas on 11/11/2015.
 */
public class Route53 {

    public static void wat() {
        AmazonRoute53 route53 = new AmazonRoute53Client(new ClasspathPropertiesFileCredentialsProvider());
        ListHostedZonesResult listHostedZonesResult = route53.listHostedZones();
        GetHostedZoneResult hostedZone = route53.getHostedZone(new GetHostedZoneRequest("Z26G1JDQKAKG52"));
        Logger.info(hostedZone.toString()); //OK
        Logger.info(hostedZone.getHostedZone().toString()); //OK
        Logger.info(hostedZone.getHostedZone().getResourceRecordSetCount().toString()); //OK
        Logger.info(hostedZone.getHostedZone().getConfig().toString()); //OK

        ListResourceRecordSetsRequest request = new ListResourceRecordSetsRequest();
        request.setHostedZoneId("Z26G1JDQKAKG52");

        ListResourceRecordSetsResult result = route53.listResourceRecordSets(request);
        List<ResourceRecordSet> recordSets = result.getResourceRecordSets();

        for(ResourceRecordSet recordSet : recordSets) {

            System.out.println(recordSet.toString());
        }

        //hostedZone.getHostedZone()
    }

    public static void createRecordSetFromHostedZone(String subdomain) {

        AmazonRoute53 route53 = new AmazonRoute53Client(new ClasspathPropertiesFileCredentialsProvider());

        List<ResourceRecord> cnameRecords = new ArrayList<>();
        ResourceRecord cnameRecord = new ResourceRecord();
        cnameRecord.setValue("mailgun.org");
        cnameRecords.add(cnameRecord);

        ResourceRecordSet recordSet = new ResourceRecordSet();
        recordSet.setName("email."+subdomain+".userlists.syndromi.gr.");
        recordSet.setType(RRType.CNAME);
        recordSet.setTTL(300L);
        recordSet.setResourceRecords(cnameRecords);

        List<ResourceRecord> txtRecords = new ArrayList<>();
        ResourceRecord txtRecord = new ResourceRecord();
        txtRecord.setValue("\"v=spf1 include:mailgun.org ~all\"");
        txtRecords.add(txtRecord);

        ResourceRecordSet txtRecordSet = new ResourceRecordSet();
        txtRecordSet.setName(subdomain+".userlists.syndromi.gr.");
        txtRecordSet.setType(RRType.TXT);
        txtRecordSet.setTTL(300L);
        txtRecordSet.setResourceRecords(txtRecords);



        // Create the Change
        List<Change> changes = new ArrayList<>();
        Change cnameChange = new Change();
        cnameChange.setAction(ChangeAction.CREATE);
        cnameChange.setResourceRecordSet(recordSet);
        changes.add(cnameChange);

        Change txtChange = new Change();
        txtChange.setAction(ChangeAction.CREATE);
        txtChange.setResourceRecordSet(txtRecordSet);
        changes.add(txtChange);

        // Create a batch and add the change to it
        ChangeBatch batch = new ChangeBatch();
        batch.setChanges(changes);

        // Create a Request and add the batch to it.
        ChangeResourceRecordSetsRequest request = new ChangeResourceRecordSetsRequest();
        request.setHostedZoneId("Z26G1JDQKAKG52");
        request.setChangeBatch(batch);

        try {
            // send the request
            ChangeResourceRecordSetsResult result = route53.changeResourceRecordSets(request);
            Logger.info(result.toString());
        }catch (InvalidChangeBatchException jee){
            Logger.warn("Caught execution exception while requesting change");
            if (!jee.getMessage().contains("but it already exists")) {
                Logger.error(jee.getMessage(),jee);
                throw new RuntimeException("Amazon route 53 probs");
            }
        }

    }

}
