package util;

import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import play.Play;

/**
 * Created by Leonidas on 19/02/2015.
 */
public class S3Provider {
    private static AmazonS3 s3;
    public static String DEFAULTBUCKET= Play.configuration.getProperty("S3Bucket");
    public static String PUBLICBUCKET= Play.configuration.getProperty("S3PublicBucket");

    //Hiding constructor
    private S3Provider() {
    }

    public static AmazonS3 getS3() {
        if (s3 == null) {
            s3 = new AmazonS3Client(new ClasspathPropertiesFileCredentialsProvider());
        }
        return s3;
    }
}