package models.projects;

import models.Expense;

import javax.persistence.Embeddable;
import javax.persistence.OneToMany;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by dom on 13/12/2018.
 */

@Embeddable
public class ProjectFinancialInfo implements Serializable {

    public BigDecimal cost;
    public BigDecimal downpayment;
    public String paymentType; // 1:CASH FULL AMOUNT 2:BY INSTALLMENTS

    public String financialState; //1: NO PAYMENT 2:PARTIALY PAID 3: FULLY PAID

    @OneToMany
    public List<Expense> projectExpenses = new ArrayList<>();

    public ProjectFinancialInfo() {

    }

    public ProjectFinancialInfo(BigDecimal cost, BigDecimal downpayment, String paymentType, String financialState) {
        this.cost = cost;
        this.downpayment = downpayment;
        this.paymentType = paymentType;
        this.financialState = financialState;
    }
}
