package models.projects;

import com.google.gson.annotations.Expose;
import models.*;
import models.contacts.Person;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.mvc.Router;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by dom on 15/12/2018.
 * //απο εδω θα μπορούμε να τραβήξουμε timelines/calendar/to do lists για ένα project ή για πολλά να έχει εικόνα του τι έχει να κάνει
 */
@Entity
public class Deliverable extends Task {


    @Searchable
    public String deliverableInfo;

    @OneToMany
    public List<Document> attachments = new ArrayList<>();

    @OneToMany
    public List<Share> shares = new ArrayList<>();

    public Deliverable()
    {

    }


    public boolean isAssignedToDel(Long userId) {
        AppUser user = AppUser.findById(userId);
        Share share =  Share.find("select s from Share s where user =:usr and deliverable =:del")
                .setParameter("usr", user)
                .setParameter("del", this).first();
        if (share == null) {
            return false;
        } else {
            return true;
        }

    }

    @Override
    public DateTime getStartDate() {
        return endDate;
    }

    @Override
    public JSONEvent getEvent() {
        JSONEvent event = new JSONEvent(getStartDate().toDate(), getTitle(), getCalendarContent(), "#CD8E46", this.getUrl(), this.getUploadedBy(), this.getClass());
        return event;
    }

    @Override
    public String getUrl() {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.project.id);
        return Router.getFullUrl("Projects.addProject", map);
    }

}
