package models;

import models.projects.Project;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import play.db.jpa.Model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import java.math.BigDecimal;

/**
 * Created by dom on 13/12/2018.
 */
@Entity
public class Expense extends Model{

    public BigDecimal amount;
    @ManyToOne
    public Project forProject;

    public boolean isPaid;

    @Column
    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime dueDate;

    @Column
    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime datePaid;


    public String description;

    @Column
    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime createDate;

    @ManyToOne
    public AppUser uploader;
}
