package models;

import com.amazonaws.services.s3.model.*;

import play.db.jpa.Model;
import play.libs.WS;
import util.S3Provider;

import javax.persistence.Embeddable;
import javax.persistence.Entity;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;

//import static config.GlobalConfig.CLOUDFRONT_URL;
//import static config.GlobalConfig.THUMB_URL;

/**
 * Holder class for files stored in S3
 */
@Embeddable
public class CFile{

    public URL url;
    public String filename;

    public S3ObjectInputStream file() throws FileNotFoundException {
        S3Object object = S3Provider.getS3().getObject(new GetObjectRequest(S3Provider.DEFAULTBUCKET, filename));
        return object.getObjectContent();
    }

    public CFile() {
    }

    public CFile(File file) throws MalformedURLException {
        this.filename = UUID.randomUUID().toString();
        String bucketName = S3Provider.PUBLICBUCKET;
        S3Provider.getS3().putObject(new PutObjectRequest(bucketName, filename, file).withCannedAcl(CannedAccessControlList.PublicRead));
        url= new URL("https://s3-eu-west-1.amazonaws.com/" + bucketName + "/" + filename);
    }


    public CFile(String targetURL){
        String bucketName = S3Provider.DEFAULTBUCKET;
        createFile(targetURL, bucketName, false);
    }

    private void createFile(String targetURL, String bucketName, boolean isPublic) {
        this.filename = UUID.randomUUID().toString();
        InputStream photostream = WS.url(targetURL).get().getStream();
        ObjectMetadata metadata = new ObjectMetadata();
        bucketName = S3Provider.PUBLICBUCKET;
        S3Provider.getS3().putObject(new PutObjectRequest(bucketName, filename, photostream,metadata).withCannedAcl(CannedAccessControlList.PublicRead));
//        if (isPublic) {
//            S3Provider.getS3().putObject(new PutObjectRequest(bucketName, filename, photostream, metadata).withCannedAcl(CannedAccessControlList.PublicRead));
//        }else{
//            S3Provider.getS3().putObject(new PutObjectRequest(bucketName, filename, photostream, metadata).withCannedAcl(CannedAccessControlList.AuthenticatedRead));
//        }
        try {
            url= new URL("https://s3-eu-west-1.amazonaws.com/" + bucketName + "/" + filename);
        } catch (MalformedURLException e) {
            throw new RuntimeException("Malformed url");
        }
    }

    public static CFile createPublic(String targetURL){
        CFile cFile = new CFile();
        cFile.createFile(targetURL,S3Provider.PUBLICBUCKET, true);
        return cFile;
    }

    public static CFile createPrivate(String targetURL) {
        CFile cFile = new CFile();
        cFile.createFile(targetURL,S3Provider.DEFAULTBUCKET, false);
        return cFile;
    }

    public String thumb(int height, int width){
//        if (!GlobalConfig.getInstance().isThumbotFrontUp()) {
//            return url.toString();
//        }else if(!GlobalConfig.getInstance().isCloudFrontUp())
//        {
//            return THUMB_URL+""+height+"x"+width+"/"+url;
//        }
//        return CLOUDFRONT_URL+"unsafe/"+height+"x"+width+"/"+url;

        return"";
    }

    public void permDelete(){
        String bucketName = S3Provider.PUBLICBUCKET;
        S3Provider.getS3().deleteObject(new DeleteObjectRequest(bucketName,filename));
    }
}
