package models;

import models.contacts.Contact;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import play.data.validation.Required;
import play.db.jpa.Model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;

/**
 * Created by dom on 4/12/2018.
 */
@Entity
public class Appointment extends Model{

    public String description;
    public String location; //IF not completed the location of the contact offices is used

    @ManyToOne
    @Required
    public Contact appointmentWith;

    @ManyToOne
    public Company company;
    @Column
    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime createDate;

    @ManyToOne
    public AppUser uploader;

    public Appointment()
    {

    }
}
