/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.utils.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.util.Arrays;

public final class ReflectionUtils {
    private static final ReflectPermission SUPPRESS_ACCESS_CHECKS = new ReflectPermission("suppressAccessChecks");

    private ReflectionUtils() {
    }

    public static boolean isPrivateAccessAllowed() {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            try {
                manager.checkPermission(SUPPRESS_ACCESS_CHECKS);
            }
            catch (SecurityException ex) {
                return false;
            }
        }
        return true;
    }

    public static Field findField(Class<?> clazz, String fieldName) {
        for (Class<?> typeBeingSearched = clazz; typeBeingSearched != null && !typeBeingSearched.equals(Object.class); typeBeingSearched = typeBeingSearched.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = typeBeingSearched.getDeclaredFields()) {
                if (!fieldName.equals(field.getName())) continue;
                return field;
            }
        }
        throw new IllegalStateException("Field (" + fieldName + ") could not be found in " + clazz.getName());
    }

    public static <A> Constructor<A> findConstructor(Class<A> clazz, Class<?> ... paramTypes) {
        Constructor<A> constructor;
        try {
            constructor = clazz.getDeclaredConstructor(paramTypes);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Constructor for (" + clazz.getName() + ") could not be accessed");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Constructor for (" + clazz.getName() + ") could not be found");
        }
        return constructor;
    }

    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        for (Class<?> typeBeingSearched = clazz; typeBeingSearched != null; typeBeingSearched = typeBeingSearched.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = typeBeingSearched.isInterface() ? typeBeingSearched.getMethods() : typeBeingSearched.getDeclaredMethods()) {
                if (!methodName.equals(method.getName()) || !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        throw new IllegalStateException("Method (" + methodName + ") could not be found in " + clazz.getName());
    }

    public static Object getFieldValue(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unexpected exception accessing field {" + field.getName() + "} of {" + field.getDeclaringClass() + "} : " + e.getMessage());
        }
    }
}

