/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared;

import java.sql.Timestamp;
import java.util.TimeZone;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.TimestampType;
import org.jadira.usertype.spi.shared.AbstractColumnMapper;
import org.jadira.usertype.spi.shared.ColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.timezone.proxy.TimeZoneProvidingSharedSessionContractImplementor;

public abstract class AbstractTimestampColumnMapper<T>
extends AbstractColumnMapper<T, Timestamp>
implements ColumnMapper<T, Timestamp>,
DatabaseZoneConfigured {
    private static final long serialVersionUID = -3070239764121234482L;
    private TimeZone databaseZone;

    public final TimestampType getHibernateType() {
        return TimestampType.INSTANCE;
    }

    @Override
    public final int getSqlType() {
        return 93;
    }

    @Override
    public abstract T fromNonNullValue(Timestamp var1);

    @Override
    public abstract T fromNonNullString(String var1);

    @Override
    public abstract Timestamp toNonNullValue(T var1);

    @Override
    public abstract String toNonNullString(T var1);

    @Override
    public void setDatabaseZone(TimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public TimeZone parseZone(String zoneString) {
        return TimeZone.getTimeZone(zoneString);
    }

    @Override
    public TimeZone getDatabaseZone() {
        return this.databaseZone;
    }

    @Override
    public SharedSessionContractImplementor wrapSession(SharedSessionContractImplementor session) {
        SharedSessionContractImplementor mySession = this.databaseZone != null ? new TimeZoneProvidingSharedSessionContractImplementor(session, this.databaseZone) : session;
        return mySession;
    }
}

