/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.jta;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.omg.CORBA.SystemException;
import org.springframework.jndi.JndiTemplate;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.jta.WebSphereUowTransactionManager;

public class SpringWebSphereUowTransactionManager
extends WebSphereUowTransactionManager {
    private static final long serialVersionUID = 4838070722625854290L;
    private static final String UOW_SYNCHRONIZATION_REGISTRY_JNDINAME = "java:comp/websphere/UOWSynchronizationRegistry";
    private static final String USER_TRANASCTION_JNDINAME = "java:comp/UserTransaction";
    private static final Field UOW_FIELD;

    public void afterPropertiesSet() throws TransactionSystemException {
        super.afterPropertiesSet();
        this.setTransactionManager(new TransactionManagerAdapter(this.getJndiTemplate(), this.retrieveUowManager()));
        this.setUserTransactionName(USER_TRANASCTION_JNDINAME);
    }

    private Object retrieveUowManager() {
        try {
            Object uowManager = UOW_FIELD.get((Object)this);
            return uowManager;
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Not permitted to access WebSphereUowTransactionManager: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unexpected argument accessing WebSphereUowTransactionManager: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unexpected exception accessing WebSphereUowTransactionManager: " + e.getMessage(), e);
        }
    }

    static {
        try {
            UOW_FIELD = WebSphereUowTransactionManager.class.getDeclaredField("uowManager");
            UOW_FIELD.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Not permitted to access WebSphereUowTransactionManager: " + e.getMessage(), e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Could not find WebSphereUowTransactionManager: " + e.getMessage(), e);
        }
    }

    public static class TransactionManagerAdapter
    implements TransactionManager {
        private final JndiTemplate jndiTemplate;
        private final Object uowManager;
        private final Class<?> uowManagerClass;
        private final Object uowSynchronizationRegistry;
        private final Class<?> uowSynchronizationRegistryClass;
        private final Method registerSynchronizationMethod;
        private final Method setRollbackOnlyMethod;
        private final Class<?> extendedJTATransactionClass;
        private final Method getLocalIdMethod;

        private TransactionManagerAdapter(JndiTemplate jndiTemplate, Object uowManager) {
            try {
                this.uowManagerClass = Class.forName("com.ibm.ws.uow.UOWManager");
                this.uowSynchronizationRegistry = jndiTemplate.lookup(SpringWebSphereUowTransactionManager.UOW_SYNCHRONIZATION_REGISTRY_JNDINAME);
                this.uowSynchronizationRegistryClass = Class.forName("com.ibm.websphere.uow.UOWSynchronizationRegistry");
                this.registerSynchronizationMethod = this.uowSynchronizationRegistryClass.getMethod("registerInterposedSynchronization", Synchronization.class);
                this.setRollbackOnlyMethod = this.uowManagerClass.getMethod("setRollbackOnly", new Class[0]);
                this.extendedJTATransactionClass = Class.forName("com.ibm.websphere.jtaextensions.ExtendedJTATransaction");
                this.getLocalIdMethod = this.extendedJTATransactionClass.getMethod("getLocalId", null);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find required WebSphere class: " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Could not find required method: " + e.getMessage(), e);
            }
            catch (NamingException e) {
                throw new IllegalStateException("Problem accessing JNDI: " + e.getMessage(), e);
            }
            this.jndiTemplate = jndiTemplate;
            this.uowManager = uowManager;
        }

        public void begin() {
            throw new UnsupportedOperationException("begin() is not supported");
        }

        public void commit() {
            throw new UnsupportedOperationException("commit() is not supported");
        }

        public int getStatus() {
            throw new UnsupportedOperationException("getStatus() is not supported");
        }

        public void resume(Transaction txn) {
            throw new UnsupportedOperationException("resume() is not supported");
        }

        public void rollback() {
            throw new UnsupportedOperationException("rollback() is not supported");
        }

        public void setTransactionTimeout(int i) {
            throw new UnsupportedOperationException("setTransactionTimeout() is not supported");
        }

        public Transaction suspend() {
            throw new UnsupportedOperationException("suspend() is not supported");
        }

        public void setRollbackOnly() throws IllegalStateException {
            try {
                this.setRollbackOnlyMethod.invoke(this.uowManager, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not access setRollbackOnly() on UOWManager: " + e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Could not invoke setRollbackOnly() on UOWManager: " + e.getMessage(), e);
            }
        }

        public Transaction getTransaction() {
            return new TransactionAdapter(this.jndiTemplate);
        }

        public class TransactionAdapter
        implements Transaction {
            private final Object extendedJTATransaction;

            private TransactionAdapter(JndiTemplate template) {
                try {
                    this.extendedJTATransaction = template.lookup("java:comp/websphere/ExtendedJTATransaction");
                }
                catch (NamingException e) {
                    throw new IllegalStateException("Could not find ExtendedJTATransaction in JNDI: " + e.getMessage(), e);
                }
            }

            public void registerSynchronization(Synchronization synchronization) {
                try {
                    TransactionManagerAdapter.this.registerSynchronizationMethod.invoke(TransactionManagerAdapter.this.uowSynchronizationRegistry, synchronization);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Unexpected argument accessing UOWSynchronizationRegistry: " + e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Unexpected exception accessing UOWSynchronizationRegistry: " + e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Could not invoke registerSynchronization() on UOWSynchronizationRegistry: " + e.getMessage(), e);
                }
            }

            public void commit() {
                throw new UnsupportedOperationException("commit() is not supported");
            }

            public boolean delistResource(XAResource resource, int i) {
                throw new UnsupportedOperationException("delistResource() is not supported");
            }

            public boolean enlistResource(XAResource resource) {
                throw new UnsupportedOperationException("enlistResource() is not supported");
            }

            public int getStatus() {
                if (0 == this.getLocalId()) {
                    return 6;
                }
                return 0;
            }

            public void rollback() throws IllegalStateException, SystemException {
                throw new UnsupportedOperationException("rollback() is not supported");
            }

            public void setRollbackOnly() {
                try {
                    TransactionManagerAdapter.this.setRollbackOnlyMethod.invoke(TransactionManagerAdapter.this.uowManager, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Unexpected argument accessing UOWManager: " + e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Unexpected exception accessing UOWManager: " + e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Could not invoke setRollbackOnly() on UOWManager: " + e.getMessage(), e);
                }
            }

            public int hashCode() {
                return this.getLocalId();
            }

            public boolean equals(Object other) {
                if (!(other instanceof TransactionAdapter)) {
                    return false;
                }
                TransactionAdapter that = (TransactionAdapter)other;
                return this.getLocalId() == that.getLocalId();
            }

            private int getLocalId() {
                try {
                    return (Integer)TransactionManagerAdapter.this.getLocalIdMethod.invoke(this.extendedJTATransaction, (Object[])null);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Unexpected argument accessing ExtendedJTATransaction: " + e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Unexpected exception accessing ExtendedJTATransaction: " + e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Could not invoke getLocalId() on ExtendedJTATransaction: " + e.getMessage(), e);
                }
            }
        }
    }
}

