/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtHandler;
import io.jsonwebtoken.JwtHandlerAdapter;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.PrematureJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.DefaultClaims;
import io.jsonwebtoken.impl.DefaultHeader;
import io.jsonwebtoken.impl.DefaultJws;
import io.jsonwebtoken.impl.DefaultJwsHeader;
import io.jsonwebtoken.impl.DefaultJwt;
import io.jsonwebtoken.impl.TextCodec;
import io.jsonwebtoken.impl.crypto.DefaultJwtSignatureValidator;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Strings;
import java.io.IOException;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;

public class DefaultJwtParser
implements JwtParser {
    private static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private ObjectMapper objectMapper = new ObjectMapper();
    private byte[] keyBytes;
    private Key key;
    private SigningKeyResolver signingKeyResolver;

    @Override
    public JwtParser setSigningKey(byte[] key) {
        Assert.notEmpty(key, "signing key cannot be null or empty.");
        this.keyBytes = key;
        return this;
    }

    @Override
    public JwtParser setSigningKey(String base64EncodedKeyBytes) {
        Assert.hasText(base64EncodedKeyBytes, "signing key cannot be null or empty.");
        this.keyBytes = TextCodec.BASE64.decode(base64EncodedKeyBytes);
        return this;
    }

    @Override
    public JwtParser setSigningKey(Key key) {
        Assert.notNull(key, "signing key cannot be null.");
        this.key = key;
        return this;
    }

    @Override
    public JwtParser setSigningKeyResolver(SigningKeyResolver signingKeyResolver) {
        Assert.notNull(signingKeyResolver, "SigningKeyResolver cannot be null.");
        this.signingKeyResolver = signingKeyResolver;
        return this;
    }

    @Override
    public boolean isSigned(String jwt) {
        if (jwt == null) {
            return false;
        }
        int delimiterCount = 0;
        for (int i = 0; i < jwt.length(); ++i) {
            char c = jwt.charAt(i);
            if (delimiterCount == 2) {
                return !Character.isWhitespace(c) && c != '.';
            }
            if (c != '.') continue;
            ++delimiterCount;
        }
        return false;
    }

    @Override
    public Jwt parse(String jwt) throws ExpiredJwtException, MalformedJwtException, SignatureException {
        Object body;
        Assert.hasText(jwt, "JWT String argument cannot be null or empty.");
        String base64UrlEncodedHeader = null;
        String base64UrlEncodedPayload = null;
        String base64UrlEncodedDigest = null;
        int delimiterCount = 0;
        StringBuilder sb = new StringBuilder(128);
        for (char c : jwt.toCharArray()) {
            if (c == '.') {
                String token = Strings.clean(sb.toString());
                if (delimiterCount == 0) {
                    base64UrlEncodedHeader = token;
                } else if (delimiterCount == 1) {
                    base64UrlEncodedPayload = token;
                }
                ++delimiterCount;
                sb = new StringBuilder(128);
                continue;
            }
            sb.append(c);
        }
        if (delimiterCount != 2) {
            String msg = "JWT strings must contain exactly 2 period characters. Found: " + delimiterCount;
            throw new MalformedJwtException(msg);
        }
        if (sb.length() > 0) {
            base64UrlEncodedDigest = sb.toString();
        }
        if (base64UrlEncodedPayload == null) {
            throw new MalformedJwtException("JWT string '" + jwt + "' is missing a body/payload.");
        }
        DefaultHeader header = null;
        if (base64UrlEncodedHeader != null) {
            String origValue = TextCodec.BASE64URL.decodeToString(base64UrlEncodedHeader);
            Map<String, Object> m = this.readValue(origValue);
            header = base64UrlEncodedDigest != null ? new DefaultJwsHeader(m) : new DefaultHeader(m);
        }
        String payload = TextCodec.BASE64URL.decodeToString(base64UrlEncodedPayload);
        Claims claims = null;
        if (payload.charAt(0) == '{' && payload.charAt(payload.length() - 1) == '}') {
            Map<String, Object> claimsMap = this.readValue(payload);
            claims = new DefaultClaims(claimsMap);
        }
        if (claims != null) {
            SimpleDateFormat sdf;
            Date now = null;
            Date exp = claims.getExpiration();
            if (exp != null && ((now = new Date()).equals(exp) || now.after(exp))) {
                sdf = new SimpleDateFormat(ISO_8601_FORMAT);
                String expVal = sdf.format(exp);
                String nowVal = sdf.format(now);
                String msg = "JWT expired at " + expVal + ". Current time: " + nowVal;
                throw new ExpiredJwtException(msg);
            }
            Date nbf = claims.getNotBefore();
            if (nbf != null) {
                if (now == null) {
                    now = new Date();
                }
                if (now.before(nbf)) {
                    sdf = new SimpleDateFormat(ISO_8601_FORMAT);
                    String nbfVal = sdf.format(nbf);
                    String nowVal = sdf.format(now);
                    String msg = "JWT must not be accepted before " + nbfVal + ". Current time: " + nowVal;
                    throw new PrematureJwtException(msg);
                }
            }
        }
        if (base64UrlEncodedDigest != null) {
            String alg;
            JwsHeader jwsHeader = header;
            SignatureAlgorithm algorithm = null;
            if (header != null && Strings.hasText(alg = jwsHeader.getAlgorithm())) {
                algorithm = SignatureAlgorithm.forName(alg);
            }
            if (algorithm == null || algorithm == SignatureAlgorithm.NONE) {
                String msg = "JWT string has a digest/signature, but the header does not reference a valid signature algorithm.";
                throw new MalformedJwtException(msg);
            }
            if (this.key != null && this.keyBytes != null) {
                throw new IllegalStateException("A key object and key bytes cannot both be specified. Choose either.");
            }
            if ((this.key != null || this.keyBytes != null) && this.signingKeyResolver != null) {
                String object = this.key != null ? "a key object" : "key bytes";
                throw new IllegalStateException("A signing key resolver and " + object + " cannot both be specified. Choose either.");
            }
            Key key = this.key;
            if (key == null) {
                byte[] keyBytes = this.keyBytes;
                if (Objects.isEmpty(keyBytes) && this.signingKeyResolver != null) {
                    key = claims != null ? this.signingKeyResolver.resolveSigningKey(jwsHeader, claims) : this.signingKeyResolver.resolveSigningKey(jwsHeader, payload);
                }
                if (!Objects.isEmpty(keyBytes)) {
                    Assert.isTrue(!algorithm.isRsa(), "Key bytes cannot be specified for RSA signatures.  Please specify a PublicKey or PrivateKey instance.");
                    key = new SecretKeySpec(keyBytes, algorithm.getJcaName());
                }
            }
            Assert.notNull(key, "A signing key must be specified if the specified JWT is digitally signed.");
            String jwtWithoutSignature = base64UrlEncodedHeader + '.' + base64UrlEncodedPayload;
            DefaultJwtSignatureValidator validator = new DefaultJwtSignatureValidator(algorithm, key);
            if (!validator.isValid(jwtWithoutSignature, base64UrlEncodedDigest)) {
                String msg = "JWT signature does not match locally computed signature. JWT validity cannot be asserted and should not be trusted.";
                throw new SignatureException(msg);
            }
        }
        Object object = body = claims != null ? claims : payload;
        if (base64UrlEncodedDigest != null) {
            return new DefaultJws<Object>((JwsHeader)((Object)header), body, base64UrlEncodedDigest);
        }
        return new DefaultJwt<Object>(header, body);
    }

    @Override
    public <T> T parse(String compact, JwtHandler<T> handler) throws ExpiredJwtException, MalformedJwtException, SignatureException {
        Assert.notNull(handler, "JwtHandler argument cannot be null.");
        Assert.hasText(compact, "JWT String argument cannot be null or empty.");
        Jwt jwt = this.parse(compact);
        if (jwt instanceof Jws) {
            Jws jws = (Jws)jwt;
            Object body = jws.getBody();
            if (body instanceof Claims) {
                return handler.onClaimsJws(jws);
            }
            return handler.onPlaintextJws(jws);
        }
        Object body = jwt.getBody();
        if (body instanceof Claims) {
            return handler.onClaimsJwt(jwt);
        }
        return handler.onPlaintextJwt(jwt);
    }

    @Override
    public Jwt<Header, String> parsePlaintextJwt(String plaintextJwt) {
        return this.parse(plaintextJwt, new JwtHandlerAdapter<Jwt<Header, String>>(){

            @Override
            public Jwt<Header, String> onPlaintextJwt(Jwt<Header, String> jwt) {
                return jwt;
            }
        });
    }

    @Override
    public Jwt<Header, Claims> parseClaimsJwt(String claimsJwt) {
        try {
            return this.parse(claimsJwt, new JwtHandlerAdapter<Jwt<Header, Claims>>(){

                @Override
                public Jwt<Header, Claims> onClaimsJwt(Jwt<Header, Claims> jwt) {
                    return jwt;
                }
            });
        }
        catch (IllegalArgumentException iae) {
            throw new UnsupportedJwtException("Signed JWSs are not supported.", iae);
        }
    }

    @Override
    public Jws<String> parsePlaintextJws(String plaintextJws) {
        try {
            return this.parse(plaintextJws, new JwtHandlerAdapter<Jws<String>>(){

                @Override
                public Jws<String> onPlaintextJws(Jws<String> jws) {
                    return jws;
                }
            });
        }
        catch (IllegalArgumentException iae) {
            throw new UnsupportedJwtException("Signed JWSs are not supported.", iae);
        }
    }

    @Override
    public Jws<Claims> parseClaimsJws(String claimsJws) {
        return this.parse(claimsJws, new JwtHandlerAdapter<Jws<Claims>>(){

            @Override
            public Jws<Claims> onClaimsJws(Jws<Claims> jws) {
                return jws;
            }
        });
    }

    protected Map<String, Object> readValue(String val) {
        try {
            return this.objectMapper.readValue(val, Map.class);
        }
        catch (IOException e) {
            throw new MalformedJwtException("Unable to read JSON value: " + val, e);
        }
    }
}

