/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.twilio.twiml.TwiML;
import com.twilio.twiml.voice.SsmlBreak;
import com.twilio.twiml.voice.SsmlEmphasis;
import com.twilio.twiml.voice.SsmlLang;
import com.twilio.twiml.voice.SsmlP;
import com.twilio.twiml.voice.SsmlPhoneme;
import com.twilio.twiml.voice.SsmlProsody;
import com.twilio.twiml.voice.SsmlS;
import com.twilio.twiml.voice.SsmlSayAs;
import com.twilio.twiml.voice.SsmlSub;
import com.twilio.twiml.voice.SsmlW;
import java.util.HashMap;
import java.util.Map;

public class Say
extends TwiML {
    private final Voice voice;
    private final Integer loop;
    private final Language language;
    private final String message;

    private Say() {
        this(new Builder());
    }

    private Say(Builder b) {
        super("Say", b);
        this.voice = b.voice;
        this.loop = b.loop;
        this.language = b.language;
        this.message = b.message;
    }

    @Override
    protected String getElementBody() {
        return this.getMessage() == null ? null : this.getMessage();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getVoice() != null) {
            attrs.put("voice", this.getVoice().toString());
        }
        if (this.getLoop() != null) {
            attrs.put("loop", this.getLoop().toString());
        }
        if (this.getLanguage() != null) {
            attrs.put("language", this.getLanguage().toString());
        }
        return attrs;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public Integer getLoop() {
        return this.loop;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getMessage() {
        return this.message;
    }

    public static class Builder
    extends TwiML.Builder<Builder> {
        private Voice voice;
        private Integer loop;
        private Language language;
        private String message;

        public Builder(String message) {
            this.message = message;
        }

        public Builder() {
        }

        public Builder voice(Voice voice) {
            this.voice = voice;
            return this;
        }

        public Builder loop(Integer loop) {
            this.loop = loop;
            return this;
        }

        public Builder language(Language language) {
            this.language = language;
            return this;
        }

        public Builder ssmlBreak(SsmlBreak ssmlBreak) {
            this.children.add(ssmlBreak);
            return this;
        }

        public Builder ssmlEmphasis(SsmlEmphasis ssmlEmphasis) {
            this.children.add(ssmlEmphasis);
            return this;
        }

        public Builder ssmlLang(SsmlLang ssmlLang) {
            this.children.add(ssmlLang);
            return this;
        }

        public Builder ssmlP(SsmlP ssmlP) {
            this.children.add(ssmlP);
            return this;
        }

        public Builder ssmlPhoneme(SsmlPhoneme ssmlPhoneme) {
            this.children.add(ssmlPhoneme);
            return this;
        }

        public Builder ssmlProsody(SsmlProsody ssmlProsody) {
            this.children.add(ssmlProsody);
            return this;
        }

        public Builder ssmlS(SsmlS ssmlS) {
            this.children.add(ssmlS);
            return this;
        }

        public Builder ssmlSayAs(SsmlSayAs ssmlSayAs) {
            this.children.add(ssmlSayAs);
            return this;
        }

        public Builder ssmlSub(SsmlSub ssmlSub) {
            this.children.add(ssmlSub);
            return this;
        }

        public Builder ssmlW(SsmlW ssmlW) {
            this.children.add(ssmlW);
            return this;
        }

        public Say build() {
            return new Say(this);
        }
    }

    public static enum Language {
        DA_DK("da-DK"),
        DE_DE("de-DE"),
        EN_AU("en-AU"),
        EN_CA("en-CA"),
        EN_GB("en-GB"),
        EN_IN("en-IN"),
        EN_US("en-US"),
        CA_ES("ca-ES"),
        ES_ES("es-ES"),
        ES_MX("es-MX"),
        FI_FI("fi-FI"),
        FR_CA("fr-CA"),
        FR_FR("fr-FR"),
        IT_IT("it-IT"),
        JA_JP("ja-JP"),
        KO_KR("ko-KR"),
        NB_NO("nb-NO"),
        NL_NL("nl-NL"),
        PL_PL("pl-PL"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT"),
        RU_RU("ru-RU"),
        SV_SE("sv-SE"),
        ZH_CN("zh-CN"),
        ZH_HK("zh-HK"),
        ZH_TW("zh-TW");

        private final String value;

        private Language(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Voice {
        MAN("man"),
        WOMAN("woman"),
        ALICE("alice"),
        POLLY_GERAINT("Polly.Geraint"),
        POLLY_GWYNETH("Polly.Gwyneth"),
        POLLY_MADS("Polly.Mads"),
        POLLY_NAJA("Polly.Naja"),
        POLLY_HANS("Polly.Hans"),
        POLLY_MARLENE("Polly.Marlene"),
        POLLY_NICOLE("Polly.Nicole"),
        POLLY_RUSSELL("Polly.Russell"),
        POLLY_AMY("Polly.Amy"),
        POLLY_BRIAN("Polly.Brian"),
        POLLY_EMMA("Polly.Emma"),
        POLLY_RAVEENA("Polly.Raveena"),
        POLLY_IVY("Polly.Ivy"),
        POLLY_JOANNA("Polly.Joanna"),
        POLLY_JOEY("Polly.Joey"),
        POLLY_JUSTIN("Polly.Justin"),
        POLLY_KENDRA("Polly.Kendra"),
        POLLY_KIMBERLY("Polly.Kimberly"),
        POLLY_MATTHEW("Polly.Matthew"),
        POLLY_SALLI("Polly.Salli"),
        POLLY_CONCHITA("Polly.Conchita"),
        POLLY_ENRIQUE("Polly.Enrique"),
        POLLY_MIGUEL("Polly.Miguel"),
        POLLY_PENELOPE("Polly.Penelope"),
        POLLY_CHANTAL("Polly.Chantal"),
        POLLY_CELINE("Polly.Celine"),
        POLLY_MATHIEU("Polly.Mathieu"),
        POLLY_DORA("Polly.Dora"),
        POLLY_KARL("Polly.Karl"),
        POLLY_CARLA("Polly.Carla"),
        POLLY_GIORGIO("Polly.Giorgio"),
        POLLY_MIZUKI("Polly.Mizuki"),
        POLLY_LIV("Polly.Liv"),
        POLLY_LOTTE("Polly.Lotte"),
        POLLY_RUBEN("Polly.Ruben"),
        POLLY_EWA("Polly.Ewa"),
        POLLY_JACEK("Polly.Jacek"),
        POLLY_JAN("Polly.Jan"),
        POLLY_MAJA("Polly.Maja"),
        POLLY_RICARDO("Polly.Ricardo"),
        POLLY_VITORIA("Polly.Vitoria"),
        POLLY_CRISTIANO("Polly.Cristiano"),
        POLLY_INES("Polly.Ines"),
        POLLY_CARMEN("Polly.Carmen"),
        POLLY_MAXIM("Polly.Maxim"),
        POLLY_TATYANA("Polly.Tatyana"),
        POLLY_ASTRID("Polly.Astrid"),
        POLLY_FILIZ("Polly.Filiz"),
        POLLY_VICKI("Polly.Vicki"),
        POLLY_TAKUMI("Polly.Takumi"),
        POLLY_SEOYEON("Polly.Seoyeon"),
        POLLY_ADITI("Polly.Aditi");

        private final String value;

        private Voice(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

