/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1.trunk;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trunking.v1.trunk.PhoneNumber;

public class PhoneNumberReader
extends Reader<PhoneNumber> {
    private final String pathTrunkSid;

    public PhoneNumberReader(String pathTrunkSid) {
        this.pathTrunkSid = pathTrunkSid;
    }

    @Override
    public ResourceSet<PhoneNumber> read(TwilioRestClient client) {
        return new ResourceSet<PhoneNumber>(this, client, this.firstPage(client));
    }

    @Override
    public Page<PhoneNumber> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.TRUNKING.toString(), "/v1/Trunks/" + this.pathTrunkSid + "/PhoneNumbers", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<PhoneNumber> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<PhoneNumber> nextPage(Page<PhoneNumber> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TRUNKING.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<PhoneNumber> previousPage(Page<PhoneNumber> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.TRUNKING.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<PhoneNumber> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PhoneNumber read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("phone_numbers", response.getContent(), PhoneNumber.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

