/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.worker.WorkersCumulativeStatisticsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkersCumulativeStatistics
extends Resource {
    private static final long serialVersionUID = 89273605202076L;
    private final String accountSid;
    private final DateTime startTime;
    private final DateTime endTime;
    private final List<Map<String, Object>> activityDurations;
    private final Integer reservationsCreated;
    private final Integer reservationsAccepted;
    private final Integer reservationsRejected;
    private final Integer reservationsTimedOut;
    private final Integer reservationsCanceled;
    private final Integer reservationsRescinded;
    private final String workspaceSid;
    private final URI url;

    public static WorkersCumulativeStatisticsFetcher fetcher(String pathWorkspaceSid) {
        return new WorkersCumulativeStatisticsFetcher(pathWorkspaceSid);
    }

    public static WorkersCumulativeStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, WorkersCumulativeStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static WorkersCumulativeStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, WorkersCumulativeStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private WorkersCumulativeStatistics(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="start_time") String startTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="activity_durations") List<Map<String, Object>> activityDurations, @JsonProperty(value="reservations_created") Integer reservationsCreated, @JsonProperty(value="reservations_accepted") Integer reservationsAccepted, @JsonProperty(value="reservations_rejected") Integer reservationsRejected, @JsonProperty(value="reservations_timed_out") Integer reservationsTimedOut, @JsonProperty(value="reservations_canceled") Integer reservationsCanceled, @JsonProperty(value="reservations_rescinded") Integer reservationsRescinded, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.startTime = DateConverter.iso8601DateTimeFromString(startTime);
        this.endTime = DateConverter.iso8601DateTimeFromString(endTime);
        this.activityDurations = activityDurations;
        this.reservationsCreated = reservationsCreated;
        this.reservationsAccepted = reservationsAccepted;
        this.reservationsRejected = reservationsRejected;
        this.reservationsTimedOut = reservationsTimedOut;
        this.reservationsCanceled = reservationsCanceled;
        this.reservationsRescinded = reservationsRescinded;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getStartTime() {
        return this.startTime;
    }

    public final DateTime getEndTime() {
        return this.endTime;
    }

    public final List<Map<String, Object>> getActivityDurations() {
        return this.activityDurations;
    }

    public final Integer getReservationsCreated() {
        return this.reservationsCreated;
    }

    public final Integer getReservationsAccepted() {
        return this.reservationsAccepted;
    }

    public final Integer getReservationsRejected() {
        return this.reservationsRejected;
    }

    public final Integer getReservationsTimedOut() {
        return this.reservationsTimedOut;
    }

    public final Integer getReservationsCanceled() {
        return this.reservationsCanceled;
    }

    public final Integer getReservationsRescinded() {
        return this.reservationsRescinded;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkersCumulativeStatistics other = (WorkersCumulativeStatistics)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.activityDurations, other.activityDurations) && Objects.equals(this.reservationsCreated, other.reservationsCreated) && Objects.equals(this.reservationsAccepted, other.reservationsAccepted) && Objects.equals(this.reservationsRejected, other.reservationsRejected) && Objects.equals(this.reservationsTimedOut, other.reservationsTimedOut) && Objects.equals(this.reservationsCanceled, other.reservationsCanceled) && Objects.equals(this.reservationsRescinded, other.reservationsRescinded) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.startTime, this.endTime, this.activityDurations, this.reservationsCreated, this.reservationsAccepted, this.reservationsRejected, this.reservationsTimedOut, this.reservationsCanceled, this.reservationsRescinded, this.workspaceSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("startTime", this.startTime).add("endTime", this.endTime).add("activityDurations", this.activityDurations).add("reservationsCreated", this.reservationsCreated).add("reservationsAccepted", this.reservationsAccepted).add("reservationsRejected", this.reservationsRejected).add("reservationsTimedOut", this.reservationsTimedOut).add("reservationsCanceled", this.reservationsCanceled).add("reservationsRescinded", this.reservationsRescinded).add("workspaceSid", this.workspaceSid).add("url", this.url).toString();
    }
}

