/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.taskqueue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.taskqueue.TaskQueueRealTimeStatisticsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskQueueRealTimeStatistics
extends Resource {
    private static final long serialVersionUID = 165753411245187L;
    private final String accountSid;
    private final List<Map<String, Object>> activityStatistics;
    private final Integer longestTaskWaitingAge;
    private final String taskQueueSid;
    private final Map<String, Object> tasksByPriority;
    private final Map<String, Object> tasksByStatus;
    private final Integer totalAvailableWorkers;
    private final Integer totalEligibleWorkers;
    private final Integer totalTasks;
    private final String workspaceSid;
    private final URI url;

    public static TaskQueueRealTimeStatisticsFetcher fetcher(String pathWorkspaceSid, String pathTaskQueueSid) {
        return new TaskQueueRealTimeStatisticsFetcher(pathWorkspaceSid, pathTaskQueueSid);
    }

    public static TaskQueueRealTimeStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TaskQueueRealTimeStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TaskQueueRealTimeStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TaskQueueRealTimeStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TaskQueueRealTimeStatistics(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="activity_statistics") List<Map<String, Object>> activityStatistics, @JsonProperty(value="longest_task_waiting_age") Integer longestTaskWaitingAge, @JsonProperty(value="task_queue_sid") String taskQueueSid, @JsonProperty(value="tasks_by_priority") Map<String, Object> tasksByPriority, @JsonProperty(value="tasks_by_status") Map<String, Object> tasksByStatus, @JsonProperty(value="total_available_workers") Integer totalAvailableWorkers, @JsonProperty(value="total_eligible_workers") Integer totalEligibleWorkers, @JsonProperty(value="total_tasks") Integer totalTasks, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.activityStatistics = activityStatistics;
        this.longestTaskWaitingAge = longestTaskWaitingAge;
        this.taskQueueSid = taskQueueSid;
        this.tasksByPriority = tasksByPriority;
        this.tasksByStatus = tasksByStatus;
        this.totalAvailableWorkers = totalAvailableWorkers;
        this.totalEligibleWorkers = totalEligibleWorkers;
        this.totalTasks = totalTasks;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final List<Map<String, Object>> getActivityStatistics() {
        return this.activityStatistics;
    }

    public final Integer getLongestTaskWaitingAge() {
        return this.longestTaskWaitingAge;
    }

    public final String getTaskQueueSid() {
        return this.taskQueueSid;
    }

    public final Map<String, Object> getTasksByPriority() {
        return this.tasksByPriority;
    }

    public final Map<String, Object> getTasksByStatus() {
        return this.tasksByStatus;
    }

    public final Integer getTotalAvailableWorkers() {
        return this.totalAvailableWorkers;
    }

    public final Integer getTotalEligibleWorkers() {
        return this.totalEligibleWorkers;
    }

    public final Integer getTotalTasks() {
        return this.totalTasks;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskQueueRealTimeStatistics other = (TaskQueueRealTimeStatistics)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.activityStatistics, other.activityStatistics) && Objects.equals(this.longestTaskWaitingAge, other.longestTaskWaitingAge) && Objects.equals(this.taskQueueSid, other.taskQueueSid) && Objects.equals(this.tasksByPriority, other.tasksByPriority) && Objects.equals(this.tasksByStatus, other.tasksByStatus) && Objects.equals(this.totalAvailableWorkers, other.totalAvailableWorkers) && Objects.equals(this.totalEligibleWorkers, other.totalEligibleWorkers) && Objects.equals(this.totalTasks, other.totalTasks) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.activityStatistics, this.longestTaskWaitingAge, this.taskQueueSid, this.tasksByPriority, this.tasksByStatus, this.totalAvailableWorkers, this.totalEligibleWorkers, this.totalTasks, this.workspaceSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("activityStatistics", this.activityStatistics).add("longestTaskWaitingAge", this.longestTaskWaitingAge).add("taskQueueSid", this.taskQueueSid).add("tasksByPriority", this.tasksByPriority).add("tasksByStatus", this.tasksByStatus).add("totalAvailableWorkers", this.totalAvailableWorkers).add("totalEligibleWorkers", this.totalEligibleWorkers).add("totalTasks", this.totalTasks).add("workspaceSid", this.workspaceSid).add("url", this.url).toString();
    }
}

