/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.task.ReservationFetcher;
import com.twilio.rest.taskrouter.v1.workspace.task.ReservationReader;
import com.twilio.rest.taskrouter.v1.workspace.task.ReservationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Reservation
extends Resource {
    private static final long serialVersionUID = 63448280807644L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Status reservationStatus;
    private final String sid;
    private final String taskSid;
    private final String workerName;
    private final String workerSid;
    private final String workspaceSid;
    private final URI url;
    private final Map<String, String> links;

    public static ReservationReader reader(String pathWorkspaceSid, String pathTaskSid) {
        return new ReservationReader(pathWorkspaceSid, pathTaskSid);
    }

    public static ReservationFetcher fetcher(String pathWorkspaceSid, String pathTaskSid, String pathSid) {
        return new ReservationFetcher(pathWorkspaceSid, pathTaskSid, pathSid);
    }

    public static ReservationUpdater updater(String pathWorkspaceSid, String pathTaskSid, String pathSid) {
        return new ReservationUpdater(pathWorkspaceSid, pathTaskSid, pathSid);
    }

    public static Reservation fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Reservation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Reservation fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Reservation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Reservation(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="reservation_status") Status reservationStatus, @JsonProperty(value="sid") String sid, @JsonProperty(value="task_sid") String taskSid, @JsonProperty(value="worker_name") String workerName, @JsonProperty(value="worker_sid") String workerSid, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.reservationStatus = reservationStatus;
        this.sid = sid;
        this.taskSid = taskSid;
        this.workerName = workerName;
        this.workerSid = workerSid;
        this.workspaceSid = workspaceSid;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Status getReservationStatus() {
        return this.reservationStatus;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getTaskSid() {
        return this.taskSid;
    }

    public final String getWorkerName() {
        return this.workerName;
    }

    public final String getWorkerSid() {
        return this.workerSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reservation other = (Reservation)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals((Object)this.reservationStatus, (Object)other.reservationStatus) && Objects.equals(this.sid, other.sid) && Objects.equals(this.taskSid, other.taskSid) && Objects.equals(this.workerName, other.workerName) && Objects.equals(this.workerSid, other.workerSid) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.dateCreated, this.dateUpdated, this.reservationStatus, this.sid, this.taskSid, this.workerName, this.workerSid, this.workspaceSid, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("reservationStatus", (Object)this.reservationStatus).add("sid", this.sid).add("taskSid", this.taskSid).add("workerName", this.workerName).add("workerSid", this.workerSid).add("workspaceSid", this.workspaceSid).add("url", this.url).add("links", this.links).toString();
    }

    public static enum SupervisorMode {
        MONITOR("monitor"),
        WHISPER("whisper"),
        BARGE("barge");

        private final String value;

        private SupervisorMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static SupervisorMode forValue(String value) {
            return (SupervisorMode)Promoter.enumFromString((String)value, (Enum[])SupervisorMode.values());
        }
    }

    public static enum ConferenceEvent {
        START("start"),
        END("end"),
        JOIN("join"),
        LEAVE("leave"),
        MUTE("mute"),
        HOLD("hold"),
        SPEAKER("speaker");

        private final String value;

        private ConferenceEvent(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ConferenceEvent forValue(String value) {
            return (ConferenceEvent)Promoter.enumFromString((String)value, (Enum[])ConferenceEvent.values());
        }
    }

    public static enum CallStatus {
        INITIATED("initiated"),
        RINGING("ringing"),
        ANSWERED("answered"),
        COMPLETED("completed");

        private final String value;

        private CallStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static CallStatus forValue(String value) {
            return (CallStatus)Promoter.enumFromString((String)value, (Enum[])CallStatus.values());
        }
    }

    public static enum Status {
        PENDING("pending"),
        ACCEPTED("accepted"),
        REJECTED("rejected"),
        TIMEOUT("timeout"),
        CANCELED("canceled"),
        RESCINDED("rescinded"),
        WRAPPING("wrapping"),
        COMPLETED("completed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

