/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.TaskQueue;

public class TaskQueueCreator
extends Creator<TaskQueue> {
    private final String pathWorkspaceSid;
    private final String friendlyName;
    private String targetWorkers;
    private Integer maxReservedWorkers;
    private TaskQueue.TaskOrder taskOrder;
    private String reservationActivitySid;
    private String assignmentActivitySid;

    public TaskQueueCreator(String pathWorkspaceSid, String friendlyName) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.friendlyName = friendlyName;
    }

    public TaskQueueCreator setTargetWorkers(String targetWorkers) {
        this.targetWorkers = targetWorkers;
        return this;
    }

    public TaskQueueCreator setMaxReservedWorkers(Integer maxReservedWorkers) {
        this.maxReservedWorkers = maxReservedWorkers;
        return this;
    }

    public TaskQueueCreator setTaskOrder(TaskQueue.TaskOrder taskOrder) {
        this.taskOrder = taskOrder;
        return this;
    }

    public TaskQueueCreator setReservationActivitySid(String reservationActivitySid) {
        this.reservationActivitySid = reservationActivitySid;
        return this;
    }

    public TaskQueueCreator setAssignmentActivitySid(String assignmentActivitySid) {
        this.assignmentActivitySid = assignmentActivitySid;
        return this;
    }

    @Override
    public TaskQueue create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/TaskQueues", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskQueue creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return TaskQueue.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.targetWorkers != null) {
            request.addPostParam("TargetWorkers", this.targetWorkers);
        }
        if (this.maxReservedWorkers != null) {
            request.addPostParam("MaxReservedWorkers", this.maxReservedWorkers.toString());
        }
        if (this.taskOrder != null) {
            request.addPostParam("TaskOrder", this.taskOrder.toString());
        }
        if (this.reservationActivitySid != null) {
            request.addPostParam("ReservationActivitySid", this.reservationActivitySid);
        }
        if (this.assignmentActivitySid != null) {
            request.addPostParam("AssignmentActivitySid", this.assignmentActivitySid);
        }
    }
}

