/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.EventFetcher;
import com.twilio.rest.taskrouter.v1.workspace.EventReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Event
extends Resource {
    private static final long serialVersionUID = 208699778685630L;
    private final String accountSid;
    private final String actorSid;
    private final String actorType;
    private final URI actorUrl;
    private final String description;
    private final Map<String, String> eventData;
    private final DateTime eventDate;
    private final String eventType;
    private final String resourceSid;
    private final String resourceType;
    private final URI resourceUrl;
    private final String sid;
    private final String source;
    private final String sourceIpAddress;
    private final URI url;

    public static EventFetcher fetcher(String pathWorkspaceSid, String pathSid) {
        return new EventFetcher(pathWorkspaceSid, pathSid);
    }

    public static EventReader reader(String pathWorkspaceSid) {
        return new EventReader(pathWorkspaceSid);
    }

    public static Event fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Event.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Event fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Event.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Event(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="actor_sid") String actorSid, @JsonProperty(value="actor_type") String actorType, @JsonProperty(value="actor_url") URI actorUrl, @JsonProperty(value="description") String description, @JsonProperty(value="event_data") Map<String, String> eventData, @JsonProperty(value="event_date") String eventDate, @JsonProperty(value="event_type") String eventType, @JsonProperty(value="resource_sid") String resourceSid, @JsonProperty(value="resource_type") String resourceType, @JsonProperty(value="resource_url") URI resourceUrl, @JsonProperty(value="sid") String sid, @JsonProperty(value="source") String source, @JsonProperty(value="source_ip_address") String sourceIpAddress, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.actorSid = actorSid;
        this.actorType = actorType;
        this.actorUrl = actorUrl;
        this.description = description;
        this.eventData = eventData;
        this.eventDate = DateConverter.iso8601DateTimeFromString(eventDate);
        this.eventType = eventType;
        this.resourceSid = resourceSid;
        this.resourceType = resourceType;
        this.resourceUrl = resourceUrl;
        this.sid = sid;
        this.source = source;
        this.sourceIpAddress = sourceIpAddress;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getActorSid() {
        return this.actorSid;
    }

    public final String getActorType() {
        return this.actorType;
    }

    public final URI getActorUrl() {
        return this.actorUrl;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Map<String, String> getEventData() {
        return this.eventData;
    }

    public final DateTime getEventDate() {
        return this.eventDate;
    }

    public final String getEventType() {
        return this.eventType;
    }

    public final String getResourceSid() {
        return this.resourceSid;
    }

    public final String getResourceType() {
        return this.resourceType;
    }

    public final URI getResourceUrl() {
        return this.resourceUrl;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getSource() {
        return this.source;
    }

    public final String getSourceIpAddress() {
        return this.sourceIpAddress;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event other = (Event)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.actorSid, other.actorSid) && Objects.equals(this.actorType, other.actorType) && Objects.equals(this.actorUrl, other.actorUrl) && Objects.equals(this.description, other.description) && Objects.equals(this.eventData, other.eventData) && Objects.equals(this.eventDate, other.eventDate) && Objects.equals(this.eventType, other.eventType) && Objects.equals(this.resourceSid, other.resourceSid) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.resourceUrl, other.resourceUrl) && Objects.equals(this.sid, other.sid) && Objects.equals(this.source, other.source) && Objects.equals(this.sourceIpAddress, other.sourceIpAddress) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.actorSid, this.actorType, this.actorUrl, this.description, this.eventData, this.eventDate, this.eventType, this.resourceSid, this.resourceType, this.resourceUrl, this.sid, this.source, this.sourceIpAddress, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("actorSid", this.actorSid).add("actorType", this.actorType).add("actorUrl", this.actorUrl).add("description", this.description).add("eventData", this.eventData).add("eventDate", this.eventDate).add("eventType", this.eventType).add("resourceSid", this.resourceSid).add("resourceType", this.resourceType).add("resourceUrl", this.resourceUrl).add("sid", this.sid).add("source", this.source).add("sourceIpAddress", this.sourceIpAddress).add("url", this.url).toString();
    }
}

