/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.proxy.v1.ServiceCreator;
import com.twilio.rest.proxy.v1.ServiceDeleter;
import com.twilio.rest.proxy.v1.ServiceFetcher;
import com.twilio.rest.proxy.v1.ServiceReader;
import com.twilio.rest.proxy.v1.ServiceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Service
extends Resource {
    private static final long serialVersionUID = 93456310387892L;
    private final String sid;
    private final String uniqueName;
    private final String accountSid;
    private final String chatInstanceSid;
    private final URI callbackUrl;
    private final Integer defaultTtl;
    private final NumberSelectionBehavior numberSelectionBehavior;
    private final GeoMatchLevel geoMatchLevel;
    private final URI interceptCallbackUrl;
    private final URI outOfSessionCallbackUrl;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static ServiceFetcher fetcher(String pathSid) {
        return new ServiceFetcher(pathSid);
    }

    public static ServiceReader reader() {
        return new ServiceReader();
    }

    public static ServiceCreator creator(String uniqueName) {
        return new ServiceCreator(uniqueName);
    }

    public static ServiceDeleter deleter(String pathSid) {
        return new ServiceDeleter(pathSid);
    }

    public static ServiceUpdater updater(String pathSid) {
        return new ServiceUpdater(pathSid);
    }

    public static Service fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Service fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Service(@JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="chat_instance_sid") String chatInstanceSid, @JsonProperty(value="callback_url") URI callbackUrl, @JsonProperty(value="default_ttl") Integer defaultTtl, @JsonProperty(value="number_selection_behavior") NumberSelectionBehavior numberSelectionBehavior, @JsonProperty(value="geo_match_level") GeoMatchLevel geoMatchLevel, @JsonProperty(value="intercept_callback_url") URI interceptCallbackUrl, @JsonProperty(value="out_of_session_callback_url") URI outOfSessionCallbackUrl, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.accountSid = accountSid;
        this.chatInstanceSid = chatInstanceSid;
        this.callbackUrl = callbackUrl;
        this.defaultTtl = defaultTtl;
        this.numberSelectionBehavior = numberSelectionBehavior;
        this.geoMatchLevel = geoMatchLevel;
        this.interceptCallbackUrl = interceptCallbackUrl;
        this.outOfSessionCallbackUrl = outOfSessionCallbackUrl;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChatInstanceSid() {
        return this.chatInstanceSid;
    }

    public final URI getCallbackUrl() {
        return this.callbackUrl;
    }

    public final Integer getDefaultTtl() {
        return this.defaultTtl;
    }

    public final NumberSelectionBehavior getNumberSelectionBehavior() {
        return this.numberSelectionBehavior;
    }

    public final GeoMatchLevel getGeoMatchLevel() {
        return this.geoMatchLevel;
    }

    public final URI getInterceptCallbackUrl() {
        return this.interceptCallbackUrl;
    }

    public final URI getOutOfSessionCallbackUrl() {
        return this.outOfSessionCallbackUrl;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service other = (Service)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.chatInstanceSid, other.chatInstanceSid) && Objects.equals(this.callbackUrl, other.callbackUrl) && Objects.equals(this.defaultTtl, other.defaultTtl) && Objects.equals((Object)this.numberSelectionBehavior, (Object)other.numberSelectionBehavior) && Objects.equals((Object)this.geoMatchLevel, (Object)other.geoMatchLevel) && Objects.equals(this.interceptCallbackUrl, other.interceptCallbackUrl) && Objects.equals(this.outOfSessionCallbackUrl, other.outOfSessionCallbackUrl) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.uniqueName, this.accountSid, this.chatInstanceSid, this.callbackUrl, this.defaultTtl, this.numberSelectionBehavior, this.geoMatchLevel, this.interceptCallbackUrl, this.outOfSessionCallbackUrl, this.dateCreated, this.dateUpdated, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("uniqueName", this.uniqueName).add("accountSid", this.accountSid).add("chatInstanceSid", this.chatInstanceSid).add("callbackUrl", this.callbackUrl).add("defaultTtl", this.defaultTtl).add("numberSelectionBehavior", (Object)this.numberSelectionBehavior).add("geoMatchLevel", (Object)this.geoMatchLevel).add("interceptCallbackUrl", this.interceptCallbackUrl).add("outOfSessionCallbackUrl", this.outOfSessionCallbackUrl).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("url", this.url).add("links", this.links).toString();
    }

    public static enum NumberSelectionBehavior {
        AVOID_STICKY("avoid-sticky"),
        PREFER_STICKY("prefer-sticky");

        private final String value;

        private NumberSelectionBehavior(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static NumberSelectionBehavior forValue(String value) {
            return (NumberSelectionBehavior)Promoter.enumFromString((String)value, (Enum[])NumberSelectionBehavior.values());
        }
    }

    public static enum GeoMatchLevel {
        AREA_CODE("area-code"),
        OVERLAY("overlay"),
        RADIUS("radius"),
        COUNTRY("country");

        private final String value;

        private GeoMatchLevel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static GeoMatchLevel forValue(String value) {
            return (GeoMatchLevel)Promoter.enumFromString((String)value, (Enum[])GeoMatchLevel.values());
        }
    }
}

