/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant.task;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.understand.assistant.task.TaskStatistics;

public class TaskStatisticsFetcher
extends Fetcher<TaskStatistics> {
    private final String pathAssistantSid;
    private final String pathTaskSid;

    public TaskStatisticsFetcher(String pathAssistantSid, String pathTaskSid) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathTaskSid = pathTaskSid;
    }

    @Override
    public TaskStatistics fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/understand/Assistants/" + this.pathAssistantSid + "/Tasks/" + this.pathTaskSid + "/Statistics", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskStatistics fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return TaskStatistics.fromJson(response.getStream(), client.getObjectMapper());
    }
}

