/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.understand.assistant.task.FieldCreator;
import com.twilio.rest.preview.understand.assistant.task.FieldDeleter;
import com.twilio.rest.preview.understand.assistant.task.FieldFetcher;
import com.twilio.rest.preview.understand.assistant.task.FieldReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Field
extends Resource {
    private static final long serialVersionUID = 236424306351624L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String fieldType;
    private final String taskSid;
    private final String assistantSid;
    private final String sid;
    private final String uniqueName;
    private final URI url;

    public static FieldFetcher fetcher(String pathAssistantSid, String pathTaskSid, String pathSid) {
        return new FieldFetcher(pathAssistantSid, pathTaskSid, pathSid);
    }

    public static FieldReader reader(String pathAssistantSid, String pathTaskSid) {
        return new FieldReader(pathAssistantSid, pathTaskSid);
    }

    public static FieldCreator creator(String pathAssistantSid, String pathTaskSid, String fieldType, String uniqueName) {
        return new FieldCreator(pathAssistantSid, pathTaskSid, fieldType, uniqueName);
    }

    public static FieldDeleter deleter(String pathAssistantSid, String pathTaskSid, String pathSid) {
        return new FieldDeleter(pathAssistantSid, pathTaskSid, pathSid);
    }

    public static Field fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Field.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Field fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Field.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Field(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="field_type") String fieldType, @JsonProperty(value="task_sid") String taskSid, @JsonProperty(value="assistant_sid") String assistantSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.fieldType = fieldType;
        this.taskSid = taskSid;
        this.assistantSid = assistantSid;
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFieldType() {
        return this.fieldType;
    }

    public final String getTaskSid() {
        return this.taskSid;
    }

    public final String getAssistantSid() {
        return this.assistantSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field other = (Field)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.fieldType, other.fieldType) && Objects.equals(this.taskSid, other.taskSid) && Objects.equals(this.assistantSid, other.assistantSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.fieldType, this.taskSid, this.assistantSid, this.sid, this.uniqueName, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("fieldType", this.fieldType).add("taskSid", this.taskSid).add("assistantSid", this.assistantSid).add("sid", this.sid).add("uniqueName", this.uniqueName).add("url", this.url).toString();
    }
}

