/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant.fieldtype;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.understand.assistant.fieldtype.FieldValueCreator;
import com.twilio.rest.preview.understand.assistant.fieldtype.FieldValueDeleter;
import com.twilio.rest.preview.understand.assistant.fieldtype.FieldValueFetcher;
import com.twilio.rest.preview.understand.assistant.fieldtype.FieldValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FieldValue
extends Resource {
    private static final long serialVersionUID = 196387084273361L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String fieldTypeSid;
    private final String language;
    private final String assistantSid;
    private final String sid;
    private final String value;
    private final URI url;
    private final String synonymOf;

    public static FieldValueFetcher fetcher(String pathAssistantSid, String pathFieldTypeSid, String pathSid) {
        return new FieldValueFetcher(pathAssistantSid, pathFieldTypeSid, pathSid);
    }

    public static FieldValueReader reader(String pathAssistantSid, String pathFieldTypeSid) {
        return new FieldValueReader(pathAssistantSid, pathFieldTypeSid);
    }

    public static FieldValueCreator creator(String pathAssistantSid, String pathFieldTypeSid, String language, String value) {
        return new FieldValueCreator(pathAssistantSid, pathFieldTypeSid, language, value);
    }

    public static FieldValueDeleter deleter(String pathAssistantSid, String pathFieldTypeSid, String pathSid) {
        return new FieldValueDeleter(pathAssistantSid, pathFieldTypeSid, pathSid);
    }

    public static FieldValue fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, FieldValue.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static FieldValue fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, FieldValue.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private FieldValue(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="field_type_sid") String fieldTypeSid, @JsonProperty(value="language") String language, @JsonProperty(value="assistant_sid") String assistantSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="value") String value, @JsonProperty(value="url") URI url, @JsonProperty(value="synonym_of") String synonymOf) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.fieldTypeSid = fieldTypeSid;
        this.language = language;
        this.assistantSid = assistantSid;
        this.sid = sid;
        this.value = value;
        this.url = url;
        this.synonymOf = synonymOf;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFieldTypeSid() {
        return this.fieldTypeSid;
    }

    public final String getLanguage() {
        return this.language;
    }

    public final String getAssistantSid() {
        return this.assistantSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getValue() {
        return this.value;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getSynonymOf() {
        return this.synonymOf;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldValue other = (FieldValue)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.fieldTypeSid, other.fieldTypeSid) && Objects.equals(this.language, other.language) && Objects.equals(this.assistantSid, other.assistantSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.value, other.value) && Objects.equals(this.url, other.url) && Objects.equals(this.synonymOf, other.synonymOf);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.fieldTypeSid, this.language, this.assistantSid, this.sid, this.value, this.url, this.synonymOf);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("fieldTypeSid", this.fieldTypeSid).add("language", this.language).add("assistantSid", this.assistantSid).add("sid", this.sid).add("value", this.value).add("url", this.url).add("synonymOf", this.synonymOf).toString();
    }
}

