/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.notify.v1;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.notify.v1.Service;

public class ServiceUpdater
extends Updater<Service> {
    private final String pathSid;
    private String friendlyName;
    private String apnCredentialSid;
    private String gcmCredentialSid;
    private String messagingServiceSid;
    private String facebookMessengerPageId;
    private String defaultApnNotificationProtocolVersion;
    private String defaultGcmNotificationProtocolVersion;
    private String fcmCredentialSid;
    private String defaultFcmNotificationProtocolVersion;
    private Boolean logEnabled;
    private String alexaSkillId;
    private String defaultAlexaNotificationProtocolVersion;

    public ServiceUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ServiceUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ServiceUpdater setApnCredentialSid(String apnCredentialSid) {
        this.apnCredentialSid = apnCredentialSid;
        return this;
    }

    public ServiceUpdater setGcmCredentialSid(String gcmCredentialSid) {
        this.gcmCredentialSid = gcmCredentialSid;
        return this;
    }

    public ServiceUpdater setMessagingServiceSid(String messagingServiceSid) {
        this.messagingServiceSid = messagingServiceSid;
        return this;
    }

    public ServiceUpdater setFacebookMessengerPageId(String facebookMessengerPageId) {
        this.facebookMessengerPageId = facebookMessengerPageId;
        return this;
    }

    public ServiceUpdater setDefaultApnNotificationProtocolVersion(String defaultApnNotificationProtocolVersion) {
        this.defaultApnNotificationProtocolVersion = defaultApnNotificationProtocolVersion;
        return this;
    }

    public ServiceUpdater setDefaultGcmNotificationProtocolVersion(String defaultGcmNotificationProtocolVersion) {
        this.defaultGcmNotificationProtocolVersion = defaultGcmNotificationProtocolVersion;
        return this;
    }

    public ServiceUpdater setFcmCredentialSid(String fcmCredentialSid) {
        this.fcmCredentialSid = fcmCredentialSid;
        return this;
    }

    public ServiceUpdater setDefaultFcmNotificationProtocolVersion(String defaultFcmNotificationProtocolVersion) {
        this.defaultFcmNotificationProtocolVersion = defaultFcmNotificationProtocolVersion;
        return this;
    }

    public ServiceUpdater setLogEnabled(Boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    public ServiceUpdater setAlexaSkillId(String alexaSkillId) {
        this.alexaSkillId = alexaSkillId;
        return this;
    }

    public ServiceUpdater setDefaultAlexaNotificationProtocolVersion(String defaultAlexaNotificationProtocolVersion) {
        this.defaultAlexaNotificationProtocolVersion = defaultAlexaNotificationProtocolVersion;
        return this;
    }

    @Override
    public Service update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.NOTIFY.toString(), "/v1/Services/" + this.pathSid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.apnCredentialSid != null) {
            request.addPostParam("ApnCredentialSid", this.apnCredentialSid);
        }
        if (this.gcmCredentialSid != null) {
            request.addPostParam("GcmCredentialSid", this.gcmCredentialSid);
        }
        if (this.messagingServiceSid != null) {
            request.addPostParam("MessagingServiceSid", this.messagingServiceSid);
        }
        if (this.facebookMessengerPageId != null) {
            request.addPostParam("FacebookMessengerPageId", this.facebookMessengerPageId);
        }
        if (this.defaultApnNotificationProtocolVersion != null) {
            request.addPostParam("DefaultApnNotificationProtocolVersion", this.defaultApnNotificationProtocolVersion);
        }
        if (this.defaultGcmNotificationProtocolVersion != null) {
            request.addPostParam("DefaultGcmNotificationProtocolVersion", this.defaultGcmNotificationProtocolVersion);
        }
        if (this.fcmCredentialSid != null) {
            request.addPostParam("FcmCredentialSid", this.fcmCredentialSid);
        }
        if (this.defaultFcmNotificationProtocolVersion != null) {
            request.addPostParam("DefaultFcmNotificationProtocolVersion", this.defaultFcmNotificationProtocolVersion);
        }
        if (this.logEnabled != null) {
            request.addPostParam("LogEnabled", this.logEnabled.toString());
        }
        if (this.alexaSkillId != null) {
            request.addPostParam("AlexaSkillId", this.alexaSkillId);
        }
        if (this.defaultAlexaNotificationProtocolVersion != null) {
            request.addPostParam("DefaultAlexaNotificationProtocolVersion", this.defaultAlexaNotificationProtocolVersion);
        }
    }
}

