/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.service.AlphaSender;

public class AlphaSenderReader
extends Reader<AlphaSender> {
    private final String pathServiceSid;

    public AlphaSenderReader(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    @Override
    public ResourceSet<AlphaSender> read(TwilioRestClient client) {
        return new ResourceSet<AlphaSender>(this, client, this.firstPage(client));
    }

    @Override
    public Page<AlphaSender> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.MESSAGING.toString(), "/v1/Services/" + this.pathServiceSid + "/AlphaSenders", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<AlphaSender> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<AlphaSender> nextPage(Page<AlphaSender> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.MESSAGING.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<AlphaSender> previousPage(Page<AlphaSender> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.MESSAGING.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<AlphaSender> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AlphaSender read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("alpha_senders", response.getContent(), AlphaSender.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

